/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Store;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.ComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class ReservationConfigurationView
extends ConfigurationView {
    private Store store;
    private JComboBox cbDefaultOwner;
    private JComboBox cbDefaultOrderType;
    private JComboBox cbDefaultSalesArea;
    private JCheckBox chkMergeReservation;
    private JCheckBox chkSetLoggedInUser;
    List<User> userList = new ArrayList<User>();
    List<OrderType> orderTypeList = new ArrayList<OrderType>();
    List<SalesArea> salesAreaList = new ArrayList<SalesArea>();

    public ReservationConfigurationView(Store store) {
        this.store = store;
        this.initComponents();
        this.initData();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("", "[][]", ""));
        JLabel lblDefaultOwner = new JLabel("Default Owner");
        JLabel lblDefaultOrderType = new JLabel("Default Order Type");
        JLabel lblDefaultSalesArea = new JLabel("Default Sales Area");
        this.cbDefaultOwner = new JComboBox();
        this.cbDefaultOrderType = new JComboBox();
        this.cbDefaultSalesArea = new JComboBox();
        contentPanel.add((Component)lblDefaultOwner, "alignx trailing");
        contentPanel.add((Component)this.cbDefaultOwner, "grow, wrap");
        contentPanel.add((Component)lblDefaultOrderType, "alignx trailing");
        contentPanel.add((Component)this.cbDefaultOrderType, "grow, wrap");
        contentPanel.add((Component)lblDefaultSalesArea, "alignx trailing");
        contentPanel.add((Component)this.cbDefaultSalesArea, "grow, wrap");
        this.chkMergeReservation = new JCheckBox("Merge reservation if same date and member");
        contentPanel.add((Component)this.chkMergeReservation, "skip 1, wrap");
        this.chkSetLoggedInUser = new JCheckBox("Set Logged in user as server/owner");
        contentPanel.add((Component)this.chkSetLoggedInUser, "skip 1,wrap");
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        this.add(scrollPane);
    }

    @Override
    public boolean save() throws Exception {
        if (!this.isInitialized()) {
            return false;
        }
        User selectedUser = (User)this.cbDefaultOwner.getSelectedItem();
        OrderType selectedOrderType = (OrderType)this.cbDefaultOrderType.getSelectedItem();
        SalesArea selectedSalesAres = (SalesArea)this.cbDefaultSalesArea.getSelectedItem();
        if (selectedUser != null) {
            this.store.addProperty("Reservation.owner", selectedUser.getId());
        } else {
            this.store.addProperty("Reservation.owner", null);
        }
        if (selectedOrderType != null) {
            this.store.addProperty("Reservation.ordertype", selectedOrderType.getId());
        } else {
            this.store.addProperty("Reservation.ordertype", null);
        }
        if (selectedSalesAres != null) {
            this.store.addProperty("Reservation.Default_Sales_Area", selectedSalesAres.getId());
        } else {
            this.store.addProperty("Reservation.Default_Sales_Area", null);
        }
        this.store.addProperty("Reservation.Merge_If_Same_Member", String.valueOf(this.chkMergeReservation.isSelected()));
        this.store.addProperty("Reservation.Logged_In_User_As_Owner", String.valueOf(this.chkSetLoggedInUser.isSelected()));
        return true;
    }

    @Override
    public String getName() {
        return "Reservation";
    }

    private void initData() {
        this.userList.add(null);
        this.orderTypeList.add(null);
        this.salesAreaList.add(null);
        this.userList.addAll(UserDAO.getInstance().findAllActive());
        this.orderTypeList.addAll(OrderTypeDAO.getInstance().findAll());
        this.salesAreaList.addAll(SalesAreaDAO.getInstance().findAll());
        this.cbDefaultOwner.setModel(new ComboBoxModel(this.userList));
        this.cbDefaultOrderType.setModel(new ComboBoxModel(this.orderTypeList));
        this.cbDefaultSalesArea.setModel(new ComboBoxModel(this.salesAreaList));
    }

    @Override
    public void initialize() throws Exception {
        this.setInitialized(true);
        String userId = this.store.getProperty("Reservation.owner");
        String orderTypeId = this.store.getProperty("Reservation.ordertype");
        String salesID = this.store.getProperty("Reservation.Default_Sales_Area");
        String merge = this.store.getProperty("Reservation.Merge_If_Same_Member", "true");
        String loggedIn = this.store.getProperty("Reservation.Logged_In_User_As_Owner", "true");
        for (OrderType orderType : this.orderTypeList) {
            OrderType orderType2;
            if (!(orderType instanceof OrderType) || !(orderType2 = orderType).getId().equals(orderTypeId)) continue;
            this.cbDefaultOrderType.setSelectedItem(orderType2);
        }
        for (Comparable comparable : this.userList) {
            User user;
            if (!(comparable instanceof User) || !(user = (User)comparable).getId().equals(userId)) continue;
            this.cbDefaultOwner.setSelectedItem(user);
        }
        for (Comparable comparable : this.salesAreaList) {
            SalesArea salesArea;
            if (!(comparable instanceof SalesArea) || !(salesArea = (SalesArea)comparable).getId().equals(salesID)) continue;
            this.cbDefaultSalesArea.setSelectedItem(salesArea);
        }
        if (Boolean.valueOf(merge).booleanValue()) {
            this.chkMergeReservation.setSelected(true);
        } else {
            this.chkMergeReservation.setSelected(false);
        }
        if (Boolean.valueOf(loggedIn).booleanValue()) {
            this.chkSetLoggedInUser.setSelected(true);
        } else {
            this.chkSetLoggedInUser.setSelected(false);
        }
    }
}

