/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.ChargeConfigurationView;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.config.ui.EmailConfigurationView;
import com.floreantpos.config.ui.ReservationConfigurationView;
import com.floreantpos.config.ui.StoreBrandingConfigurationView;
import com.floreantpos.config.ui.StoreConfigurationView;
import com.floreantpos.config.ui.TicketImportConfigurationView;
import com.floreantpos.config.ui.TipsConfigurationView;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.TicketImportPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;

public class StoreConfigurationDialog
extends POSDialog
implements ChangeListener,
ActionListener {
    private static final String OK = POSConstants.OK;
    private static final String CANCEL = POSConstants.CANCEL;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private List<ConfigurationView> views = new ArrayList<ConfigurationView>();
    private Store store;

    public StoreConfigurationDialog() {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        Application.getInstance().refreshStore();
        this.store = Application.getInstance().getStore();
        this.setTitle(POSConstants.STORE_CONFIGURATION_WINDOW_TITLE);
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("fill", "", "[fill,grow][]"));
        this.tabbedPane.addChangeListener(this);
        contentPanel.add((Component)this.tabbedPane, "span, grow");
        this.addView(new StoreConfigurationView(this.store));
        this.addView(new ChargeConfigurationView(this.store));
        this.addView(new StoreBrandingConfigurationView(this.store));
        this.addView(new TipsConfigurationView(this.store));
        this.addView(new ReservationConfigurationView(this.store));
        this.addView(new EmailConfigurationView(this.store));
        TicketImportPlugin ticketImportPlugin = (TicketImportPlugin)ExtensionManager.getPlugin(TicketImportPlugin.class);
        if (ticketImportPlugin != null) {
            this.addView(new TicketImportConfigurationView());
        }
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        JButton btnCancel = new JButton(CANCEL);
        btnCancel.addActionListener(this);
        bottomPanel.add((Component)btnCancel, "dock east, gaptop 5,gapright 8, gapbottom 10");
        JButton btnOk = new JButton(OK);
        btnOk.addActionListener(this);
        bottomPanel.add((Component)btnOk, "dock east, gapright 5, gaptop 5, gapbottom 10");
        this.add((Component)bottomPanel, "South");
        this.setDefaultCloseOperation(2);
        this.add((Component)contentPanel, "Center");
    }

    public void addView(ConfigurationView view) {
        this.tabbedPane.addTab(view.getName(), view);
        this.views.add(view);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.stateChanged(null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ConfigurationView view = (ConfigurationView)this.tabbedPane.getSelectedComponent();
        try {
            if (!view.isInitialized()) {
                view.initialize();
            }
        }
        catch (PosException e1) {
            POSMessageDialog.showError(this, e1.getMessage());
        }
        catch (Exception e1) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (OK.equalsIgnoreCase(e.getActionCommand())) {
            try {
                for (ConfigurationView view : this.views) {
                    if (!view.isInitialized() || view.save()) continue;
                    return;
                }
                StoreDAO.getInstance().saveOrUpdate(this.store);
                Application.getInstance().refreshStore();
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TerminalConfigurationView.40"));
                this.setCanceled(false);
                this.dispose();
            }
            catch (PosException x) {
                POSMessageDialog.showError(this, x.getMessage());
            }
            catch (Exception x) {
                POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, x);
            }
        } else if (CANCEL.equalsIgnoreCase(e.getActionCommand())) {
            this.setCanceled(true);
            this.dispose();
        }
    }
}

