/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.Store;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class StoreMiscellaneousConfigurationView
extends ConfigurationView {
    private Store store;
    private JCheckBox chkTicketViewDisplaySide;
    private JCheckBox chkHideMiscButtonInOrder;
    private JCheckBox chkHideServerSummaryButtonInUserView;
    private JCheckBox chkShowTaxExemptButtonOnSettlementScreen;
    private JCheckBox chkShowCategoryBreakOut;
    private JCheckBox chkHidePrintButtonInOrderInfoView;
    private JCheckBox chkAdditionalPrintRequiresManagerApproval;

    public StoreMiscellaneousConfigurationView(Store store) {
        this.store = store;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[][grow][]", ""));
        this.chkTicketViewDisplaySide = new JCheckBox(Messages.getString("OrderViewDisplayConfigurationView.0"));
        contentPanel.add((Component)this.chkTicketViewDisplaySide, "skip 1, wrap");
        this.chkHideMiscButtonInOrder = new JCheckBox(Messages.getString("OrderViewDisplayConfigurationView.1"));
        contentPanel.add((Component)this.chkHideMiscButtonInOrder, "skip 1, wrap");
        this.chkHideServerSummaryButtonInUserView = new JCheckBox(Messages.getString("UXConfigurationView.0"));
        contentPanel.add((Component)this.chkHideServerSummaryButtonInUserView, "skip 1, wrap");
        this.chkShowTaxExemptButtonOnSettlementScreen = new JCheckBox(Messages.getString("StoreUXConfigurationView.1"));
        contentPanel.add((Component)this.chkShowTaxExemptButtonOnSettlementScreen, "skip 1, wrap");
        this.chkShowCategoryBreakOut = new JCheckBox(Messages.getString("StoreUXConfigurationView.3"));
        contentPanel.add((Component)this.chkShowCategoryBreakOut, "skip 1, wrap");
        this.chkHidePrintButtonInOrderInfoView = new JCheckBox(Messages.getString("StoreUXConfigurationView.2"));
        contentPanel.add((Component)this.chkHidePrintButtonInOrderInfoView, "skip 1, wrap");
        this.chkAdditionalPrintRequiresManagerApproval = new JCheckBox(Messages.getString("StoreUXConfigurationView.4"));
        contentPanel.add((Component)this.chkAdditionalPrintRequiresManagerApproval, "skip 1, wrap");
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBorder(null);
        this.add(scrollPane);
    }

    @Override
    public boolean save() throws Exception {
        if (!this.isInitialized()) {
            return true;
        }
        this.store.addProperty("order_view.ticket_on_right", String.valueOf(this.chkTicketViewDisplaySide.isSelected()));
        this.store.addProperty("hide_misc_button.in_order", String.valueOf(this.chkHideMiscButtonInOrder.isSelected()));
        this.store.addProperty("hide_server_summary_button.in_user_view", String.valueOf(this.chkHideServerSummaryButtonInUserView.isSelected()));
        this.store.addProperty("show_tax_exempt_button.in_settlement_screen", String.valueOf(this.chkShowTaxExemptButtonOnSettlementScreen.isSelected()));
        this.store.addProperty("show_category_breakout.in_server_Summary", String.valueOf(this.chkShowCategoryBreakOut.isSelected()));
        this.store.addProperty("hide_print_button.in_order_info_view", String.valueOf(this.chkHidePrintButtonInOrderInfoView.isSelected()));
        this.store.addProperty("additional_print_requires.manager_approval", String.valueOf(this.chkAdditionalPrintRequiresManagerApproval.isSelected()));
        return true;
    }

    @Override
    public void initialize() throws Exception {
        this.chkTicketViewDisplaySide.setSelected(this.store.getBooleanProperty("order_view.ticket_on_right", false));
        this.chkHideMiscButtonInOrder.setSelected(this.store.getBooleanProperty("hide_misc_button.in_order", false));
        this.chkHideServerSummaryButtonInUserView.setSelected(this.store.getBooleanProperty("hide_server_summary_button.in_user_view", false));
        this.chkShowTaxExemptButtonOnSettlementScreen.setSelected(POSUtil.getBoolean(this.store.getProperty("show_tax_exempt_button.in_settlement_screen")));
        this.chkShowCategoryBreakOut.setSelected(POSUtil.getBoolean(this.store.getProperty("show_category_breakout.in_server_Summary")));
        this.chkHidePrintButtonInOrderInfoView.setSelected(POSUtil.getBoolean(this.store.getProperty("hide_print_button.in_order_info_view")));
        this.chkAdditionalPrintRequiresManagerApproval.setSelected(POSUtil.getBoolean(this.store.getProperty("additional_print_requires.manager_approval")));
        this.setInitialized(true);
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_UX;
    }
}

