/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.Store;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.YellowDogStore;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.YellowDogStoreDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.foretees.salesforce.sync.SyncDialog;
import com.foretees.salesforce.sync.YellowDogSyncable;
import com.foretees.yellowDog.YellowDogUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class YellowDogConfigurationView
extends ConfigurationView {
    private Store store;
    private JTextField tfClientId;
    private JTextField tfUsername;
    private JPasswordField tfPassword;
    private JTextField tfYellowDogsTokenUrl;
    private JTextField tfYellowDogsFetchUrl;

    public YellowDogConfigurationView(Store store) {
        this.store = store;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel mainPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[][grow]", ""));
        JLabel lblClientId = new JLabel(Messages.getString("YellowDogConfigurationView.0"));
        this.tfClientId = new JTextField();
        JLabel lblUsername = new JLabel(Messages.getString("YellowDogConfigurationView.1"));
        this.tfUsername = new JTextField();
        JLabel lblClientSecret = new JLabel(Messages.getString("YellowDogConfigurationView.2"));
        this.tfPassword = new JPasswordField();
        JLabel lblYellowDogsTokenUrl = new JLabel(Messages.getString("YellowDogConfigurationView.3"));
        this.tfYellowDogsTokenUrl = new JTextField();
        JLabel lblYellowDogsFetchUrl = new JLabel(Messages.getString("YellowDogConfigurationView.4"));
        this.tfYellowDogsFetchUrl = new JTextField();
        mainPanel.add((Component)lblClientId, "alignx trailing");
        mainPanel.add((Component)this.tfClientId, "growx, wrap");
        mainPanel.add((Component)lblUsername, "alignx trailing");
        mainPanel.add((Component)this.tfUsername, "growx, wrap");
        mainPanel.add((Component)lblClientSecret, "alignx trailing");
        mainPanel.add((Component)this.tfPassword, "growx, wrap");
        mainPanel.add((Component)lblYellowDogsTokenUrl, "alignx trailing");
        mainPanel.add((Component)this.tfYellowDogsTokenUrl, "growx, wrap");
        mainPanel.add((Component)lblYellowDogsFetchUrl, "alignx trailing");
        mainPanel.add((Component)this.tfYellowDogsFetchUrl, "growx, wrap");
        this.add((Component)mainPanel, "Center");
        JButton btnSync = new JButton(Messages.getString("YellowDogConfigurationView.6"));
        JButton btnFatchStore = new JButton(Messages.getString("YellowDogConfigurationView.7"));
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        buttonPanel.add(btnFatchStore);
        buttonPanel.add(btnSync);
        btnSync.addActionListener(e -> this.doSyncTicketItem());
        btnFatchStore.addActionListener(e -> this.doFatchStore());
        this.add((Component)buttonPanel, "South");
    }

    protected void doSyncTicketItem() {
        List<TicketItem> activeTicketItems = TicketItemDAO.getInstance().findYellowDogActiveTicketItems();
        YellowDogSyncable syncableTicketItem = new YellowDogSyncable(activeTicketItems);
        SyncDialog dialog = new SyncDialog(syncableTicketItem, Messages.getString("YellowDogConfigurationView.8"));
        syncableTicketItem.setSyncView(dialog);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
    }

    protected void doFatchStore() {
        List<YellowDogStore> yellowDogStores = YellowDogUtil.getYellowDogStore();
        YellowDogStoreDAO instance = YellowDogStoreDAO.getInstance();
        if (yellowDogStores != null) {
            for (YellowDogStore yellowDogStore : yellowDogStores) {
                YellowDogStore dogStore = instance.get(yellowDogStore.getId());
                if (dogStore == null) {
                    instance.save(yellowDogStore);
                    continue;
                }
                dogStore.setName(yellowDogStore.getName());
                dogStore.setCode(yellowDogStore.getCode());
                dogStore.setNoOnHand(yellowDogStore.isNoOnHand());
                dogStore.setRevenueCenter(yellowDogStore.getRevenueCenter());
                dogStore.setNotes(yellowDogStore.getNotes());
                dogStore.setCreated(yellowDogStore.getCreated());
                instance.update(dogStore);
            }
        }
        POSMessageDialog.showMessage(Messages.getString("YellowDogConfigurationView.9"));
    }

    @Override
    public boolean save() {
        try {
            if (!this.isInitialized()) {
                return true;
            }
            return this.updateModel();
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }

    public void updateView() {
        try {
            this.tfClientId.setText(this.store.getClientId());
            this.tfUsername.setText(this.store.getYellowDogUserName());
            this.tfPassword.setText(this.store.getClientPassword());
            this.tfYellowDogsTokenUrl.setText(this.store.getYellowDogsTokenUrl());
            this.tfYellowDogsFetchUrl.setText(this.store.getYellowDogsFetchUrl());
            this.setInitialized(true);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    public boolean updateModel() {
        try {
            this.store.setClientId(this.tfClientId.getText());
            this.store.setClientPassword(String.valueOf(this.tfPassword.getPassword()));
            this.store.setYellowDogUserName(this.tfUsername.getText());
            this.store.setYellowDogsTokenUrl(this.tfYellowDogsTokenUrl.getText());
            this.store.setYellowDogsFetchUrl(this.tfYellowDogsFetchUrl.getText());
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
            return false;
        }
    }

    @Override
    public void initialize() throws Exception {
        this.updateView();
    }

    @Override
    public String getName() {
        return Messages.getString("YellowDogConfigurationView.5");
    }
}

