/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.config.ui.DefaultPosGiftCardConfigurationView;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.ui.views.payment.PosGiftCardProcessor;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import java.awt.Component;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

@PluginImplementation
public class PosGiftCardPlugin
extends GiftCardPaymentPlugin {
    public static final String ID = String.valueOf("OroGiftCard".hashCode());
    protected DefaultPosGiftCardConfigurationView giftCardView;

    public boolean requireLicense() {
        return false;
    }

    public boolean isActivated() {
        return true;
    }

    public String getProductName() {
        return "OroGiftCard";
    }

    public String getName() {
        return this.getProductName();
    }

    public ConfigurationView getConfigurationPane() throws Exception {
        if (this.giftCardView == null) {
            this.giftCardView = new DefaultPosGiftCardConfigurationView();
            this.giftCardView.setMerchantDefaultValue("admin", "123456");
            this.giftCardView.initialize();
        }
        return this.giftCardView;
    }

    public String toString() {
        return this.getProductName();
    }

    public String getId() {
        return ID;
    }

    public GiftCardProcessor getProcessor() {
        return new PosGiftCardProcessor();
    }

    public boolean shouldShowCardInputProcessor() {
        return true;
    }

    public boolean hasValidLicense() {
        return true;
    }

    public String getProductVersion() {
        return "1.0";
    }

    public void pay(Ticket ticket, double tenderAmount, SettleTicketProcessor settleTicketProcessor) throws Exception {
    }

    public void voidPayment(PosTransaction transaction, Session session) {
        String giftCardNo = transaction.getGiftCertNumber();
        if (StringUtils.isEmpty((String)giftCardNo)) {
            throw new PosException(Messages.getString("PosGiftCardPlugin.1"));
        }
        GiftCard giftCard = GiftCardDAO.getInstance().get(giftCardNo);
        if (transaction instanceof RefundTransaction) {
            giftCard.setBalance(giftCard.getBalance() - transaction.getAmount());
        } else {
            giftCard.setBalance(giftCard.getBalance() + transaction.getAmount());
        }
        GiftCardDAO.getInstance().saveOrUpdate(giftCard, session);
    }

    public Component getParent() {
        return null;
    }
}

