/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension;

import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Promotion;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PromotionDAO;
import com.floreantpos.payment.AbstractPaymentPlugin;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.dialog.PromotionSelectionDialog;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import java.util.List;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.hibernate.Session;

@PluginImplementation
public class PromotionPaymentPlugin
extends AbstractPaymentPlugin
implements PostPaymentProcessor {
    public String getName() {
        return "PROMOTION";
    }

    public void pay(Ticket ticket, double tenderAmount, SettleTicketProcessor settleTicketProcessor) throws Exception {
        User currentUser = Application.getCurrentUser();
        if (currentUser == null) {
            throw new PosException("User not found!");
        }
        List<Promotion> promotions = PromotionDAO.getInstance().findPromotions(ticket.getOrderType());
        if (promotions == null || promotions.isEmpty()) {
            throw new PosException("No active promotion found!");
        }
        double dueAmountWithoutTips = ticket.getDueAmount() - ticket.getGratuityAmount();
        PromotionSelectionDialog dialog = new PromotionSelectionDialog(promotions, dueAmountWithoutTips);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        Promotion promotion = dialog.getPromotion();
        if (promotion == null) {
            return;
        }
        Double promotionBalance = promotion.getValue();
        if (Double.isNaN(promotionBalance)) {
            return;
        }
        if (promotionBalance == null || promotionBalance <= 0.0) {
            throw new PosException("Promotion amount is not valid.");
        }
        if (promotion.isPercentageBased().booleanValue()) {
            if (promotionBalance > 100.0) {
                throw new PosException("Percentage should not be more than 100!");
            }
            promotionBalance = dueAmountWithoutTips * promotionBalance / 100.0;
        }
        CustomPaymentTransaction transaction = (CustomPaymentTransaction)PaymentType.PROMOTION.createTransaction(ticket, promotionBalance);
        transaction.setCustomPaymentName(promotion.getName());
        transaction.setCustomPaymentFieldName(promotion.getName());
        transaction.setCustomPaymentRef(promotion.getId());
        transaction.setFinancialAccountSFId(promotion.getFinancialAccountId());
        if (promotionBalance < dueAmountWithoutTips) {
            transaction.setTenderAmount(promotionBalance);
            transaction.setAmount(promotionBalance);
        }
        settleTicketProcessor.settleTicket(transaction, this);
    }

    public void voidPayment(PosTransaction transaction, Session session) {
    }

    @Override
    public void paymentDone(PosTransaction transaction, Session session) {
    }

    public String getProductName() {
        return this.getName();
    }
}

