/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.floreantpos.PosLog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.cronjob.CronJobPlugin;
import com.floreantpos.extension.cronjob.GiftCardCheckerJob;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.dao.CronJobDAO;
import java.util.List;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;

public class OroCronJobManager {
    private static OroCronJobManager oroCronJobManager;
    private SchedulerFactory schedulerFactory;
    private Scheduler scheduler;
    private boolean isStarted;

    private OroCronJobManager() {
        try {
            this.schedulerFactory = new StdSchedulerFactory();
            this.scheduler = this.schedulerFactory.getScheduler();
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), e0);
        }
    }

    public static OroCronJobManager getInstance() {
        return oroCronJobManager == null ? (oroCronJobManager = new OroCronJobManager()) : oroCronJobManager;
    }

    private CronTrigger getCronTriggerFromCronJob(CronJob cronJob, TriggerBuilder triggerBuilder) {
        if (triggerBuilder == null) {
            triggerBuilder = TriggerBuilder.newTrigger().withIdentity(cronJob.getId(), cronJob.getJobId());
        }
        if (cronJob.getFrequency().equalsIgnoreCase("DAILY")) {
            triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.dailyAtHourAndMinute((int)Integer.parseInt(cronJob.getExecutionTime().split(":")[0]), (int)Integer.parseInt(cronJob.getExecutionTime().split(":")[1])));
        } else if (cronJob.getFrequency().equalsIgnoreCase("WEEKLY")) {
            triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.weeklyOnDayAndHourAndMinute((int)1, (int)Integer.parseInt(cronJob.getExecutionTime().split(":")[0]), (int)Integer.parseInt(cronJob.getExecutionTime().split(":")[1])));
        } else if (cronJob.getFrequency().equalsIgnoreCase("MONTHLY")) {
            triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.monthlyOnDayAndHourAndMinute((int)1, (int)Integer.parseInt(cronJob.getExecutionTime().split(":")[0]), (int)Integer.parseInt(cronJob.getExecutionTime().split(":")[1])));
        } else if (cronJob.getFrequency().equalsIgnoreCase("EVERY")) {
            if (Integer.parseInt(cronJob.getExecutionTime().split(":")[0]) == -1) {
                triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)("0 0/" + Integer.parseInt(cronJob.getExecutionTime().split(":")[1]) + " * * * ?")));
            } else if (Integer.parseInt(cronJob.getExecutionTime().split(":")[1]) == -1) {
                triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)("0 0 0/" + Integer.parseInt(cronJob.getExecutionTime().split(":")[0]) + " * * ?")));
            }
        } else if (cronJob.getFrequency().equalsIgnoreCase("HOURLY")) {
            triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)"0 0 * ? * *"));
        }
        return (CronTrigger)triggerBuilder.build();
    }

    public boolean scheduleJob(CronJob cronJob) {
        boolean isScheduled = false;
        try {
            if (!this.isStarted) {
                this.startScheduler();
            }
            if (cronJob.isActive().booleanValue() && cronJob.isExecutionTimeValid()) {
                this.scheduler.scheduleJob(JobBuilder.newJob(cronJob.getClass()).withIdentity(cronJob.getId(), cronJob.getJobId()).build(), (Trigger)this.getCronTriggerFromCronJob(cronJob, null));
            }
            CronJobDAO.getInstance().saveOrUpdate(cronJob);
            isScheduled = true;
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), e0);
        }
        return isScheduled;
    }

    public boolean reScheduleJob(CronJob cronJob) {
        boolean isReScheduled = false;
        try {
            if (!this.isStarted) {
                this.startScheduler();
            }
            TriggerKey triggerKey = TriggerKey.triggerKey((String)cronJob.getId(), (String)cronJob.getJobId());
            if (cronJob.isActive().booleanValue()) {
                if (this.scheduler.getTrigger(triggerKey) == null) {
                    this.scheduler.scheduleJob(JobBuilder.newJob(cronJob.getClass()).withIdentity(cronJob.getId(), cronJob.getJobId()).build(), (Trigger)this.getCronTriggerFromCronJob(cronJob, null));
                } else {
                    this.scheduler.rescheduleJob(triggerKey, (Trigger)this.getCronTriggerFromCronJob(cronJob, this.scheduler.getTrigger(triggerKey).getTriggerBuilder().withIdentity(cronJob.getId(), cronJob.getJobId())));
                }
            } else if (this.scheduler.getTrigger(triggerKey) != null) {
                this.scheduler.deleteJob(JobKey.jobKey((String)cronJob.getId(), (String)cronJob.getJobId()));
            }
            CronJobDAO.getInstance().saveOrUpdate(cronJob);
            isReScheduled = true;
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), e0);
        }
        return isReScheduled;
    }

    public boolean deleteJob(CronJob cronJob) {
        boolean isdeleted = false;
        try {
            if (!this.isStarted) {
                this.startScheduler();
            }
            this.scheduler.deleteJob(JobKey.jobKey((String)cronJob.getId(), (String)cronJob.getJobId()));
            CronJobDAO.getInstance().delete(cronJob.getId());
            isdeleted = true;
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), e0);
        }
        return isdeleted;
    }

    private void startAllScheduledJob() {
        try {
            List<CronJob> cronJobs = CronJobDAO.getInstance().findAllActive();
            List cronJobPlugins = ExtensionManager.getPlugins(CronJobPlugin.class);
            if (cronJobs != null && cronJobs.size() > 0) {
                cronJobs.forEach(cronJob -> cronJobPlugins.forEach(cronJobPlugin -> {
                    if (cronJob.getJobId().trim().equals(((CronJobPlugin)cronJobPlugin).getId().trim())) {
                        try {
                            ((CronJobPlugin)cronJobPlugin).setCronJob(cronJob);
                            CronJob actualCronJob = ((CronJobPlugin)cronJobPlugin).convertToActualCronJob();
                            if (actualCronJob.isActive().booleanValue() && actualCronJob.isExecutionTimeValid()) {
                                JobDetail jobDetail = JobBuilder.newJob(actualCronJob.getClass()).withIdentity(actualCronJob.getId(), actualCronJob.getJobId()).build();
                                this.scheduler.scheduleJob(jobDetail, (Trigger)this.getCronTriggerFromCronJob(actualCronJob, null));
                            }
                        }
                        catch (Exception e1) {
                            PosLog.error(this.getClass(), e1);
                        }
                    }
                }));
                PosLog.info(OroCronJobManager.class, "All jobs are started successfully.");
            } else {
                PosLog.info(OroCronJobManager.class, "There have no scheduled job to start.");
            }
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), e0);
        }
    }

    public void startScheduler() {
        if (this.isStarted) {
            return;
        }
        try {
            this.scheduler.start();
            PosLog.info(OroCronJobManager.class, "Cron Job Manager Started Successfully.");
            this.startAllScheduledJob();
            this.isStarted = true;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    public void shutdownScheduler() {
        try {
            if (!this.isStarted) {
                return;
            }
            this.scheduler.shutdown();
            PosLog.info(OroCronJobManager.class, "Cron Job Manager Shutted Down Successfully.");
            this.isStarted = false;
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), e0);
        }
    }

    public void startGiftCardActivationStatusJob() throws SchedulerException {
        JobBuilder jobBuilder = JobBuilder.newJob(GiftCardCheckerJob.class);
        CronTrigger trigger = this.getCronTriggerFromCronJob(new GiftCardCheckerJob(), null);
        Scheduler scheduler = this.schedulerFactory.getScheduler();
        scheduler.scheduleJob(jobBuilder.build(), (Trigger)trigger);
        scheduler.start();
    }

    public static void rescheduleJob(CronJob cronJob) throws SchedulerException {
        Scheduler scheduler2 = OroCronJobManager.getInstance().scheduler;
        CronTrigger trigger = OroCronJobManager.getInstance().getCronTriggerFromCronJob(cronJob, null);
        if (scheduler2.checkExists(trigger.getKey())) {
            scheduler2.rescheduleJob(trigger.getKey(), (Trigger)trigger);
        } else {
            JobBuilder jobBuilder = JobBuilder.newJob(cronJob.getClass());
            scheduler2.scheduleJob(jobBuilder.build(), (Trigger)trigger);
        }
    }
}

