/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class FloorplanDAO
extends GenericDAO {
    public static FloorplanDAO instance;

    public static FloorplanDAO getInstance() {
        if (null == instance) {
            instance = new FloorplanDAO();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BookingInfo> getBookedTables(Date startDate, Date endDate) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(BookingInfo.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)startDate), (Criterion)Restrictions.le((String)BookingInfo.PROP_TO_DATE, (Object)endDate)));
            List list = criteria.list();
            return list;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BookingInfo> getAllOpenBooking() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(BookingInfo.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.ne((String)BookingInfo.PROP_STATUS, (Object)"close"));
            List list = criteria.list();
            return list;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    public void setUrgentBookingInfoInTables(Set<ShopTable> tables, Session session) {
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            Criteria criteria = session.createCriteria(BookingInfo.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)BookingInfo.PROP_CLOSED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)"open"));
            Calendar cal = Calendar.getInstance();
            Date start = cal.getTime();
            cal.add(12, 30);
            Date end = cal.getTime();
            SimpleExpression le = Restrictions.le((String)BookingInfo.PROP_FROM_DATE, (Object)start);
            SimpleExpression ge = Restrictions.ge((String)BookingInfo.PROP_TO_DATE, (Object)start);
            LogicalExpression bookingTime = Restrictions.and((Criterion)le, (Criterion)ge);
            Criterion thirtyMinuteBefore = Restrictions.between((String)BookingInfo.PROP_FROM_DATE, (Object)start, (Object)end);
            criteria.add((Criterion)Restrictions.or((Criterion)thirtyMinuteBefore, (Criterion)bookingTime));
            ArrayList<Integer> tableIds = new ArrayList<Integer>();
            for (ShopTable shopTable : tables) {
                tableIds.add(shopTable.getId());
            }
            criteria.createAlias("tables", "tableIds");
            criteria.add(Restrictions.in((String)("tableIds." + ShopTable.PROP_ID), tableIds));
            List list = criteria.list();
            ArrayList<ShopTable> updatedTableList = new ArrayList<ShopTable>();
            ArrayList updatedBookingInfoList = new ArrayList();
            if (!list.isEmpty()) {
                for (BookingInfo bookingInfo : list) {
                    List<ShopTable> bookedTables = bookingInfo.getTables();
                    Collection commonTables = CollectionUtils.intersection(tables, bookedTables);
                    for (ShopTable shopTable : commonTables) {
                        TableStatus tableStatus = shopTable.getShopTableStatus().getTableStatus();
                        if (!tableStatus.equals((Object)TableStatus.Available)) continue;
                        shopTable.setCurrentBookingId(bookingInfo.getId());
                        shopTable.addProperty("RES_NO", bookingInfo.getBookingId());
                        shopTable.setTableStatus(TableStatus.Booked);
                        if (bookingInfo.getCustomer() != null) {
                            shopTable.setCustomerName(bookingInfo.getCustomer().getName());
                        }
                        updatedTableList.add(shopTable);
                    }
                }
            }
            if (!updatedTableList.isEmpty()) {
                ShopTableDAO.getInstance().updateTableList(updatedTableList, session);
            }
            if (!updatedBookingInfoList.isEmpty()) {
                for (BookingInfo bookingInfo : updatedBookingInfoList) {
                    this.update(bookingInfo, session);
                }
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            PosLog.error(this.getClass(), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean updateBookingStatus() {
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            Criteria criteria = session.createCriteria(BookingInfo.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)BookingInfo.PROP_CLOSED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)"open"));
            Calendar cal = Calendar.getInstance();
            Date start = cal.getTime();
            cal.add(12, 30);
            Date end = cal.getTime();
            SimpleExpression le = Restrictions.le((String)BookingInfo.PROP_FROM_DATE, (Object)start);
            SimpleExpression ge = Restrictions.ge((String)BookingInfo.PROP_TO_DATE, (Object)start);
            LogicalExpression bookingTime = Restrictions.and((Criterion)le, (Criterion)ge);
            Criterion thirtyMinuteBefore = Restrictions.between((String)BookingInfo.PROP_FROM_DATE, (Object)start, (Object)end);
            criteria.add((Criterion)Restrictions.or((Criterion)thirtyMinuteBefore, (Criterion)bookingTime));
            List bookingInfos = criteria.list();
            if (bookingInfos.isEmpty()) {
                if (tx != null) {
                    tx.rollback();
                }
                boolean bl = false;
                return bl;
            }
            ArrayList<ShopTable> updatedTableList = new ArrayList<ShopTable>();
            for (BookingInfo bookingInfo : bookingInfos) {
                List<ShopTable> bookedTables = bookingInfo.getTables();
                if (bookedTables == null || bookedTables.isEmpty()) continue;
                for (ShopTable shopTable : bookedTables) {
                    String shopTableCustomerName;
                    String bookingInfoCustomerName;
                    TableStatus tableStatus;
                    ShopTableStatus shopTableStatus = shopTable.getShopTableStatus();
                    if (shopTableStatus == null || (tableStatus = shopTableStatus.getTableStatus()) == null) continue;
                    Customer bookingCustomer = bookingInfo.getCustomer();
                    String string = bookingInfoCustomerName = bookingCustomer == null ? "" : bookingCustomer.getName();
                    if (tableStatus.equals((Object)TableStatus.Available)) {
                        shopTable.setCurrentBookingId(bookingInfo.getId());
                        shopTable.addProperty("RES_NO", bookingInfo.getBookingId());
                        shopTable.setTableStatus(TableStatus.Booked);
                        if (bookingCustomer != null) {
                            shopTable.setCustomerName(bookingInfoCustomerName);
                        }
                        updatedTableList.add(shopTable);
                        continue;
                    }
                    if (!StringUtils.isNotBlank((String)bookingInfoCustomerName) || !StringUtils.isBlank((String)(shopTableCustomerName = shopTable.getCustomerName())) && shopTableCustomerName.equalsIgnoreCase(bookingInfoCustomerName)) continue;
                    shopTable.setCustomerName(bookingInfoCustomerName);
                    updatedTableList.add(shopTable);
                }
            }
            if (!updatedTableList.isEmpty()) {
                ShopTableDAO.getInstance().updateTableList(updatedTableList, session);
                tx.commit();
                boolean bl = true;
                return bl;
            }
            tx.commit();
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    public void setBookingStatus(BookingInfo bookingInfo, String bookingStatus, List<ShopTableStatus> tableStatusList) {
        try (Session session = this.createNewSession();){
            this.setBookingStatus(bookingInfo, bookingStatus, tableStatusList, session);
        }
    }

    public void setBookingStatus(BookingInfo bookingInfo, String bookingStatus, List<ShopTableStatus> tableStatusList, Session session) {
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            bookingInfo.setStatus(bookingStatus);
            this.saveOrUpdate(bookingInfo);
            if (bookingStatus.equals("seat") || bookingStatus.equals("delay")) {
                ShopTableDAO.getInstance().bookedTables(tableStatusList);
            }
            if (bookingStatus.equals("cancel") || bookingStatus.equals("no appear") || bookingStatus.equals("close")) {
                ShopTableDAO.getInstance().freeBookedTables(tableStatusList);
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            LogFactory.getLog(BookingInfo.class).error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public List<BookingInfo> getTodaysBooking() {
        return this.getTodaysBooking(null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BookingInfo> getTodaysBooking(String bookingStatus, String searchTxt) {
        try (Session session = this.createNewSession();){
            Calendar startDate = Calendar.getInstance();
            startDate.setLenient(false);
            startDate.setTime(new Date());
            startDate.set(11, 0);
            startDate.set(12, 0);
            startDate.set(13, 0);
            startDate.set(14, 0);
            Calendar endDate = Calendar.getInstance();
            endDate.setLenient(false);
            endDate.setTime(new Date());
            endDate.set(11, 23);
            endDate.set(12, 59);
            endDate.set(13, 59);
            Criteria criteria = null;
            List customerIds = null;
            if (StringUtils.isNotEmpty((String)searchTxt)) {
                criteria = session.createCriteria(Customer.class);
                this.addDeletedFilter(criteria);
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)Customer.PROP_NAME, (String)searchTxt, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (String)searchTxt, (MatchMode)MatchMode.START)));
                criteria.setProjection((Projection)Projections.property((String)Customer.PROP_ID));
                customerIds = criteria.list();
            }
            criteria = session.createCriteria(BookingInfo.class);
            this.addDeletedFilter(criteria);
            if (bookingStatus == null) {
                criteria.add((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)startDate.getTime())).add((Criterion)Restrictions.le((String)BookingInfo.PROP_FROM_DATE, (Object)endDate.getTime()));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)startDate.getTime())).add((Criterion)Restrictions.le((String)BookingInfo.PROP_FROM_DATE, (Object)endDate.getTime())).add((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)bookingStatus));
            }
            if (customerIds != null && !customerIds.isEmpty()) {
                criteria.add(Restrictions.in((String)BookingInfo.PROP_CUSTOMER_ID, (Collection)customerIds));
            }
            List list = criteria.list();
            return list;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ShopTable> getAllBookedTablesByDate(Date startDate, Date endDate) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(BookingInfo.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.gt((String)BookingInfo.PROP_TO_DATE, (Object)startDate), (Criterion)Restrictions.lt((String)BookingInfo.PROP_FROM_DATE, (Object)endDate))).add((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)"open"));
            List list = criteria.list();
            ArrayList<ShopTable> bookedTableList = new ArrayList<ShopTable>();
            for (BookingInfo bookingInfo : list) {
                List<ShopTable> tables = bookingInfo.getTables();
                if (tables == null) continue;
                bookedTableList.addAll(tables);
            }
            ArrayList<ShopTable> arrayList = bookedTableList;
            return arrayList;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    public List<BookingInfo> getAllBookingInfoByDate(Date startDate, Date endDate) {
        return this.getAllBookingInfoByDate(startDate, endDate, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BookingInfo> getAllBookingInfoByDate(Date startDate, Date endDate, String status, String searchTxt) {
        try (Session session = this.createNewSession();){
            Criteria criteria = null;
            List customerIds = null;
            if (StringUtils.isNotEmpty((String)searchTxt)) {
                criteria = session.createCriteria(Customer.class);
                this.addDeletedFilter(criteria);
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)Customer.PROP_NAME, (String)searchTxt, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (String)searchTxt, (MatchMode)MatchMode.START)));
                criteria.setProjection((Projection)Projections.property((String)Customer.PROP_ID));
                customerIds = criteria.list();
            }
            criteria = session.createCriteria(BookingInfo.class);
            this.addDeletedFilter(criteria);
            if (status == null) {
                criteria.add((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)startDate)).add((Criterion)Restrictions.lt((String)BookingInfo.PROP_FROM_DATE, (Object)endDate));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)startDate)).add((Criterion)Restrictions.lt((String)BookingInfo.PROP_FROM_DATE, (Object)endDate)).add((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)status));
            }
            if (customerIds != null && !customerIds.isEmpty()) {
                criteria.add(Restrictions.in((String)BookingInfo.PROP_CUSTOMER_ID, (Collection)customerIds));
            }
            List list = criteria.list();
            return list;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteAllReservations() {
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            boolean isSuccessfulDelete = true;
            List<BookingInfo> bookingInfos = BookingInfoDAO.getInstance().findAll();
            if (bookingInfos != null && !bookingInfos.isEmpty()) {
                for (BookingInfo bookingInfo : bookingInfos) {
                    if (!bookingInfo.isClosed().booleanValue()) {
                        isSuccessfulDelete = false;
                        continue;
                    }
                    List<ShopTable> shopTables = ShopTableDAO.getInstance().findByBookingInfo(bookingInfo.getId());
                    if (shopTables != null && !shopTables.isEmpty()) {
                        for (ShopTable shopTable : shopTables) {
                            shopTable.setCurrentBookingId(null);
                            shopTable.setCustomerName(null);
                            shopTable.removeProperty("RES_NO");
                            ShopTableStatus shopTableStatus = shopTable.getShopTableStatus();
                            shopTableStatus.setTableStatus(TableStatus.Available);
                            ShopTableStatusDAO.getInstance().update(shopTableStatus, session);
                            ShopTableDAO.getInstance().update(shopTable, session);
                        }
                    }
                    BookingInfoDAO.getInstance().delete(bookingInfo, session);
                }
            }
            tx.commit();
            boolean bl = isSuccessfulDelete;
            return bl;
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            PosLog.error(FloorplanDAO.class, e.getMessage(), e);
            return false;
        }
    }
}

