/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.IconFactory;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopFloorTemplate;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.Store;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.dao.ShopFloorTemplateDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.MultiSelectionOverflowCombobox;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.floorplan.ShopTableForm;
import com.floreantpos.ui.forms.ShopTableSelectionDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.StaleStateException;

public class FloorConfigurationFloorView
extends JPanel
implements RefreshableView {
    private static final Integer BUTTON_SIZE_MAX = 300;
    private static final Integer BUTTON_SIZE_MIN = 30;
    private ShopFloor floor;
    private FixedLengthTextField tfFloorName = new FixedLengthTextField(60);
    private JLayeredPane floorPanel = new JLayeredPane();
    private JPanel buttonPanel = new JPanel();
    private JList<ShopFloor> floorsList;
    private JCheckBox reArrange;
    private IntegerTextField tfButtonWidth;
    private IntegerTextField tfButtonHeight;
    private IntegerTextField tfSortOrder = new IntegerTextField(4);
    private JList<ShopFloorTemplate> floorTemplatesList;
    private boolean saveRequired = false;
    private JButton btnSave;
    private JButton btnCancel;
    private JButton btnClearFloorImage = null;
    private ShopFloorTemplate selectedTemplate;
    private JButton btnDetachSelectedTables;
    private JButton btnRefresh;
    private JButton btnSetFloorImage;
    private JButton btnRemoveAllTables;
    private PosButton btnBackgroundColor;
    private JButton btnSaveAsTemplate;
    private List<ShopTable> unassignedTables;
    private MultiSelectComboBox<OrderType> cbOrderTypes;
    protected boolean drag;
    protected Point dragLocation;
    protected Point origin;
    private JScrollPane scrollPane;
    private JLabel imageComponent;
    private List<TableButton> tableButtons = new ArrayList<TableButton>();
    private Map<Integer, ShopTable> detachedShopTables = new HashMap<Integer, ShopTable>();

    public FloorConfigurationFloorView(JList<ShopFloor> floorsList) {
        this.floorsList = floorsList;
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("FloorView.0")));
        this.createHeaderPanel();
        this.createLayoutPanel();
        this.createButtonPanel();
        this.initData();
    }

    private void updateView() {
        try {
            if (this.floor == null) {
                this.floorPanel.removeAll();
                this.cbOrderTypes.setSelectedItems(null);
                this.tfFloorName.setText("");
                return;
            }
            List<OrderType> orderTypes = this.floor.getOrderTypes();
            this.cbOrderTypes.unselectAllItems();
            this.cbOrderTypes.setSelectedItems(orderTypes);
            this.tfButtonWidth.setText(String.valueOf(TerminalConfig.getFloorButtonWidth()));
            this.tfButtonHeight.setText(String.valueOf(TerminalConfig.getFloorButtonHeight()));
            this.floorPanel.setPreferredSize(this.floor.getFloorSize());
            this.renderFloor();
            this.setSaveRequired(Boolean.FALSE);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    public boolean isSaveRequired() {
        return this.saveRequired;
    }

    private void initData() {
        this.cbOrderTypes.setItems(OrderTypeDAO.getInstance().findAll());
    }

    private void createLayoutPanel() {
        this.floorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FloorConfigurationFloorView.this.insertTable(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                FloorConfigurationFloorView.this.dragLocation = e.getPoint();
                FloorConfigurationFloorView.this.origin = e.getPoint();
                Dimension preferredSize = FloorConfigurationFloorView.this.floorPanel.getPreferredSize();
                if (preferredSize.height - 5 <= FloorConfigurationFloorView.this.dragLocation.y && preferredSize.width - 5 <= FloorConfigurationFloorView.this.dragLocation.x) {
                    FloorConfigurationFloorView.this.drag = true;
                } else if (preferredSize.height - 5 <= FloorConfigurationFloorView.this.dragLocation.y) {
                    FloorConfigurationFloorView.this.drag = true;
                } else if (preferredSize.width - 5 <= FloorConfigurationFloorView.this.dragLocation.x) {
                    FloorConfigurationFloorView.this.drag = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                FloorConfigurationFloorView.this.setCursor(Cursor.getDefaultCursor());
                FloorConfigurationFloorView.this.drag = false;
                if (FloorConfigurationFloorView.this.isSaveRequired()) {
                    Store store = DataProvider.get().getStore();
                    int btnWidth = store.getTableBtnWidth();
                    int btnHeight = store.getTableBtnHeight();
                    int width = (int)FloorConfigurationFloorView.this.floorPanel.getPreferredSize().getWidth();
                    int height = (int)FloorConfigurationFloorView.this.floorPanel.getPreferredSize().getHeight();
                    FloorConfigurationFloorView.this.floor.setWidth(width);
                    FloorConfigurationFloorView.this.floor.setHeight(height);
                    if (FloorConfigurationFloorView.this.floor.getTables() != null) {
                        for (ShopTable table : FloorConfigurationFloorView.this.floor.getTables()) {
                            Integer shopTableHeight;
                            Integer shopTableWidth = table.getWidth();
                            if (shopTableWidth == 0) {
                                shopTableWidth = btnWidth;
                            }
                            if ((shopTableHeight = table.getHeight()) == 0) {
                                shopTableHeight = btnHeight;
                            }
                            if (table.getX() + shopTableWidth > width) {
                                table.setX(width - shopTableWidth - 10);
                            }
                            if (table.getY() + shopTableHeight <= height) continue;
                            table.setY(height - shopTableHeight - 10);
                        }
                    }
                    FloorConfigurationFloorView.this.btnSave.setEnabled(FloorConfigurationFloorView.this.isSaveRequired());
                }
            }
        });
        this.floorPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!FloorConfigurationFloorView.this.drag) {
                    Point dragLocation = e.getPoint();
                    Dimension preferredSize = FloorConfigurationFloorView.this.floorPanel.getPreferredSize();
                    if (preferredSize.height - 5 <= dragLocation.y && preferredSize.width - 5 <= dragLocation.x) {
                        FloorConfigurationFloorView.this.setCursor(Cursor.getPredefinedCursor(5));
                    } else if (preferredSize.height - 5 <= dragLocation.y) {
                        FloorConfigurationFloorView.this.setCursor(Cursor.getPredefinedCursor(9));
                    } else if (preferredSize.width - 5 <= dragLocation.x) {
                        FloorConfigurationFloorView.this.setCursor(Cursor.getPredefinedCursor(11));
                    } else {
                        FloorConfigurationFloorView.this.setCursor(Cursor.getDefaultCursor());
                    }
                } else {
                    FloorConfigurationFloorView.this.setCursor(Cursor.getDefaultCursor());
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (FloorConfigurationFloorView.this.drag) {
                    Dimension preferredSize = FloorConfigurationFloorView.this.floorPanel.getPreferredSize();
                    if (FloorConfigurationFloorView.this.dragLocation.getX() > preferredSize.getWidth() - 10.0 && FloorConfigurationFloorView.this.dragLocation.getY() > preferredSize.getHeight() - 10.0) {
                        int w = (int)(preferredSize.getWidth() + (e.getPoint().getX() - FloorConfigurationFloorView.this.dragLocation.getX()));
                        int h = (int)(preferredSize.getHeight() + (e.getPoint().getY() - FloorConfigurationFloorView.this.dragLocation.getY()));
                        w = w < 500 ? 500 : w;
                        h = h < 500 ? 500 : h;
                        FloorConfigurationFloorView.this.floorPanel.setPreferredSize(new Dimension(w, h));
                        FloorConfigurationFloorView.this.setSaveRequired(Boolean.TRUE);
                        int scrollStepX = (int)(e.getPoint().getX() - FloorConfigurationFloorView.this.dragLocation.getX());
                        int scrollStepY = (int)(e.getPoint().getY() - FloorConfigurationFloorView.this.dragLocation.getY());
                        int originalValX = FloorConfigurationFloorView.this.scrollPane.getHorizontalScrollBar().getValue();
                        FloorConfigurationFloorView.this.scrollPane.getHorizontalScrollBar().setValue(originalValX + scrollStepX);
                        int originalValY = FloorConfigurationFloorView.this.scrollPane.getVerticalScrollBar().getValue();
                        FloorConfigurationFloorView.this.scrollPane.getVerticalScrollBar().setValue(originalValY + scrollStepY);
                    } else if (FloorConfigurationFloorView.this.getCursor().getType() == 11) {
                        int w = (int)(preferredSize.getWidth() + (e.getPoint().getX() - FloorConfigurationFloorView.this.dragLocation.getX()));
                        w = w < 500 ? 500 : w;
                        FloorConfigurationFloorView.this.floorPanel.setPreferredSize(new Dimension(w, (int)preferredSize.getHeight()));
                        FloorConfigurationFloorView.this.setSaveRequired(Boolean.TRUE);
                        int scrollStepX = (int)(e.getPoint().getX() - FloorConfigurationFloorView.this.dragLocation.getX());
                        int originalValX = FloorConfigurationFloorView.this.scrollPane.getHorizontalScrollBar().getValue();
                        FloorConfigurationFloorView.this.scrollPane.getHorizontalScrollBar().setValue(originalValX + scrollStepX);
                    } else if (FloorConfigurationFloorView.this.getCursor().getType() == 9) {
                        int h = (int)(preferredSize.getHeight() + (e.getPoint().getY() - FloorConfigurationFloorView.this.dragLocation.getY()));
                        h = h < 500 ? 500 : h;
                        FloorConfigurationFloorView.this.floorPanel.setPreferredSize(new Dimension((int)preferredSize.getWidth(), h));
                        FloorConfigurationFloorView.this.setSaveRequired(Boolean.TRUE);
                        int scrollStepY = (int)(e.getPoint().getY() - FloorConfigurationFloorView.this.dragLocation.getY());
                        int originalValY = FloorConfigurationFloorView.this.scrollPane.getVerticalScrollBar().getValue();
                        FloorConfigurationFloorView.this.scrollPane.getVerticalScrollBar().setValue(originalValY + scrollStepY);
                    }
                    FloorConfigurationFloorView.this.dragLocation = e.getPoint();
                    FloorConfigurationFloorView.this.floorPanel.revalidate();
                    FloorConfigurationFloorView.this.floorPanel.repaint();
                }
            }
        });
        JPanel floorPanelContainer = new JPanel();
        this.floorPanel.setAutoscrolls(true);
        floorPanelContainer.add(this.floorPanel);
        floorPanelContainer.setAutoscrolls(true);
        this.scrollPane = new JScrollPane(floorPanelContainer);
        this.add(this.scrollPane);
        floorPanelContainer.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                FloorConfigurationFloorView.this.setCursor(Cursor.getDefaultCursor());
                FloorConfigurationFloorView.this.drag = false;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
    }

    private void createHeaderPanel() {
        try {
            JPanel headerPanel = new JPanel((LayoutManager)new MigLayout("inset 0 5 0 5,hidemode 3"));
            this.tfFloorName.setColumns(20);
            this.tfFloorName.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    FloorConfigurationFloorView.this.setSaveRequired(Boolean.TRUE);
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    FloorConfigurationFloorView.this.setSaveRequired(Boolean.TRUE);
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
            this.tfSortOrder.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    FloorConfigurationFloorView.this.setSaveRequired(true);
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    FloorConfigurationFloorView.this.setSaveRequired(true);
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
            headerPanel.add(new JLabel(Messages.getString("FloorView.1")));
            headerPanel.add(this.tfFloorName);
            headerPanel.add(new JLabel(Messages.getString("FloorConfigurationFloorView.5")));
            headerPanel.add((Component)this.tfSortOrder, "width 40!");
            final JPanel rearrangeButtonPanel = new JPanel((LayoutManager)new MigLayout("fill, hidemode 3, ins 0"));
            this.cbOrderTypes = new MultiSelectionOverflowCombobox<OrderType>();
            this.cbOrderTypes.addActionListener(e -> this.setSaveRequired(true));
            this.reArrange = new JCheckBox(Messages.getString("FloorView.3"));
            this.reArrange.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                    boolean selected = abstractButton.getModel().isSelected();
                    rearrangeButtonPanel.setVisible(selected);
                    FloorConfigurationFloorView.this.clearSelectedTables();
                }
            });
            KeyListener widthHeightKeyListener = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    FloorConfigurationFloorView.this.setSaveRequired(Boolean.TRUE);
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    FloorConfigurationFloorView.this.setSaveRequired(Boolean.TRUE);
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            };
            FocusListener widthHeightFocusListener = new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    FloorConfigurationFloorView.this.repaintTableButtonsWidthHeight();
                }

                @Override
                public void focusGained(FocusEvent e) {
                    FloorConfigurationFloorView.this.tfButtonWidth.setEditable(Boolean.TRUE);
                    FloorConfigurationFloorView.this.tfButtonHeight.setEditable(Boolean.TRUE);
                }
            };
            this.tfButtonWidth = new IntegerTextField(3, 3);
            this.tfButtonWidth.addKeyListener(widthHeightKeyListener);
            this.tfButtonWidth.addFocusListener(widthHeightFocusListener);
            this.tfButtonHeight = new IntegerTextField(3, 3);
            this.tfButtonHeight.addKeyListener(widthHeightKeyListener);
            this.tfButtonHeight.addFocusListener(widthHeightFocusListener);
            this.tfButtonWidth.setText(String.valueOf(TerminalConfig.getFloorButtonWidth()));
            this.tfButtonHeight.setText(String.valueOf(TerminalConfig.getFloorButtonHeight()));
            this.btnBackgroundColor = new PosButton();
            this.btnBackgroundColor.setToolTipText(Messages.getString("FloorConfigurationFloorView.0"));
            this.btnBackgroundColor.setIcon(IconFactory.getIcon("/ui_icons/", "bg_color_icon.png"));
            this.btnBackgroundColor.addActionListener(e -> this.doSetFloorBackgroundColor());
            headerPanel.add((Component)new JSeparator(1), "grow");
            headerPanel.add((Component)new JLabel(Messages.getString("FloorConfigurationFloorView.6")), "");
            headerPanel.add(this.cbOrderTypes, "");
            headerPanel.add((Component)new JSeparator(1), "grow");
            headerPanel.add((Component)this.reArrange, "");
            rearrangeButtonPanel.add(new JLabel(Messages.getString("FloorView.4")));
            rearrangeButtonPanel.add((Component)this.tfButtonWidth, "width 40!");
            rearrangeButtonPanel.add(new JLabel(Messages.getString("FloorView.5")));
            rearrangeButtonPanel.add((Component)this.tfButtonHeight, "width 40!");
            rearrangeButtonPanel.add((Component)this.btnBackgroundColor, "width 30!, height 27!");
            rearrangeButtonPanel.setVisible(false);
            headerPanel.add((Component)rearrangeButtonPanel, "growx, align right");
            this.add((Component)headerPanel, "North");
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage());
        }
    }

    protected void doSetFloorBackgroundColor() {
        Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("FloorConfigurationFloorView.1"), Color.WHITE);
        if (color == null) {
            return;
        }
        this.floor.setBackgroundColor(color);
        this.floorPanel.setBackground(color);
        this.setSaveRequired(true);
    }

    protected void setFloorOrderType() {
        List<OrderType> selectedOrdertypes = this.cbOrderTypes.getSelectedItems();
        this.floor.setOrderTypes(selectedOrdertypes);
    }

    protected void doSaveFloorTemplate() {
        if (this.selectedTemplate == null) {
            return;
        }
        if (this.floor.getTables() != null) {
            this.selectedTemplate.getProperties().clear();
            for (ShopTable table : this.floor.getTables()) {
                this.selectedTemplate.addProperty(String.valueOf(table.getId()), table.getX() + "," + table.getY());
            }
        }
        ShopFloorTemplateDAO.getInstance().saveOrUpdate(this.selectedTemplate);
    }

    protected void doSave() {
        if (this.floor == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorConfigurationFloorView.11"));
            return;
        }
        try {
            if (!this.validateRequiredFields()) {
                return;
            }
            this.repaintTableButtonsWidthHeight();
            this.saveTerminalProperties();
            this.updateFloorName();
            this.setFloorOrderType();
            if (this.floorPanel.getComponentCount() > 0) {
                for (Component component : this.floorPanel.getComponents()) {
                    if (!(component instanceof TableButton)) continue;
                    TableButton tableButton = (TableButton)component;
                    int x = tableButton.getX();
                    int y = tableButton.getY();
                    tableButton.getTable().setX(x);
                    tableButton.getTable().setY(y);
                }
            }
            this.floor.setHeight(this.floorPanel.getHeight());
            this.floor.setWidth(this.floorPanel.getWidth());
            this.floor.setSortOrder(this.tfSortOrder.getInteger());
            if (!this.detachedShopTables.isEmpty()) {
                ShopTableDAO.getInstance().detachFloor(new ArrayList<ShopTable>(this.detachedShopTables.values()));
            }
            ShopFloorTemplate defaultTemplate = null;
            if (this.selectedTemplate != null && !this.selectedTemplate.isDefaultFloor().booleanValue()) {
                this.copyTablePositionFromFloor(this.selectedTemplate);
                DefaultListModel model = (DefaultListModel)this.floorTemplatesList.getModel();
                if (model != null) {
                    for (int i = 0; i < model.size(); ++i) {
                        ShopFloorTemplate floorTemplate = (ShopFloorTemplate)model.getElementAt(i);
                        if (!floorTemplate.isDefaultFloor().booleanValue()) continue;
                        defaultTemplate = floorTemplate;
                        break;
                    }
                }
            }
            if (defaultTemplate != null) {
                this.copyTablePositionFromTemplate(defaultTemplate);
            }
            ShopFloorDAO.getInstance().saveOrUpdate(this.floor);
            if (defaultTemplate != null) {
                ShopFloorTemplateDAO.getInstance().saveOrUpdate(this.selectedTemplate);
                this.copyTablePositionFromTemplate(this.selectedTemplate);
            } else {
                this.doSaveFloorTemplate();
            }
            this.saveStoreProperties();
            this.setSaveRequired(Boolean.FALSE);
            this.floorPanel.repaint();
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
        }
    }

    private boolean validateRequiredFields() {
        boolean isValid = true;
        int width = this.tfButtonWidth.getInteger();
        int height = this.tfButtonHeight.getInteger();
        if (width > BUTTON_SIZE_MAX) {
            this.tfButtonWidth.requestFocus();
            POSMessageDialog.showError(String.format(Messages.getString("FloorConfigurationFloorView.14"), BUTTON_SIZE_MAX));
            isValid = false;
            return false;
        }
        if (height > BUTTON_SIZE_MAX) {
            this.tfButtonHeight.requestFocus();
            POSMessageDialog.showError(String.format(Messages.getString("FloorConfigurationFloorView.15"), BUTTON_SIZE_MAX));
            isValid = false;
            return false;
        }
        if (width < BUTTON_SIZE_MIN) {
            this.tfButtonWidth.requestFocus();
            POSMessageDialog.showError(String.format(Messages.getString("FloorConfigurationFloorView.30"), BUTTON_SIZE_MIN));
            isValid = false;
            return false;
        }
        if (height < BUTTON_SIZE_MIN) {
            this.tfButtonHeight.requestFocus();
            POSMessageDialog.showError(String.format(Messages.getString("FloorConfigurationFloorView.32"), BUTTON_SIZE_MIN));
            isValid = false;
            return false;
        }
        return isValid;
    }

    private void saveTerminalProperties() {
        int width = this.tfButtonWidth.getInteger();
        int height = this.tfButtonHeight.getInteger();
        TerminalConfig.setFloorButtonWidth(width);
        TerminalConfig.setFloorButtonHeight(height);
    }

    public void saveStoreProperties() {
        int width = this.tfButtonWidth.getInteger();
        int height = this.tfButtonHeight.getInteger();
        DataProvider.get().refreshStore();
        Store store = DataProvider.get().getStore();
        store.setTableBtnHeight(height);
        store.setTableBtnWidth(width);
        StoreDAO.getInstance().update(store);
        DataProvider.get().refreshStore();
    }

    private void createButtonPanel() {
        try {
            this.btnSave = new JButton(POSConstants.SAVE);
            this.btnSave.addActionListener(e -> this.doSave());
            this.btnCancel = new JButton(POSConstants.CANCEL);
            this.btnCancel.addActionListener(e -> this.refresh());
            this.btnRefresh = new JButton(Messages.getString("FloorConfigurationFloorView.17"));
            this.btnRefresh.addActionListener(e -> this.refresh());
            this.btnClearFloorImage = new JButton(Messages.getString("FloorConfigurationFloorView.20"));
            this.btnClearFloorImage.addActionListener(e -> this.doClearBackgroudImage());
            this.btnSetFloorImage = new JButton(Messages.getString("FloorView.9"));
            this.btnSetFloorImage.setEnabled(false);
            this.btnSetFloorImage.addActionListener(e -> this.doSetFloorImage());
            this.btnDetachSelectedTables = new JButton(Messages.getString("FloorView.10"));
            this.btnDetachSelectedTables.setEnabled(false);
            this.btnDetachSelectedTables.addActionListener(e -> this.doDetachSelectedTables());
            this.btnRemoveAllTables = new JButton(Messages.getString("FloorView.13"));
            this.btnRemoveAllTables.setEnabled(false);
            this.btnRemoveAllTables.addActionListener(e -> this.removeTables());
            this.btnSaveAsTemplate = new JButton(Messages.getString("FloorConfigurationFloorView.52"));
            this.btnSaveAsTemplate.setEnabled(false);
            this.btnSaveAsTemplate.addActionListener(e -> this.doSaveFloorAsTemplate());
            this.buttonPanel.add(this.btnRefresh);
            this.buttonPanel.add(this.btnClearFloorImage);
            this.buttonPanel.add(this.btnSetFloorImage);
            this.buttonPanel.add(this.btnDetachSelectedTables);
            this.buttonPanel.add(this.btnRemoveAllTables);
            this.buttonPanel.add(this.btnSave);
            this.buttonPanel.add(this.btnCancel);
            JPanel buttonPanelContainer = new JPanel(new BorderLayout(5, 5));
            buttonPanelContainer.add((Component)new JSeparator(0), "North");
            buttonPanelContainer.add(this.buttonPanel);
            buttonPanelContainer.add((Component)this.btnSaveAsTemplate, "West");
            this.add((Component)buttonPanelContainer, "South");
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage());
        }
    }

    private void doClearBackgroudImage() {
        try {
            if (this.floor == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorConfigurationFloorView.11"));
                return;
            }
            if (this.floor.getImageId() == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorConfigurationFloorView.13"));
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("FloorConfigurationFloorView.44"), Messages.getString("FloorConfigurationFloorView.45"));
            if (option != 0) {
                return;
            }
            this.floor.setImageId(null);
            this.renderFloorImage(null);
            this.floorPanel.revalidate();
            this.floorPanel.repaint();
            this.setSaveRequired(Boolean.TRUE);
        }
        catch (Exception e2) {
            PosLog.error(FloorConfigurationFloorView.class, e2.getMessage(), e2);
            POSMessageDialog.showError(this, e2.getMessage(), e2);
        }
    }

    protected void doSaveFloorAsTemplate() {
        try {
            int modelLen;
            if (this.floor == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorConfigurationFloorView.11"));
                return;
            }
            ShopFloorDAO.getInstance().refresh(this.floor);
            if (this.isSaveRequired()) {
                if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("FloorConfigurationFloorView.34"), Messages.getString("FloorConfigurationFloorView.35")) == 0) {
                    this.doSaveFloorTemplate();
                    this.floor.setName(this.tfFloorName.getText().trim());
                } else {
                    this.tfFloorName.setText(this.floor.getName());
                }
            }
            String templateName = null;
            boolean repeat = false;
            do {
                if ((templateName = JOptionPane.showInputDialog(POSUtil.getBackOfficeWindow(), (Object)Messages.getString("FloorConfigurationFloorView.19"))) != null && StringUtils.isBlank((String)templateName)) {
                    POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("FloorConfigurationFloorView.21"));
                    repeat = true;
                    continue;
                }
                repeat = false;
            } while (repeat);
            if (templateName == null) {
                return;
            }
            templateName = templateName.trim();
            int templateNameLengthMax = 60;
            if (templateName.length() > 60) {
                String message = String.format(Messages.getString("FloorConfigurationFloorView.9"), 60);
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), message);
                return;
            }
            ShopFloorTemplate template = new ShopFloorTemplate();
            template.setName(templateName);
            template.setFloor(this.floor);
            DefaultListModel model = (DefaultListModel)this.floorTemplatesList.getModel();
            ArrayList<ShopFloorTemplate> templateList = new ArrayList<ShopFloorTemplate>();
            this.copyTablePositionFromFloor(template);
            if (model.getSize() == 0) {
                model.addElement(template);
                templateList.add(template);
                template.setDefaultFloor(true);
                ShopFloorDAO.getInstance().saveOrUpdate(this.floor);
                ShopFloorTemplateDAO.getInstance().saveOrUpdateTemplates(templateList);
                this.updateFloorName();
                this.setSaveRequired(Boolean.FALSE);
                this.floorTemplatesList.setSelectedValue(template, true);
                return;
            }
            model.addElement(template);
            if (model.getSize() > 0) {
                for (int i = 0; i < model.size(); ++i) {
                    templateList.add((ShopFloorTemplate)model.getElementAt(i));
                }
            }
            if ((modelLen = model.size()) <= 1) {
                template.setDefaultFloor(true);
            }
            ShopFloorDAO.getInstance().saveOrUpdate(this.floor);
            ShopFloorTemplateDAO.getInstance().saveOrUpdateTemplates(templateList);
            this.updateFloorName();
            this.setSaveRequired(Boolean.FALSE);
            this.floorTemplatesList.setSelectedValue(template, true);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    private void copyTablePositionFromFloor(ShopFloorTemplate template) {
        Set<ShopTable> tables = this.floor.getTables();
        if (tables != null) {
            for (ShopTable table : tables) {
                template.addProperty(String.valueOf(table.getId()), table.getX() + "," + table.getY());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renderFloor() throws Exception {
        Session session;
        block7: {
            this.floorPanel.removeAll();
            session = null;
            try {
                this.btnSaveAsTemplate.setEnabled(this.floor != null);
                this.btnSetFloorImage.setEnabled(this.floor != null);
                this.btnDetachSelectedTables.setEnabled(this.floor != null);
                this.btnRemoveAllTables.setEnabled(this.floor != null);
                if (this.floor != null) break block7;
                this.tfFloorName.setText("");
                if (session == null) return;
            }
            catch (Throwable throwable) {
                if (session == null) throw throwable;
                ShopFloorDAO.getInstance().closeSession(session);
                throw throwable;
            }
            ShopFloorDAO.getInstance().closeSession(session);
            return;
        }
        if (this.floor.getId() != null) {
            session = ShopFloorDAO.getInstance().createNewSession();
            this.floor = ShopFloorDAO.getInstance().get(this.floor.getId(), session);
            if (this.selectedTemplate != null) {
                this.copyTablePositionFromTemplate(this.selectedTemplate);
            }
        }
        this.tfSortOrder.setText(String.valueOf(this.floor.getSortOrder()));
        this.tfFloorName.setText(this.floor.getName());
        this.floorPanel.setOpaque(true);
        if (this.floor.getBackgroundColorCode() != null) {
            this.floorPanel.setBackground(this.floor.getBackgroundColor());
        } else {
            this.floorPanel.setBackground(Color.WHITE);
        }
        Set<ShopTable> tables = this.floor.getTables();
        this.unassignedTables = ShopTableDAO.getInstance().getAllUnassigned();
        this.renderTableButtons(tables);
        ImageIcon image = this.floor.getImage();
        this.renderFloorImage(image);
        this.floorPanel.revalidate();
        this.floorPanel.repaint();
        if (session == null) return;
        ShopFloorDAO.getInstance().closeSession(session);
    }

    private void renderTableButtons(Set<ShopTable> tables) {
        if (!this.tableButtons.isEmpty()) {
            this.tableButtons.forEach(tableButton -> {
                this.floorPanel.remove((Component)tableButton);
                ShopTable table = tableButton.table;
                ShopTable shopTable = ShopTableDAO.getInstance().get(table.getId());
                if (shopTable != null && !shopTable.isDeleted().booleanValue()) {
                    this.unassignedTables.add(table);
                }
            });
            this.tableButtons.clear();
        }
        if (this.floor == null) {
            return;
        }
        if (tables != null) {
            for (ShopTable shopTable : tables) {
                TableButton tableButton2 = new TableButton(shopTable);
                this.floorPanel.add(tableButton2);
                this.floorPanel.moveToFront(tableButton2);
                this.tableButtons.add(tableButton2);
                if (!this.unassignedTables.contains(shopTable)) continue;
                this.unassignedTables.remove(shopTable);
            }
        }
        this.removeDuplicateShopTables(this.unassignedTables);
    }

    private void removeDuplicateShopTables(List<ShopTable> shopTables) {
        if (shopTables == null) {
            return;
        }
        ArrayList distinctShopTables = new ArrayList();
        shopTables.forEach(shopTable -> {
            if (!distinctShopTables.contains(shopTable)) {
                distinctShopTables.add(shopTable);
            }
        });
        shopTables.clear();
        shopTables.addAll(distinctShopTables);
        Collections.sort(shopTables, (table1, table2) -> table1.getId() - table2.getId());
    }

    private void renderFloorImage(ImageIcon image) {
        if (this.floor == null) {
            return;
        }
        if (image != null) {
            if (this.imageComponent != null) {
                this.floorPanel.remove(this.imageComponent);
                this.imageComponent = null;
            }
            Dimension floorSize = this.floorPanel.getPreferredSize();
            if (floorSize.width < image.getIconWidth()) {
                floorSize.width = image.getIconWidth();
            }
            if (floorSize.height < image.getIconHeight()) {
                floorSize.height = image.getIconHeight();
            }
            this.floorPanel.setPreferredSize(floorSize);
            this.imageComponent = new JLabel(image);
            this.imageComponent.setBounds(0, 0, image.getIconWidth(), image.getIconHeight());
            this.floorPanel.add(this.imageComponent);
            this.floorPanel.moveToBack(this.imageComponent);
        } else if (this.imageComponent != null) {
            this.floorPanel.remove(this.imageComponent);
            this.imageComponent = null;
        }
    }

    public ShopFloor getFloor() {
        return this.floor;
    }

    public void setFloor(ShopFloor floor) {
        try {
            if (this.isSaveRequired() && this.floor != null) {
                if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("FloorConfigurationFloorView.51") + this.floor.getName(), Messages.getString("FloorConfigurationFloorView.27")) == 0) {
                    this.doSave();
                }
                this.setSaveRequired(Boolean.FALSE);
            }
            this.floor = floor;
            this.unassignedTables = ShopTableDAO.getInstance().getAllUnassigned();
            this.updateView();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    public void setSaveRequired(boolean saveRequired) {
        this.btnSave.setEnabled(saveRequired);
        this.btnCancel.setEnabled(saveRequired);
        if (this.floor == null) {
            return;
        }
        this.saveRequired = saveRequired;
    }

    private void doSetFloorImage() {
        try {
            if (this.floor == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorConfigurationFloorView.11"));
                return;
            }
            ImageGalleryDialog dialog = ImageGalleryDialog.getInstance();
            dialog.setSelectBtnVisible(true);
            dialog.setSelectedImageResourceNull();
            dialog.setTitle(Messages.getString("ImageGalleryAction.1"));
            dialog.openFullScreen();
            ImageResource imageResource = dialog.getImageResource();
            if (imageResource == null) {
                return;
            }
            ImageIcon imageIcon = imageResource.getImageIcon();
            this.floor.setImageId(imageResource.getId());
            this.renderFloorImage(imageIcon);
            this.floorPanel.revalidate();
            this.floorPanel.repaint();
            this.setSaveRequired(true);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void updateFloorName() {
        String text = this.tfFloorName.getText();
        if (StringUtils.isBlank((String)text)) {
            POSMessageDialog.showError(SwingUtilities.windowForComponent(this), Messages.getString("FloorView.16"));
            return;
        }
        this.floor.setName(text);
        if (this.floor.getId() != null) {
            DefaultListModel model = (DefaultListModel)this.floorsList.getModel();
            for (int i = 0; i < model.size(); ++i) {
                ShopFloor shopFloor = (ShopFloor)model.getElementAt(i);
                if (!this.floor.getId().equals(shopFloor.getId())) continue;
                shopFloor.setName(text);
            }
        }
        this.floorsList.repaint();
    }

    private void insertTable(MouseEvent e) {
        try {
            if (this.floor == null) {
                return;
            }
            final ShopTableSelectionDialog dialog = new ShopTableSelectionDialog().getInstance(this.unassignedTables);
            JButton btnNewTable = new JButton(Messages.getString("FloorView.7"));
            btnNewTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShopTable shopTable;
                    ShopTableForm shopTableForm = new ShopTableForm();
                    shopTableForm.setTableTypeCBoxListEnable(true);
                    shopTableForm.createNew();
                    BeanEditorDialog shopTableDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)shopTableForm);
                    shopTableDialog.setTitle(Messages.getString("FloorView.18"));
                    shopTableDialog.setPreferredSize(new Dimension(900, 700));
                    shopTableDialog.open();
                    if (!shopTableDialog.isCanceled() && (shopTable = (ShopTable)shopTableForm.getBean()) != null && shopTable.getId() != null) {
                        dialog.addTotables(shopTable);
                    }
                }
            });
            dialog.getButtonPanel().add((Component)btnNewTable, 0);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            ShopTable selectedTable = dialog.getSelectedTable();
            if (selectedTable == null) {
                JOptionPane.showMessageDialog(this, Messages.getString("FloorView.19"));
                return;
            }
            ShopTableDAO.getInstance().refresh(selectedTable);
            if (selectedTable.isDeleted().booleanValue()) {
                this.unassignedTables.remove(selectedTable);
                POSMessageDialog.showMessage(Messages.getString("FloorConfigurationFloorView.43"));
                return;
            }
            if (this.floor.getId() == null) {
                String message = Messages.getString("FloorConfigurationFloorView.1");
                String title = Messages.getString("FloorConfigurationFloorView.2");
                int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), message, title);
                if (option != 0) {
                    return;
                }
                ShopFloorDAO.getInstance().save(this.floor);
            }
            selectedTable.setFloor(this.floor);
            selectedTable.setX(e.getX() - 20);
            selectedTable.setY(e.getY() - 20);
            this.floor.addTotables(selectedTable);
            if (this.detachedShopTables.containsKey(selectedTable.getId())) {
                this.detachedShopTables.remove(selectedTable.getId());
            }
            TableButton button = new TableButton(selectedTable);
            this.floorPanel.add(button);
            this.floorPanel.moveToFront(button);
            this.tableButtons.add(button);
            this.floorPanel.revalidate();
            this.floorPanel.repaint();
            this.unassignedTables.remove(selectedTable);
            this.setSaveRequired(Boolean.TRUE);
        }
        catch (PosException e2) {
            POSMessageDialog.showError(SwingUtilities.getWindowAncestor(this), e2.getMessage());
        }
        catch (Exception e2) {
            POSMessageDialog.showError(SwingUtilities.getWindowAncestor(this), e2.getMessage(), e2);
        }
    }

    private void removeTables() {
        try {
            if (this.floor == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorConfigurationFloorView.11"));
                return;
            }
            Set<ShopTable> tables = this.floor.getTables();
            if (tables == null) {
                return;
            }
            if (tables.size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorConfigurationFloorView.7"));
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(this.getParent(), Messages.getString("FloorView.20") + " " + this.floor.getName() + "?", Messages.getString("FloorConfigurationFloorView.27"));
            if (option != 0) {
                return;
            }
            boolean isNotDetachSomeTables = false;
            for (ShopTable shopTable : tables) {
                ShopTableDAO.getInstance().refresh(shopTable);
                TableStatus tableStatus = shopTable.getShopTableStatus().getTableStatus();
                if (tableStatus.equals((Object)TableStatus.Serving) || tableStatus.equals((Object)TableStatus.Booked)) {
                    isNotDetachSomeTables = true;
                    continue;
                }
                this.detachedShopTables.putIfAbsent(shopTable.getId(), shopTable);
            }
            if (this.detachedShopTables.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorConfigurationFloorView.3"));
                return;
            }
            for (ShopTable shopTable : this.detachedShopTables.values()) {
                if (this.unassignedTables.contains(shopTable)) continue;
                this.unassignedTables.add(shopTable);
            }
            this.floor.getTables().removeAll(this.detachedShopTables.values());
            Collections.sort(this.unassignedTables, (table1, table2) -> table1.getId() - table2.getId());
            this.renderTableButtons(this.floor.getTables());
            this.floorPanel.revalidate();
            this.floorPanel.repaint();
            this.setSaveRequired(Boolean.TRUE);
            if (isNotDetachSomeTables) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorConfigurationFloorView.54"));
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private List<ShopTable> getSelectedTables() {
        Component[] components = this.floorPanel.getComponents();
        ArrayList<ShopTable> selectedTables = new ArrayList<ShopTable>();
        for (Component component : components) {
            TableButton tb;
            if (!(component instanceof TableButton) || !(tb = (TableButton)component).isSelected()) continue;
            selectedTables.add(tb.table);
        }
        return selectedTables;
    }

    private void clearSelectedTables() {
        Component[] components;
        for (Component component : components = this.floorPanel.getComponents()) {
            if (!(component instanceof TableButton)) continue;
            TableButton tb = (TableButton)component;
            tb.setSelected(false);
        }
    }

    private void repaintTableButtonsWidthHeight() {
        if (this.floor == null) {
            return;
        }
        if (this.floorPanel.getComponentCount() == 0) {
            return;
        }
        int width = PosUIManager.getSize(this.tfButtonWidth.getInteger());
        int height = PosUIManager.getSize(this.tfButtonHeight.getInteger());
        for (Component component : this.floorPanel.getComponents()) {
            if (!(component instanceof TableButton)) continue;
            TableButton tableButton = (TableButton)component;
            int x = tableButton.getX();
            int y = tableButton.getY();
            tableButton.setBounds(x, y, width, height);
        }
    }

    public void setFloorTemplate(JList<ShopFloorTemplate> floorTemplatesList, ShopFloorTemplate selectedValue) {
        if (this.isSaveRequired() && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("FloorConfigurationFloorView.34"), Messages.getString("FloorConfigurationFloorView.35")) == 0) {
            this.doSaveFloorTemplate();
        }
        this.selectedTemplate = selectedValue;
        this.floorTemplatesList = floorTemplatesList;
        if (selectedValue != null) {
            this.copyTablePositionFromTemplate(selectedValue);
            try {
                this.renderTableButtons(this.floor.getTables());
                this.floorPanel.repaint();
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), e);
            }
        }
        this.setSaveRequired(Boolean.FALSE);
    }

    private void copyTablePositionFromTemplate(ShopFloorTemplate template) {
        if (this.floor.getTables() == null) {
            return;
        }
        for (ShopTable table : this.floor.getTables()) {
            String position = template.getProperty(String.valueOf(table.getId()));
            if (position == null) continue;
            String[] split = position.split(",");
            table.setX(Integer.valueOf(split[0]));
            table.setY(Integer.valueOf(split[1]));
        }
    }

    private void doDetachSelectedTables() {
        try {
            if (this.floor == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorConfigurationFloorView.11"));
                return;
            }
            List<ShopTable> selectedTables = this.getSelectedTables();
            if (selectedTables.size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorConfigurationFloorView.53"));
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("FloorView.11"), POSConstants.CONFIRM);
            if (option != 0) {
                this.clearSelectedTables();
                return;
            }
            boolean isNotDetachSomeTables = false;
            for (ShopTable shopTable : selectedTables) {
                ShopTableDAO.getInstance().refresh(shopTable);
                TableStatus tableStatus = shopTable.getShopTableStatus().getTableStatus();
                if (tableStatus.equals((Object)TableStatus.Serving) || tableStatus.equals((Object)TableStatus.Booked)) {
                    isNotDetachSomeTables = true;
                    continue;
                }
                this.detachedShopTables.putIfAbsent(shopTable.getId(), shopTable);
            }
            if (this.detachedShopTables.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorConfigurationFloorView.3"));
                return;
            }
            this.floor.getTables().removeAll(this.detachedShopTables.values());
            ArrayList<ShopTableStatus> statusList = new ArrayList<ShopTableStatus>();
            for (ShopTable shopTable : this.detachedShopTables.values()) {
                statusList.add(shopTable.getShopTableStatus());
                if (this.unassignedTables.contains(shopTable)) continue;
                this.unassignedTables.add(shopTable);
            }
            Collections.sort(this.unassignedTables, (table1, table2) -> table1.getId() - table2.getId());
            Set<ShopTable> set = this.floor.getTables();
            this.renderTableButtons(set);
            this.floorPanel.revalidate();
            this.floorPanel.repaint();
            this.setSaveRequired(Boolean.TRUE);
            if (isNotDetachSomeTables) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorConfigurationFloorView.54"));
            }
        }
        catch (Exception e2) {
            POSMessageDialog.showError(this, e2.getMessage(), e2);
        }
    }

    @Override
    public void refresh() {
        try {
            this.detachedShopTables.clear();
            if (this.floor == null || this.floor.getId() == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorConfigurationFloorView.11"));
                return;
            }
            this.floor = ShopFloorDAO.getInstance().get(this.floor.getId());
            ShopFloorDAO.getInstance().initializeTables(this.floor);
            this.updateView();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    class TableButton
    extends JToggleButton
    implements MouseListener,
    MouseMotionListener {
        ShopTable table;
        int pressedX;
        int pressedY;

        public TableButton(ShopTable table) {
            this.table = table;
            Store store = DataProvider.get().getStore();
            int priSize = PosUIManager.getSize(store.getTablePrimaryFontSize());
            this.setBounds(table.getX(), table.getY(), PosUIManager.getSize(store.getTableBtnWidth()), PosUIManager.getSize(store.getTableBtnHeight()));
            this.setFocusPainted(false);
            String tableStatus = table.getShopTableStatus().getTableStatus().toString();
            String tableHeading = StringUtils.isNotBlank((String)table.getName()) ? table.getName() : String.valueOf(table.getTableNumber());
            String text = "<html><center>";
            text = text + "<div style= 'font-weight: bold;'>" + tableStatus + "</div>";
            text = text + "</center><center><div style='font-size:" + priSize + "px; font-weight: bold;'>" + tableHeading + "</div>";
            text = text + "</center></html>";
            this.setText(text);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public ShopTable getTable() {
            return this.table;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!FloorConfigurationFloorView.this.reArrange.isSelected()) {
                return;
            }
            try {
                int x = e.getX() - this.pressedX + this.getLocation().x;
                int y = e.getY() - this.pressedY + this.getLocation().y;
                int floorWidth = ((FloorConfigurationFloorView)FloorConfigurationFloorView.this).floorPanel.getBounds().width - 40;
                int floorHeight = ((FloorConfigurationFloorView)FloorConfigurationFloorView.this).floorPanel.getBounds().height - 40;
                if (x < 0 || x > floorWidth) {
                    return;
                }
                if (y < 0 || y > floorHeight) {
                    return;
                }
                this.table.setX(x);
                this.table.setY(y);
                FloorConfigurationFloorView.this.setSaveRequired(Boolean.TRUE);
                this.setLocation(x, y);
            }
            catch (Exception e2) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("FloorView.24"));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isControlDown()) {
                ShopTableForm form = new ShopTableForm();
                form.setBean(this.table);
                form.setOnlyStatusEnable();
                final BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)form);
                dialog.setTitle(Messages.getString("FloorView.25"));
                PosButton btnDelete = new PosButton(Messages.getString("FloorView.26"));
                btnDelete.setPreferredSize(new Dimension(100, 60));
                btnDelete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            int option = POSMessageDialog.showYesNoQuestionDialog(TableButton.this.getParent(), Messages.getString("FloorView.27"), POSConstants.CONFIRM);
                            if (option != 0) {
                                return;
                            }
                            FloorConfigurationFloorView.this.floor.getTables().remove(TableButton.this.table);
                            ShopFloorDAO.getInstance().saveOrUpdate(FloorConfigurationFloorView.this.floor);
                            FloorConfigurationFloorView.this.floorPanel.remove(TableButton.this);
                            dialog.dispose();
                        }
                        catch (Exception e2) {
                            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e2.getMessage(), e2);
                        }
                    }
                });
                TransparentPanel buttonPanel = dialog.getButtonPanel();
                Component[] components = buttonPanel.getComponents();
                buttonPanel.removeAll();
                buttonPanel.add(btnDelete);
                for (Component component : components) {
                    buttonPanel.add(component);
                }
                dialog.setPreferredSize(new Dimension(700, 500));
                dialog.open();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.pressedX = e.getX();
            this.pressedY = e.getY();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (FloorConfigurationFloorView.this.reArrange.isSelected()) {
                this.setSelected(false);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

