/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.actions.ActionCommand;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.ui.TableStatusDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.ImageComponent;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.ShopTableButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class FloorStatusDisplay
extends JFrame {
    private DefaultListModel<ShopFloor> listModel = new DefaultListModel();
    private JList<ShopFloor> floorsList = new JList<ShopFloor>(this.listModel);
    private JLayeredPane floorPanel = new JLayeredPane();
    private JPanel contentPanel;
    private TicketAndTablesTableModel tableModel = new TicketAndTablesTableModel();
    private static int buttonWidth = 44;
    private static int buttonHeight = 44;
    Timer updateTimer;

    public FloorStatusDisplay() {
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle(Messages.getString("FloorStatusDisplay.0"));
        this.contentPanel = new JPanel(new BorderLayout(10, 10));
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.renderFloorsList();
        this.createLayoutPanel();
        this.contentPanel.add((Component)new JSeparator(0), "South");
        this.add((Component)this.contentPanel, "Center");
        this.createButtonPanel();
        this.populateFloors();
        this.populateTicketAndTables();
        this.updateTimer = new Timer(30000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloorStatusDisplay.this.populateFloors();
                FloorStatusDisplay.this.populateTicketAndTables();
            }
        });
        this.setSize(Application.getPosWindow().getSize());
        this.setExtendedState(6);
    }

    private void populateTicketAndTables() {
        List<Ticket> openTickets = TicketDAO.getInstance().findOpenTickets();
        if (this.tableModel.getRows() != null) {
            this.tableModel.getRows().clear();
        }
        for (Ticket ticket : openTickets) {
            List<ShopTable> tables = ShopTableDAO.getInstance().getTables(ticket);
            if (tables == null) continue;
            for (ShopTable shopTable : tables) {
                this.tableModel.addItem(new TicketAndTable(ticket, shopTable));
            }
        }
    }

    private void createButtonPanel() {
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("align 50% 50%"));
        PosButton btnOk = new PosButton(ActionCommand.CLOSE.name());
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloorStatusDisplay.this.dispose();
            }
        });
        buttonPanel.add((Component)btnOk, "w 80!");
        this.add((Component)buttonPanel, "South");
    }

    private void populateFloors() {
        try {
            this.listModel.clear();
            List<ShopFloor> shopFloors = ShopFloorDAO.getInstance().findAll();
            for (ShopFloor shopFloor : shopFloors) {
                this.listModel.addElement(shopFloor);
            }
            if (this.listModel.getSize() > 0) {
                this.floorsList.setSelectedIndex(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderFloorsList() {
        JPanel listPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 0"));
        JPanel floorListPanel = new JPanel(new BorderLayout());
        floorListPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("FloorStatusDisplay.4")));
        JScrollPane listScrollPane = new JScrollPane(this.floorsList);
        listScrollPane.setPreferredSize(new Dimension(120, 240));
        floorListPanel.add(listScrollPane);
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                rendererComponent.setPreferredSize(new Dimension(60, 40));
                return rendererComponent;
            }
        };
        this.floorsList.setCellRenderer(renderer);
        this.floorsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ShopFloor selectedValue = (ShopFloor)FloorStatusDisplay.this.floorsList.getSelectedValue();
                if (selectedValue == null) {
                    return;
                }
                try {
                    FloorStatusDisplay.this.renderFloor(selectedValue);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        JPanel tableListPanel = new JPanel(new BorderLayout(5, 5));
        tableListPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("FloorStatusDisplay.5")));
        JXTable ticketAndTablesTable = new JXTable((TableModel)this.tableModel);
        ticketAndTablesTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        ticketAndTablesTable.setRowHeight(40);
        tableListPanel.add(new JScrollPane((Component)ticketAndTablesTable));
        listPanel.add((Component)floorListPanel, "grow, h 200!");
        listPanel.add((Component)tableListPanel, "newline, grow");
        listPanel.setPreferredSize(new Dimension(250, 0));
        this.contentPanel.add((Component)listPanel, "West");
    }

    private void createLayoutPanel() {
        this.floorPanel.setOpaque(true);
        JPanel floorPanelContainer = new JPanel();
        floorPanelContainer.add(this.floorPanel);
        floorPanelContainer.setAutoscrolls(true);
        floorPanelContainer.setBackground(Color.white);
        PosScrollPane scrollPaneFloorPanelContainer = new PosScrollPane(floorPanelContainer);
        scrollPaneFloorPanelContainer.getVerticalScrollBar().setPreferredSize(new Dimension(50, 0));
        scrollPaneFloorPanelContainer.getHorizontalScrollBar().setPreferredSize(new Dimension(0, 50));
        scrollPaneFloorPanelContainer.setBorder(BorderFactory.createTitledBorder(Messages.getString("FloorStatusDisplay.8")));
        this.contentPanel.add((Component)scrollPaneFloorPanelContainer, "Center");
    }

    private void renderFloor(ShopFloor floor) throws Exception {
        this.floorPanel.removeAll();
        if (floor == null) {
            return;
        }
        ImageIcon image = floor.getImage();
        ImageComponent imageComponent = null;
        if (image != null) {
            imageComponent = new ImageComponent(image.getImage());
            imageComponent.setBounds(0, 0, imageComponent.getImageWidth(), imageComponent.getImageHeight());
            this.floorPanel.setPreferredSize(new Dimension(imageComponent.getImageWidth(), imageComponent.getImageHeight()));
            this.floorPanel.add(imageComponent);
        }
        this.renderTables(floor);
        if (imageComponent != null) {
            this.floorPanel.moveToBack(imageComponent);
            this.floorPanel.revalidate();
            this.floorPanel.repaint();
        }
    }

    private void renderTables(ShopFloor floor) {
        Set<ShopTable> tables = floor.getTables();
        if (tables == null) {
            return;
        }
        for (final ShopTable shopTable : tables) {
            final ShopTableButton tableButton = new ShopTableButton(shopTable);
            tableButton.setBounds(shopTable.getX(), shopTable.getY(), buttonWidth, buttonHeight);
            tableButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TableStatusDialog dialog = new TableStatusDialog(shopTable, tableButton);
                    dialog.setSize(350, 300);
                    dialog.setDefaultCloseOperation(2);
                    dialog.setLocationRelativeTo(Application.getPosWindow());
                    dialog.setVisible(true);
                }
            });
            this.floorPanel.add(tableButton);
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.updateTimer.start();
        } else {
            this.updateTimer.stop();
        }
    }

    class TicketAndTablesTableModel
    extends ListTableModel<TicketAndTable> {
        TicketAndTablesTableModel() {
            super(new String[]{"TICKET", "SERVER", "TABLE"});
        }

        TicketAndTablesTableModel(List<TicketAndTable> list) {
            super(new String[]{"TICKET", "SERVER", "TABLE"}, list);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TicketAndTable rowData = (TicketAndTable)this.getRowData(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return rowData.ticket.getId();
                }
                case 1: {
                    return rowData.ticket.getOwner().getFirstName();
                }
                case 2: {
                    return rowData.table.getTableNumber();
                }
            }
            return null;
        }
    }

    class TicketAndTable {
        Ticket ticket;
        ShopTable table;

        public TicketAndTable(Ticket ticket, ShopTable table) {
            this.ticket = ticket;
            this.table = table;
        }
    }
}

