/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.dao.FloorplanDAO;
import com.floreantpos.floorplan.ui.TableBookingForm;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.ui.SearchPanel;
import com.floreantpos.ui.util.UiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;

public class TableBookingSearchPanel
extends SearchPanel<BookingInfo> {
    private JXDatePicker tbStartDate;
    private JXDatePicker tbEndDate;
    private JLabel lblFromDate;
    private JLabel lblToDate;
    private JButton btnSearch;
    private JToggleButton btnTodaysView;

    public TableBookingSearchPanel() {
        this.setLayout((LayoutManager)new MigLayout("", "[][]20[]10[]10[]", "[][]"));
        this.tbStartDate = UiUtil.getCurrentMonthStart();
        this.tbEndDate = UiUtil.getCurrentMonthEnd();
        this.lblFromDate = new JLabel(Messages.getString("TableBookingSearchPanel.0"));
        this.lblToDate = new JLabel(Messages.getString("TableBookingSearchPanel.1"));
        this.btnTodaysView = new JToggleButton(Messages.getString("TableBookingSearchPanel.2"));
        this.btnSearch = new JButton(Messages.getString("TableBookingSearchPanel.4"));
        this.btnSearch.setPreferredSize(new Dimension(60, 50));
        this.btnTodaysView.setPreferredSize(new Dimension(60, 50));
        this.add((Component)this.lblFromDate, "cell 0 0");
        this.add((Component)this.tbStartDate, "cell 1 0");
        this.add((Component)this.lblToDate, "cell 0 1");
        this.add((Component)this.tbEndDate, "cell 1 1");
        this.add((Component)this.btnSearch, "cell 2 0 0 2");
        this.add((Component)new JSeparator(1), "cell 3 0 0 2,grow");
        this.add((Component)this.btnTodaysView, "cell 4 0 0 2,align center");
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("TableBookingSearchPanel.12")));
        this.initActionHandlers();
    }

    private void initActionHandlers() {
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableBookingSearchPanel.this.btnTodaysView.setSelected(false);
                if (TableBookingSearchPanel.this.tbStartDate.getDate().getTime() > TableBookingSearchPanel.this.tbEndDate.getDate().getTime()) {
                    JOptionPane.showMessageDialog(null, Messages.getString("TableBookingSearchPanel.13"));
                    return;
                }
                try {
                    TableBookingSearchPanel.this.getModelBrowser().refreshButtonPanel();
                    Date startDate = TableBookingSearchPanel.this.getStartDate();
                    Date endDate = TableBookingSearchPanel.this.getEndDate();
                    List<BookingInfo> bookingList = FloorplanDAO.getInstance().getAllBookingInfoByDate(startDate, endDate, null, null);
                    TableBookingSearchPanel.this.modelBrowser.setModels(bookingList);
                    TableBookingSearchPanel.this.refreshSearchTable("search", startDate, endDate);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
        this.btnTodaysView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TableBookingSearchPanel.this.getModelBrowser().refreshButtonPanel();
                    AbstractButton abstractButton = (AbstractButton)e.getSource();
                    boolean selected = abstractButton.getModel().isSelected();
                    if (selected) {
                        List<BookingInfo> todaysBookingList = FloorplanDAO.getInstance().getTodaysBooking(null, null);
                        TableBookingSearchPanel.this.modelBrowser.setModels(todaysBookingList);
                        TableBookingSearchPanel.this.refreshSearchTable("todaysview", null, null);
                        return;
                    }
                    List<BookingInfo> bookingList = FloorplanDAO.getInstance().getAllOpenBooking();
                    TableBookingSearchPanel.this.modelBrowser.setModels(bookingList);
                    TableBookingSearchPanel.this.refreshSearchTable("open", null, null);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private Date getEndDate() {
        Calendar endDate = Calendar.getInstance();
        endDate.setLenient(false);
        endDate.setTime(this.tbEndDate.getDate());
        endDate.set(11, 23);
        endDate.set(12, 59);
        endDate.set(13, 59);
        return endDate.getTime();
    }

    private Date getStartDate() {
        Calendar startDate = Calendar.getInstance();
        startDate.setLenient(false);
        startDate.setTime(this.tbStartDate.getDate());
        startDate.set(11, 0);
        startDate.set(12, 0);
        startDate.set(13, 0);
        startDate.set(14, 0);
        return startDate.getTime();
    }

    private void refreshSearchTable(String searchParameter, Date startDate, Date endDate) {
        TableBookingForm tableBookingForm = (TableBookingForm)this.modelBrowser.getBeanEditor();
        tableBookingForm.searchParameter = searchParameter;
        tableBookingForm.stardDateForSearchBooking = startDate;
        tableBookingForm.endDateForSearchBooking = endDate;
    }

    @Override
    public void refreshSearchPanel() {
        super.refreshSearchPanel();
        this.btnTodaysView.setSelected(false);
    }
}

