/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.bo.ui.ModelBrowser;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.ui.ShopTableTypeForm;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.dao.ShopTableTypeDAO;
import com.floreantpos.swing.BeanTableModel;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;

public class TableTypeBrowserPanel
extends ModelBrowser<ShopTableType> {
    public TableTypeBrowserPanel() {
        super(new ShopTableTypeForm());
        BeanTableModel tableModel = new BeanTableModel(ShopTableType.class);
        tableModel.addColumn(Messages.getString("TableTypeBrowserPanel.1"), ShopTableType.PROP_NAME);
        tableModel.addColumn(Messages.getString("TableTypeBrowserPanel.2"), ShopTableType.PROP_DESCRIPTION);
        this.init(tableModel);
        this.browserTable.setAutoResizeMode(4);
        this.setColumnWidth(0, 120);
    }

    @Override
    public void refreshTable() {
        int selectedRow = this.browserTable.getSelectedRow();
        BeanTableModel tableModel = (BeanTableModel)this.browserTable.getModel();
        if (selectedRow >= 0) {
            selectedRow = this.browserTable.convertRowIndexToModel(selectedRow);
        }
        List<ShopTableType> tables = ShopTableTypeDAO.getInstance().findAll();
        tableModel.removeAll();
        tableModel.addRows(tables);
        ListSelectionModel selectionModel = this.browserTable.getSelectionModel();
        int maxIndex = tableModel.getRowCount() - 1;
        if (maxIndex < 0) {
            return;
        }
        selectedRow = selectedRow > maxIndex || selectedRow < 0 ? maxIndex : selectedRow;
        selectionModel.addSelectionInterval(selectedRow, selectedRow);
        Rectangle cellRect = this.browserTable.getCellRect(selectedRow, 0, false);
        this.scrollRectToVisible(cellRect);
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.browserTable.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }
}

