/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui.booking;

import com.floreantpos.PosException;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.ui.booking.BookingTableSelectionFloorView;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;

public class BookingTableSelectionDialog
extends OkCancelOptionDialog
implements ChangeListener {
    private static BookingTableSelectionDialog instance;
    private int guestCount;
    public int selectedCapacity = 0;
    public JLabel selectedTableCapacity;
    private JTabbedPane floorTab;
    private List<ShopTable> selectedTables;
    private Date startDate;
    private Date endDate;
    private JPanel topPanel;
    private JLabel lblGuestNumber;
    public JLabel lblTotalCapacity;
    private ArrayList<ShopTable> previousTables;
    private BookingInfo bookingInfo;

    private BookingTableSelectionDialog() {
        super(POSUtil.getFocusedWindow(), Messages.getString("BookingTableSelectionDialog.0"));
        this.initComponent();
        this.createLayoutPanel();
        this.setResizable(true);
    }

    private void initComponent() {
        this.setOkButtonText(Messages.getString("BookingTableSelectionDialog.1"));
        this.topPanel = new JPanel((LayoutManager)new MigLayout());
        JLabel lblGuestNumberlbl = new JLabel(Messages.getString("BookingTableSelectionDialog.2"));
        this.topPanel.add(lblGuestNumberlbl);
        this.lblGuestNumber = new JLabel();
        this.topPanel.add((Component)this.lblGuestNumber, "");
        Font font = new Font(this.lblGuestNumber.getFont().getFontName(), 1, this.lblGuestNumber.getFont().getSize());
        this.lblGuestNumber.setFont(font);
        JLabel lblTotalCapacityLbl = new JLabel(Messages.getString("BookingTableSelectionDialog.4"));
        this.topPanel.add(lblTotalCapacityLbl);
        this.lblTotalCapacity = new JLabel("0");
        this.topPanel.add((Component)this.lblTotalCapacity, "");
        this.lblTotalCapacity.setFont(font);
        JLabel lblSelectedCapacity = new JLabel(Messages.getString("BookingTableSelectionDialog.7"));
        this.topPanel.add(lblSelectedCapacity);
        this.selectedTableCapacity = new JLabel();
        this.topPanel.add(this.selectedTableCapacity);
        this.selectedTableCapacity.setText("" + this.selectedCapacity);
        this.selectedTableCapacity.setFont(font);
        this.setSize(1024, 600);
        this.floorTab = new JTabbedPane(1, 1);
        this.floorTab.addChangeListener(this);
        PosScrollPane scrollPane = new PosScrollPane(this.floorTab);
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(50, 0));
        scrollPane.getHorizontalScrollBar().setPreferredSize(new Dimension(0, 50));
        this.add((Component)scrollPane, "Center");
    }

    private void createLayoutPanel() {
        try {
            List<ShopFloor> shopFloors = ShopFloorDAO.getInstance().findAll();
            for (ShopFloor shopFloor : shopFloors) {
                BookingTableSelectionFloorView floorView = new BookingTableSelectionFloorView(this, shopFloor);
                this.lblTotalCapacity.setText(floorView.getTableTotalCapacity() + ",");
                this.floorTab.addTab(shopFloor.getName(), floorView);
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void doOk() {
        try {
            int option;
            int tabCount = this.floorTab.getTabCount();
            if (this.selectedTables == null) {
                this.selectedTables = new ArrayList<ShopTable>();
            }
            this.selectedTables.clear();
            for (int i = 0; i < tabCount; ++i) {
                BookingTableSelectionFloorView floorView = (BookingTableSelectionFloorView)this.floorTab.getComponentAt(i);
                List<ShopTable> selectedTables2 = floorView.getSelectedTables();
                if (selectedTables2 == null) continue;
                for (ShopTable shopTable : selectedTables2) {
                    if (this.selectedTables.contains(shopTable)) continue;
                    this.selectedTables.add(shopTable);
                }
            }
            if (this.selectedTables == null || this.selectedTables.isEmpty()) {
                POSMessageDialog.showMessage(Messages.getString("BookingTableSelectionDialog.10"));
                return;
            }
            boolean isContainTable = false;
            Collection subtractedTables = CollectionUtils.subtract(this.selectedTables, this.previousTables);
            boolean isNewAdded = !CollectionUtils.isEmpty((Collection)subtractedTables);
            for (ShopTable shopTable : this.selectedTables) {
                TableStatus selectedTableStatus = shopTable.getShopTableStatus().getTableStatus();
                if (selectedTableStatus.equals((Object)TableStatus.Available) || !isNewAdded || shopTable.getCurrentBookingId() != null && shopTable.getCurrentBookingId().equals(this.bookingInfo.getId())) continue;
                isContainTable = true;
                break;
            }
            if (isContainTable && (option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("BookingTableSelectionDialog.11"), Messages.getString("BookingTableSelectionDialog.12"))) != 0) {
                return;
            }
            if (this.selectedCapacity < this.guestCount && (option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("BookingTableSelectionDialog.13"), Messages.getString("BookingTableSelectionDialog.12"))) != 0) {
                return;
            }
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    public void clearAllFloorSelection(boolean isCancel) {
        int tabCount = this.floorTab.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            List<ShopTable> releasedListModel;
            BookingTableSelectionFloorView floorView = (BookingTableSelectionFloorView)this.floorTab.getComponentAt(i);
            floorView.clearSelection();
            if (!isCancel || (releasedListModel = floorView.getReleasedListModel()) == null || this.selectedTables == null) continue;
            this.selectedTables.addAll(releasedListModel);
        }
    }

    @Override
    public void doCancel() {
        this.clearAllFloorSelection(true);
        this.setCanceled(true);
        this.dispose();
    }

    public List<ShopTable> getSelectedTables() {
        return this.selectedTables;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public static synchronized BookingTableSelectionDialog getInstance() {
        if (instance == null) {
            instance = new BookingTableSelectionDialog();
        }
        return instance;
    }

    public int getGuestCount() {
        return this.guestCount;
    }

    public List<ShopTable> getPreviousTables() {
        return this.previousTables;
    }

    public void updateView() {
        if (this.selectedTables != null && this.selectedTables.size() != 0) {
            for (ShopTable shopTable : this.selectedTables) {
                this.selectedCapacity += shopTable.getCapacity().intValue();
            }
        }
        this.selectedTableCapacity.setText("" + this.selectedCapacity);
        this.renderFloorView();
    }

    private void renderFloorView() {
        BookingTableSelectionFloorView floorView = (BookingTableSelectionFloorView)this.floorTab.getSelectedComponent();
        if (floorView == null) {
            return;
        }
        floorView.renderFloor();
        floorView.updateView();
        int totalCapacity = floorView.getTableTotalCapacity();
        this.lblTotalCapacity.setText(totalCapacity + ",");
        this.topPanel.repaint();
        floorView.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.renderFloorView();
    }

    public int getSelectedCapacity() {
        return this.selectedCapacity;
    }

    public void setSelectedCapacity(int selectedCapacity) {
        this.selectedCapacity = selectedCapacity;
        this.selectedTableCapacity.setText("" + selectedCapacity);
    }

    public void setBookingInfo(BookingInfo tableBookingInfo) {
        this.bookingInfo = tableBookingInfo;
        this.startDate = tableBookingInfo.getFromDate();
        this.endDate = tableBookingInfo.getToDate();
        this.guestCount = tableBookingInfo.getGuestCount();
        this.selectedTables = tableBookingInfo.getTables();
        this.bookingInfo = tableBookingInfo;
        this.startDate = tableBookingInfo.getFromDate();
        this.endDate = tableBookingInfo.getToDate();
        this.guestCount = tableBookingInfo.getGuestCount();
        this.selectedTables = tableBookingInfo.getTables();
        this.lblGuestNumber.setText(this.guestCount + ",");
        this.previousTables = new ArrayList();
        this.previousTables.addAll(this.selectedTables);
    }
}

