/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui.booking;

import com.floreantpos.floorplan.Messages;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.swing.POSComboBox;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class DelaySelectionDialog
extends POSDialog {
    private POSComboBox cbHour;
    private POSComboBox cbMin;
    private BookingInfo tableBookingInfo;

    public DelaySelectionDialog(BookingInfo tableBookingInfo) {
        this.tableBookingInfo = tableBookingInfo;
        this.setSize(PosUIManager.getSize(350, 250));
        this.setTitle(VersionInfo.getAppName());
        this.initComponents();
        this.initData();
    }

    private void initComponents() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("DelaySelectionDialog.0"));
        JPanel mainPanel = new JPanel((LayoutManager)new MigLayout("center", "[][]10px[][]", ""));
        this.cbHour = new POSComboBox();
        this.cbHour.setPreferredSize(new Dimension(100, 0));
        this.cbMin = new POSComboBox();
        mainPanel.add(new JLabel(Messages.getString("DelaySelectionDialog.4")));
        mainPanel.add(this.cbHour);
        mainPanel.add(new JLabel(Messages.getString("DelaySelectionDialog.5")));
        mainPanel.add(this.cbMin);
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton btnOk = new PosButton(Messages.getString("DelaySelectionDialog.7"));
        PosButton btnCancel = new PosButton(Messages.getString("DelaySelectionDialog.8"));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DelaySelectionDialog.this.doOk();
            }
        });
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DelaySelectionDialog.this.setCanceled(true);
                DelaySelectionDialog.this.dispose();
            }
        });
        bottomPanel.add(btnOk);
        bottomPanel.add(btnCancel);
        this.add((Component)titlePanel, "North");
        this.add(mainPanel);
        this.add((Component)bottomPanel, "South");
    }

    protected void doOk() {
        try {
            if (this.tableBookingInfo == null) {
                return;
            }
            int hour = (Integer)this.cbHour.getSelectedItem();
            int min = (Integer)this.cbMin.getSelectedItem();
            if (hour == 0 && min == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DelaySelectionDialog.10"));
                return;
            }
            Date fromDate = this.tableBookingInfo.getFromDate();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(fromDate);
            calendar.add(11, hour);
            calendar.add(12, min);
            int startHour = calendar.get(11);
            int startMin = calendar.get(12);
            this.tableBookingInfo.setFromDate(calendar.getTime());
            Date toDate = this.tableBookingInfo.getToDate();
            calendar.setTime(toDate);
            calendar.add(11, hour);
            calendar.add(12, min);
            int endHour = calendar.get(11);
            int endMin = calendar.get(12);
            this.tableBookingInfo.setToDate(calendar.getTime());
            this.tableBookingInfo.setStartHour(startHour);
            this.tableBookingInfo.setStartMin(startMin);
            this.tableBookingInfo.setEndHour(endHour);
            this.tableBookingInfo.setEndMin(endMin);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DelaySelectionDialog.9"));
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void initData() {
        try {
            Vector<Integer> hours = new Vector<Integer>();
            for (int i = 0; i <= 12; ++i) {
                hours.add(i);
            }
            this.cbHour.setModel(new DefaultComboBoxModel(hours));
            DefaultComboBoxModel<Integer> stMinModel = new DefaultComboBoxModel<Integer>();
            stMinModel.addElement(0);
            stMinModel.addElement(15);
            stMinModel.addElement(30);
            stMinModel.addElement(45);
            this.cbMin.setModel(stMinModel);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }
}

