/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui.configuration;

import com.floreantpos.config.AppProperties;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class CustomColorChooserDialog
extends POSDialog {
    private JColorChooser colorChooser;
    private JButton backgroundButton;
    private JButton foregroundButton;
    private JButton btnOk;
    private JButton btnCancel;
    private Color bgColor;
    private Color foreColor;

    public CustomColorChooserDialog() {
        super(POSUtil.getBackOfficeWindow(), Messages.getString("CustomColorChooserDialog.0"), true);
        this.setTitle(AppProperties.getAppName());
        this.initComponents();
    }

    private void initComponents() {
        this.colorChooser = new JColorChooser();
        ButtonActionListener listener = new ButtonActionListener();
        this.backgroundButton = new JButton(Messages.getString("CustomColorChooserDialog.1"));
        this.backgroundButton.addActionListener(listener);
        this.foregroundButton = new JButton(Messages.getString("CustomColorChooserDialog.2"));
        this.foregroundButton.addActionListener(listener);
        this.btnOk = new JButton(Messages.getString("CustomColorChooserDialog.3"));
        this.btnOk.addActionListener(listener);
        this.btnCancel = new JButton(Messages.getString("CustomColorChooserDialog.4"));
        this.btnCancel.addActionListener(listener);
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        buttonPanel.add(this.backgroundButton);
        buttonPanel.add(this.foregroundButton);
        buttonPanel.add(this.btnOk);
        buttonPanel.add(this.btnCancel);
        this.getContentPane().add((Component)this.colorChooser, "Center");
        this.getContentPane().add((Component)buttonPanel, "Last");
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public Color getForeColor() {
        return this.foreColor;
    }

    public void setForeColor(Color foreColor) {
        this.foreColor = foreColor;
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(CustomColorChooserDialog.this.backgroundButton)) {
                CustomColorChooserDialog.this.backgroundButton.setBackground(CustomColorChooserDialog.this.colorChooser.getColor());
                CustomColorChooserDialog.this.setBgColor(CustomColorChooserDialog.this.colorChooser.getColor());
            } else if (e.getSource().equals(CustomColorChooserDialog.this.foregroundButton)) {
                CustomColorChooserDialog.this.foregroundButton.setBackground(CustomColorChooserDialog.this.colorChooser.getColor());
                CustomColorChooserDialog.this.setForeColor(CustomColorChooserDialog.this.colorChooser.getColor());
            } else if (e.getSource().equals(CustomColorChooserDialog.this.btnOk)) {
                CustomColorChooserDialog.this.setCanceled(false);
                CustomColorChooserDialog.this.dispose();
            } else if (e.getSource().equals(CustomColorChooserDialog.this.btnCancel)) {
                CustomColorChooserDialog.this.setCanceled(true);
                CustomColorChooserDialog.this.dispose();
            }
        }
    }
}

