/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.mailservices;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.mailservices.MailAttachment;
import com.floreantpos.model.MailTemplate;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.MailTemplateUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.sendgrid.Attachments;
import com.sendgrid.Content;
import com.sendgrid.Email;
import com.sendgrid.Mail;
import com.sendgrid.Method;
import com.sendgrid.Request;
import com.sendgrid.Response;
import com.sendgrid.SendGrid;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MailService {
    private static String API_KEY = "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";
    private static String SENDER_EMAIL = "noreply@orocube.com";

    public static void setApiKey(String apiKey) {
        API_KEY = apiKey;
    }

    public static void setSenderEmail(String senderEmail) {
        SENDER_EMAIL = senderEmail;
    }

    public static void sendTicket(String email, Ticket ticket) throws Exception {
        if (!MailService.isValidEmail(email)) {
            throw new PosException(Messages.getString("MailService.3"));
        }
        DataProvider.get().refreshStore();
        Store store = DataProvider.get().getStore();
        TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
        printProperties.setPrintCookingInstructions(false);
        HashMap<String, Object> map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, null);
        String emailSubject = MailTemplateUtil.getTemplate(store, MailTemplate.ReceiptTemplate.getSubjectKey());
        String emailbody = MailTemplateUtil.getTemplate(store, MailTemplate.ReceiptTemplate.getBodyKey());
        emailSubject = MailTemplateUtil.process(emailSubject, map);
        emailbody = MailTemplateUtil.process(emailbody, map);
        byte[] bytes = ReceiptPrintService.createPDFStream(ticket);
        if (!MailService.sendMail(email, emailSubject, emailbody, emailSubject, "TICKET_RECEIPT_" + ticket.getId() + ".pdf", bytes)) {
            throw new PosException(Messages.getString("MailService.8"));
        }
    }

    public static void sendTransaction(String email, PosTransaction transaction) throws Exception {
        if (!MailService.isValidEmail(email)) {
            throw new PosException(Messages.getString("MailService.3"));
        }
        DataProvider.get().refreshStore();
        Store store = DataProvider.get().getStore();
        TicketPrintProperties printProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.6"), true, true, true);
        printProperties.setPrintCookingInstructions(false);
        Ticket ticket = transaction.getTicket();
        HashMap<String, Object> map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, transaction);
        String emailSubject = MailTemplateUtil.getTemplate(store, MailTemplate.ReceiptTemplate.getSubjectKey());
        String emailbody = MailTemplateUtil.getTemplate(store, MailTemplate.ReceiptTemplate.getBodyKey());
        emailSubject = MailTemplateUtil.process(emailSubject, map);
        emailbody = MailTemplateUtil.process(emailbody, map);
        byte[] bytes = ReceiptPrintService.createPDFStream(transaction);
        if (!MailService.sendMail(email, emailSubject, emailbody, emailSubject, "TICKET_RECEIPT_" + transaction.getTicket().getId() + ".pdf", bytes)) {
            throw new PosException(Messages.getString("MailService.8"));
        }
    }

    public static boolean isValidEmail(String email) {
        Pattern validEmailRegExp = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$", 2);
        Matcher matcher = validEmailRegExp.matcher(email);
        return matcher.find();
    }

    public static boolean sendMail(String to, String subject, String contentBody) {
        return MailService.sendMail(to, subject, contentBody, null, null, null);
    }

    public static boolean sendMail(String to, String subject, String contentBody, String contentId, String fileName, byte[] fileData) {
        return MailService.sendMail(to, subject, contentBody, contentId, fileName, fileData, "application/pdf");
    }

    public static boolean sendMailWithAttchments(String to, String subject, String contentBody, List<MailAttachment> reportByteList) {
        try {
            if (StringUtils.isEmpty((String)SENDER_EMAIL) || StringUtils.isEmpty((String)API_KEY)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MailService.6"));
                return false;
            }
            SendGrid sg = new SendGrid(API_KEY);
            Email from = new Email(SENDER_EMAIL);
            Email toEmail = new Email(to);
            Content content = new Content("text/html", contentBody);
            Mail mail = new Mail(from, subject, toEmail, content);
            if (reportByteList != null && reportByteList.size() > 0) {
                for (MailAttachment mailAttachment : reportByteList) {
                    if (mailAttachment.getAttachment() == null) continue;
                    Attachments attachments = new Attachments();
                    Base64 x = new Base64();
                    String encodedData = x.encodeAsString(mailAttachment.getAttachment());
                    attachments.setContent(encodedData);
                    attachments.setType("application/pdf");
                    attachments.setFilename(mailAttachment.getFileName());
                    attachments.setDisposition("attachment");
                    attachments.setContentId(mailAttachment.getFileName());
                    mail.addAttachments(attachments);
                }
            }
            Request request = new Request();
            request.setMethod(Method.POST);
            request.setEndpoint("mail/send");
            request.setBody(mail.build());
            Response response = sg.api(request);
            PosLog.debug(MailService.class, "SendGrid mail send response code: " + response.getStatusCode());
            PosLog.debug(MailService.class, "SendGrid mail send response header: " + response.getHeaders());
            PosLog.info(MailService.class, Messages.getString("MailService.11"));
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean sendMail(String to, String subject, String contentBody, String contentId, String fileName, byte[] fileData, String attachmentContentType) {
        try {
            if (StringUtils.isEmpty((String)SENDER_EMAIL) || StringUtils.isEmpty((String)API_KEY)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MailService.6"));
                return false;
            }
            SendGrid sg = new SendGrid(API_KEY);
            Email from = new Email(SENDER_EMAIL);
            Email toEmail = new Email(to);
            ArrayList<Attachments> imageAttachments = new ArrayList<Attachments>();
            Document doc = Jsoup.parse((String)contentBody);
            Elements images = doc.select("img");
            for (Element image : images) {
                String src = image.attr("src");
                String b64 = src.substring(src.indexOf("base64,") + 7, src.length() - 1);
                String imgContentId = RandomStringUtils.random((int)5, (boolean)true, (boolean)true);
                image.attr("src", "cid:" + imgContentId);
                image.removeAttr("width");
                image.removeAttr("height");
                Attachments attachments = new Attachments();
                attachments.setContent(b64);
                attachments.setType("image/png");
                attachments.setFilename(imgContentId);
                attachments.setDisposition("inline");
                attachments.setContentId(imgContentId);
                imageAttachments.add(attachments);
            }
            contentBody = doc.html();
            Content content = new Content("text/html", contentBody);
            Mail mail = new Mail(from, subject, toEmail, content);
            for (Attachments attachments : imageAttachments) {
                mail.addAttachments(attachments);
            }
            if (fileData != null) {
                Attachments attachments = new Attachments();
                Base64 x = new Base64();
                String encodedData = x.encodeAsString(fileData);
                attachments.setContent(encodedData);
                attachments.setType(attachmentContentType);
                attachments.setFilename(fileName);
                attachments.setDisposition("attachment");
                attachments.setContentId(contentId);
                mail.addAttachments(attachments);
            }
            Request request = new Request();
            request.setMethod(Method.POST);
            request.setEndpoint("mail/send");
            request.setBody(mail.build());
            Response response = sg.api(request);
            PosLog.debug(MailService.class, "SendGrid mail send response code: " + response.getStatusCode());
            PosLog.debug(MailService.class, "SendGrid mail send response header: " + response.getHeaders());
            PosLog.info(MailService.class, Messages.getString("MailService.11"));
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void doSendEmailPosLogFile(String request) {
        try {
            JSONObject rootElement = new JSONObject(request);
            String adminEmail = rootElement.getString("data");
            PosLog.debug(MailService.class, "Request received: " + request);
            if (StringUtils.isEmpty((String)adminEmail)) {
                PosLog.error(MailService.class, Messages.getString("MailService.4"));
                return;
            }
            String fileName = VersionInfo.getAppName() + ".log";
            File logFile = new File(System.getProperty("user.home") + "\\" + fileName);
            if (!logFile.exists()) {
                PosLog.error(MailService.class, Messages.getString("MailService.15"));
                return;
            }
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            String subject = VersionInfo.getAppName() + " log";
            String contentBody = "<html><body>Terminal no: " + terminal.getId() + "<br/>Terminal name: " + terminal.getName() + "</body></html>";
            MailService.sendMail(adminEmail, subject, contentBody, fileName, fileName, FileUtils.readFileToByteArray((File)logFile), "text/plain");
        }
        catch (Exception e) {
            PosLog.error(MailService.class, e.getMessage());
        }
    }
}

