/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main;

import com.floreantpos.PosLog;
import com.floreantpos.main.Main;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;

public class ProcessUtil {
    public static void restart() {
        try {
            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            String mainClass = "com.floreantpos.main.Main";
            File currentJar = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            String appJar = URLDecoder.decode(currentJar.getPath(), "UTF-8");
            File appDir = new File(appJar);
            if (appDir.isFile()) {
                appDir = appDir.getParentFile();
            }
            StringBuilder classPath = new StringBuilder();
            classPath.append(appJar);
            classPath.append(File.pathSeparator);
            classPath.append(appDir + File.separator + "i18n");
            classPath.append(File.pathSeparator);
            classPath.append(appDir + File.separator + "config");
            classPath.append(File.pathSeparator);
            classPath.append(appDir + File.separator + "lib" + File.separator + "*");
            classPath.append(File.pathSeparator);
            classPath.append(appDir + File.separator + "plugins" + File.separator + "*");
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaBin);
            command.add("-cp");
            command.add(classPath.toString());
            command.add(mainClass);
            PosLog.info(Main.class, "restart command: " + command);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory(appDir);
            builder.start();
            System.exit(0);
        }
        catch (Exception e) {
            PosLog.error(Main.class, e);
        }
    }
}

