/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.MemberType;
import com.floreantpos.model.base.BaseCustomer;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.model.util.ColorPref;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringUtils;

public class Customer
extends BaseCustomer {
    private static final long serialVersionUID = 1L;
    public static final String APPETIZER_PREF = "appetizerPref";
    public static final String BILLINGSTATEMENT_PREF = "billingStatementPref";
    public static final String COCKTAIL_PREF = "cocktailPref";
    public static final String DESSERT_PREF = "dessertPref";
    public static final String ENTREE_PREF = "entreePref";
    public static final String GOLFBALL_PREF = "golfBallPref";
    public static final String MEAL_PREF = "mealPref";
    public static final String PAYMENT_PREF = "paymentPref";
    public static final String PILLOW_PREF = "pillowPref";
    public static final String ROLLAWAYCRIB_PREF = "rollawayCribPref";
    public static final String SEATING_PREF = "seatingPref";
    public static final String SMOKING_PREF = "smokingPref";
    public static final String WINE_PREF = "winePref";
    public static final String ROOM_ACCESS_PREF = "roomAccessPref";
    public static final String ROOM_LOC_PREF = "roomLocPref";
    public static final String ROOM_NUMBER_PREF = "roomNumberPref";
    public static final String REMAINING_CURRENT_QUARTER = "club62__Remaining_Current_Quarter_F_B_Spends__c";
    public static final String STATUS = "club62__Status__c";
    public static final String STREET_1 = "street_1";
    public static final String STREET_2 = "street_2";
    public static final String STREET_3 = "street_3";
    public static final String JSON_PROP_TAX_EXMPT_NO = "taxExemptNo";
    public static final String JSON_PROP_REQUIRE_CASH_OR_CREDIT = "require_cash_or_credit";
    public static final String JSON_PROP_MEMBERSHIP_TYPE = "Membership_type";
    private Boolean selected;
    private transient JsonObject propertiesContainer;
    private transient SimpleDateFormat month_date = new SimpleDateFormat("MMM", Locale.ENGLISH);
    private transient SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private ColorPref colorPref;

    public Customer() {
    }

    public Customer(String id) {
        super(id);
    }

    @Override
    public String toString() {
        String fName = this.getName();
        return fName;
    }

    public ImageIcon getImage() {
        return null;
    }

    @Override
    public String getName() {
        String name = super.getFirstName();
        if (StringUtils.isNotEmpty((String)super.getLastName())) {
            name = name + " " + super.getLastName();
        }
        return name;
    }

    @Override
    public void setMobileNo(String mobileNo) {
        if (StringUtils.isNotEmpty((String)mobileNo)) {
            mobileNo = mobileNo.replaceAll("(\\+)?\\D", "$1");
        }
        super.setMobileNo(mobileNo);
    }

    @Override
    public void setWorkPhoneNo(String workPhoneNo) {
        if (StringUtils.isNotEmpty((String)workPhoneNo)) {
            workPhoneNo = workPhoneNo.replaceAll("(\\+)?\\D", "$1");
        }
        super.setWorkPhoneNo(workPhoneNo);
    }

    @Override
    public void setHomePhoneNo(String homePhoneNo) {
        if (StringUtils.isNotEmpty((String)homePhoneNo)) {
            homePhoneNo = homePhoneNo.replaceAll("(\\+)?\\D", "$1");
        }
        super.setHomePhoneNo(homePhoneNo);
    }

    public Boolean isSelected() {
        return this.selected == null ? Boolean.FALSE : this.selected;
    }

    public void setSelected(Boolean enable) {
        this.selected = enable;
    }

    public CustomerGroup getCustomerGroup() {
        if (StringUtils.isNotEmpty((String)this.getCustomerGroupId())) {
            return CustomerGroupDAO.getInstance().get(this.getCustomerGroupId());
        }
        return null;
    }

    public void setCustomerGroup(CustomerGroup customerGroup) {
        String customerGroupId = null;
        if (customerGroup != null) {
            customerGroupId = customerGroup.getId();
        }
        super.setCustomerGroupId(customerGroupId);
    }

    public MemberType getMemberType() {
        if (StringUtils.isNotEmpty((String)this.getMemberTypeName())) {
            return MemberType.fromName(this.getMemberTypeName());
        }
        return null;
    }

    public void setMemberType(MemberType memberType) {
        if (memberType != null) {
            this.setMemberTypeName(memberType.getName());
        }
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String properties = super.getProperties();
        if (StringUtils.isEmpty((String)properties)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        return properties;
    }

    @Override
    public void setProperties(String properties) {
        super.setProperties(properties);
        if (StringUtils.isNotEmpty((String)properties)) {
            this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        }
    }

    public void addProperty(String key, String value) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        if (StringUtils.isNotEmpty((String)value)) {
            this.propertiesContainer.addProperty(key, value);
        }
    }

    public String getProperty(String key) {
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(key)) {
            return this.propertiesContainer.get(key).getAsString();
        }
        return null;
    }

    public boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    public boolean isPropertyValueTrue(String propertyName) {
        String property = this.getProperty(propertyName);
        return POSUtil.getBoolean(property);
    }

    public void removeProperty(String propertyName) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(propertyName);
        }
    }

    @JsonIgnore
    public String getFormattedDob() {
        try {
            String formattedDate = null;
            String dob = super.getDob();
            if (dob != null) {
                Date date = this.sdf.parse(dob);
                formattedDate = this.month_date.format(date) + " " + dob.substring(8, 10) + "," + dob.substring(0, 4);
            }
            return formattedDate;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setFormattedDob(String formattedDate) {
    }

    public boolean isRequireCashOrCredit() {
        return POSUtil.getBoolean(this.getProperty(JSON_PROP_REQUIRE_CASH_OR_CREDIT));
    }

    public void setRequireCashOrCredit(boolean isRequireCashOrCredit) {
        this.addProperty(JSON_PROP_REQUIRE_CASH_OR_CREDIT, String.valueOf(isRequireCashOrCredit));
    }

    public void setMemberShipType(String memberShipType) {
        this.addProperty(JSON_PROP_MEMBERSHIP_TYPE, memberShipType);
    }

    public String getMemberShipType() {
        return this.getProperty(JSON_PROP_MEMBERSHIP_TYPE);
    }

    public ColorPref getColorPrefs() {
        if (this.colorPref == null) {
            this.colorPref = new ColorPref();
            this.colorPref.setBlueFlag(this.isBlueFlag());
            this.colorPref.setGreenFlag(this.isGreenFlag());
            this.colorPref.setPurpleFlag(this.isPurpleFlag());
            this.colorPref.setOrangeFlag(this.isOrangeFlag());
            this.colorPref.setRedFlag(this.isRedFlag());
            this.colorPref.setYellowFlag(this.isYellowFlag());
        }
        return this.colorPref;
    }

    public void setColorPrefs(ColorPref colorPref) {
    }

    public void setBlueFlag(Boolean flag) {
        if (flag == null) {
            return;
        }
        this.addProperty("blueFlag", String.valueOf(flag));
    }

    public boolean isBlueFlag() {
        return Boolean.parseBoolean(this.getProperty("blueFlag"));
    }

    public void setGreenFlag(Boolean flag) {
        if (flag == null) {
            return;
        }
        this.addProperty("greenFlag", String.valueOf(flag));
    }

    public boolean isGreenFlag() {
        return Boolean.parseBoolean(this.getProperty("greenFlag"));
    }

    public void setOrangeFlag(Boolean flag) {
        if (flag == null) {
            return;
        }
        this.addProperty("orangeFlag", String.valueOf(flag));
    }

    public boolean isOrangeFlag() {
        return Boolean.parseBoolean(this.getProperty("orangeFlag"));
    }

    public void setPurpleFlag(Boolean flag) {
        if (flag == null) {
            return;
        }
        this.addProperty("purpleFlag", String.valueOf(flag));
    }

    public boolean isPurpleFlag() {
        return Boolean.parseBoolean(this.getProperty("purpleFlag"));
    }

    public void setRedFlag(Boolean flag) {
        if (flag == null) {
            return;
        }
        this.addProperty("redFlag", String.valueOf(flag));
    }

    public boolean isRedFlag() {
        return Boolean.parseBoolean(this.getProperty("redFlag"));
    }

    public void setYellowFlag(Boolean flag) {
        if (flag == null) {
            return;
        }
        this.addProperty("yellowFlag", String.valueOf(flag));
    }

    public boolean isYellowFlag() {
        return Boolean.parseBoolean(this.getProperty("yellowFlag"));
    }
}

