/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseInventoryUnit;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"uniqueId"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class InventoryUnit
extends BaseInventoryUnit
implements IUnit,
TimedModel,
PropertyContainer {
    private static final long serialVersionUID = 1L;
    public static final String PROP_CONVERSION_RULE = "conversion.rule";
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;
    private InventoryUnitGroup unitGroup;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public InventoryUnit() {
    }

    public InventoryUnit(String id) {
        super(id);
    }

    public InventoryUnit(String id, String code) {
        super(id, code);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    @JsonIgnore
    public String getUniqueCode() {
        return super.getCode();
    }

    public InventoryUnitGroup getUnitGroup() {
        String unitGroupId = this.getUnitGroupId();
        if (StringUtils.isEmpty((String)unitGroupId)) {
            return null;
        }
        if (this.unitGroup != null && unitGroupId.equals(this.unitGroup.getId())) {
            return this.unitGroup;
        }
        this.unitGroup = InventoryUnitGroupDAO.getInstance().get(unitGroupId);
        return this.unitGroup;
    }

    @XmlTransient
    public void setUnitGroup(InventoryUnitGroup unitGroup) {
        this.unitGroup = unitGroup;
    }

    public String getUniqueId() {
        return ("unit_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    public double getBaseUnitConversionValue() {
        double baseConversionValue = 0.0;
        List<InventoryUnit> units = this.getUnitGroup().getUnits();
        if (units != null && units.size() > 0) {
            for (InventoryUnit groupUnit : units) {
                if (!groupUnit.isBaseUnit().booleanValue()) continue;
                baseConversionValue = groupUnit.getConversionRate();
                break;
            }
        }
        return baseConversionValue * this.getConversionRate();
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new JsonObject() : (JsonObject)new Gson().fromJson(super.getProperties(), JsonObject.class);
        }
        return this.propertiesContainer;
    }
}

