/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.Messages;
import com.floreantpos.model.DayOfWeek;
import com.floreantpos.model.base.BaseMenuShift;
import java.text.SimpleDateFormat;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
public class MenuShift
extends BaseMenuShift {
    private static final long serialVersionUID = 1L;
    private String dayOfWeekAsString;
    private String formattedStartTime;
    private String formattedEndTime;

    public MenuShift() {
    }

    public MenuShift(String id) {
        super(id);
    }

    public MenuShift(String id, String name) {
        super(id, name);
    }

    public String getDayOfWeekAsString() {
        String daysDisplay = "";
        String daysString = this.getDaysOfWeek();
        if (StringUtils.isNotEmpty((String)daysString)) {
            String[] split = daysString.split(",");
            if (split.length == 7) {
                return Messages.getString("MenuShift.2");
            }
            if (split.length > 0) {
                for (int i = 0; i < split.length; ++i) {
                    int day = Integer.valueOf(split[i]);
                    DayOfWeek week = DayOfWeek.getDayOfWeek(day);
                    daysDisplay = daysDisplay + week.name();
                    if (i == split.length - 1) continue;
                    daysDisplay = daysDisplay + ",";
                }
            }
        }
        return daysDisplay;
    }

    public boolean isAnyDay() {
        String[] split;
        String daysString = this.getDaysOfWeek();
        return daysString != null && (split = daysString.split(",")).length == 7;
    }

    public void setAnyDay(boolean selected) {
        if (selected) {
            this.setDaysOfWeek(Messages.getString("MenuShift.5"));
        }
    }

    public String getFormattedStartTime() {
        this.formattedStartTime = new SimpleDateFormat("hh:mm a").format(this.getStartTime());
        return this.formattedStartTime;
    }

    public String getFormattedEndTime() {
        this.formattedEndTime = new SimpleDateFormat("hh:mm a").format(this.getEndTime());
        return this.formattedEndTime;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

