/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.floreantpos.PosLog;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseModifierGroup;
import com.floreantpos.model.dao.MenuItemModifierPageDAO;
import com.floreantpos.ui.model.ModifierPricingRule;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"displayName"})
@XmlRootElement
public class ModifierGroup
extends BaseModifierGroup
implements TimedModel,
PropertyContainer {
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;
    public static final String JSON_PROP_PRICE_RULES = "priceRules";
    public static final String JSON_PROP_ENABLE_GROUP_PRICE = "enableGroupPricing";
    public static final String JSON_PROP_MODIFIER_PAGE_IDS = "modifierPageIds";
    private Map<Integer, Double> priceMap;
    private ArrayList<ModifierPricingRule> pricingRules;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public ModifierGroup() {
    }

    public ModifierGroup(String id) {
        super(id);
    }

    @Override
    public String toString() {
        return super.getName();
    }

    public String getDisplayName() {
        return super.getName();
    }

    public String getUniqueId() {
        return ("modifiergroup_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new JsonObject() : (JsonObject)new Gson().fromJson(super.getProperties(), JsonObject.class);
        }
        return this.propertiesContainer;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String properties = super.getProperties();
        if (StringUtils.isEmpty((String)properties)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        return properties;
    }

    public boolean isEnableGroupPricing() {
        return this.hasProperty(JSON_PROP_ENABLE_GROUP_PRICE) && this.getBooleanProperty(JSON_PROP_ENABLE_GROUP_PRICE, false) != false;
    }

    public boolean hasPriceRules() {
        return this.isEnableGroupPricing() && this.hasProperty(JSON_PROP_PRICE_RULES);
    }

    public Double getPrice(Integer quantity) {
        if (!this.hasPriceRules()) {
            return null;
        }
        if (this.priceMap != null) {
            return this.priceMap.get(quantity);
        }
        this.priceMap = new HashMap<Integer, Double>();
        List priceList = this.getPriceRules();
        if (priceList != null && priceList.size() > 0) {
            for (ModifierPricingRule pricing : priceList) {
                for (int i = pricing.getFromQty().intValue(); i <= pricing.getToQty(); ++i) {
                    this.priceMap.put(i, pricing.getPrice());
                }
            }
        }
        return this.priceMap.get(quantity);
    }

    public List getPriceRules() {
        try {
            JsonNode arrayNode;
            String properties;
            if (this.pricingRules == null) {
                this.pricingRules = new ArrayList();
            }
            if (StringUtils.isEmpty((String)(properties = this.getProperties()))) {
                return this.pricingRules;
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode readTree = mapper.readTree(properties);
            if (readTree != null && (arrayNode = readTree.findValue(JSON_PROP_PRICE_RULES)) != null) {
                this.pricingRules = (ArrayList)mapper.readValue(arrayNode.toString(), (TypeReference)new TypeReference<List<ModifierPricingRule>>(){});
                return this.pricingRules;
            }
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
        return this.pricingRules;
    }

    public List<MenuItemModifierPage> getModifierGroupPages() {
        String[] modifierGroupPageIdList;
        ArrayList<MenuItemModifierPage> menuItemModifierPages = new ArrayList<MenuItemModifierPage>();
        for (String modifierGroupPageId : modifierGroupPageIdList = this.getModifierGroupPageIds()) {
            MenuItemModifierPage menuItemModifierPage;
            if (StringUtils.isBlank((String)modifierGroupPageId) || (menuItemModifierPage = MenuItemModifierPageDAO.getInstance().get(modifierGroupPageId.trim())) == null) continue;
            menuItemModifierPages.add(menuItemModifierPage);
        }
        return menuItemModifierPages;
    }

    public String[] getModifierGroupPageIds() {
        String property = this.getProperty(JSON_PROP_MODIFIER_PAGE_IDS, "");
        return property.split(",");
    }

    public void setModifierPageIds(String ids) {
        this.addProperty(JSON_PROP_MODIFIER_PAGE_IDS, ids);
    }
}

