/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.PayoutReason;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.base.BasePayOutTransaction;
import com.floreantpos.model.dao.PayoutReasonDAO;
import com.floreantpos.model.dao.PayoutRecepientDAO;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
public class PayOutTransaction
extends BasePayOutTransaction {
    private static final long serialVersionUID = 1L;
    private PayoutReason reason;
    private PayoutRecepient recepient;

    public PayOutTransaction() {
    }

    public PayOutTransaction(String id) {
        super(id);
    }

    public PayOutTransaction(String id, String transactionType, String paymentTypeString) {
        super(id, transactionType, paymentTypeString);
    }

    @Override
    public String getTransactionType() {
        String type = super.getTransactionType();
        if (StringUtils.isEmpty((String)type)) {
            return TransactionType.DEBIT.name();
        }
        return type;
    }

    public PayoutReason getReason() {
        String payoutReason = this.getReasonId();
        if (this.reason != null && this.reason.getId().equals(payoutReason)) {
            return this.reason;
        }
        if (StringUtils.isNotEmpty((String)payoutReason)) {
            this.reason = PayoutReasonDAO.getInstance().get(payoutReason);
        }
        return this.reason;
    }

    public void setReason(PayoutReason payoutReason) {
        this.reason = payoutReason;
        String payoutReasonId = null;
        if (payoutReason != null) {
            payoutReasonId = payoutReason.getId();
        }
        super.setReasonId(payoutReasonId);
    }

    public PayoutRecepient getRecepient() {
        String payoutPayoutRecepient = this.getRecepientId();
        if (this.recepient != null && this.recepient.getId().equals(payoutPayoutRecepient)) {
            return this.recepient;
        }
        if (StringUtils.isNotEmpty((String)payoutPayoutRecepient)) {
            this.recepient = PayoutRecepientDAO.getInstance().get(payoutPayoutRecepient);
        }
        return this.recepient;
    }

    public void setRecepient(PayoutRecepient payoutPayoutRecepient) {
        this.recepient = payoutPayoutRecepient;
        String recepientId = null;
        if (payoutPayoutRecepient != null) {
            recepientId = payoutPayoutRecepient.getId();
        }
        super.setRecepientId(recepientId);
    }
}

