/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.config.CardConfig;
import com.floreantpos.extension.PosGiftCardPlugin;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.payment.CreditBookPaymentPlugin;
import com.floreantpos.payment.MemberPaymentPlugin;
import com.floreantpos.payment.PaymentPlugin;

public enum PaymentType {
    CUSTOM_PAYMENT("CUSTOM PAYMENT"),
    CASH("CASH"),
    MEMBER_ACCOUNT("MEMBER ACCOUNT"),
    CHARGE_TO_ROOM("CHARGE TO ROOM"),
    GUEST_PASS("GUEST_PASS"),
    CREDIT_CARD("CREDIT CARD"),
    DEBIT_CARD("DEBIT CARD"),
    CREDIT_DISCOVERY("DISCOVER", "discover_card.png"),
    GIFT_CERTIFICATE("GIFT CERTIFICATE"),
    CREDIT_BOOK("CREDIT BOOK"),
    PROMOTION("PROMOTION");

    private String displayString;
    private String imageFile;

    private PaymentType(String display) {
        this.displayString = display;
    }

    private PaymentType(String display, String image) {
        this.displayString = display;
        this.imageFile = image;
    }

    public String toString() {
        return this.displayString;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public void setDisplayString(String displayString) {
        this.displayString = displayString;
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(String imageFile) {
        this.imageFile = imageFile;
    }

    public boolean isSupported() {
        switch (this) {
            case CASH: {
                return true;
            }
        }
        return CardConfig.isSwipeCardSupported() || CardConfig.isManualEntrySupported() || CardConfig.isExtTerminalSupported();
    }

    public static PaymentType fromDisplayString(String displayString) {
        PaymentType[] paymentTypes;
        for (PaymentType paymentType : paymentTypes = PaymentType.values()) {
            if (!paymentType.getDisplayString().equals(displayString)) continue;
            return paymentType;
        }
        return null;
    }

    public PosTransaction createTransaction() {
        PosTransaction transaction = null;
        switch (this) {
            case CREDIT_CARD: {
                transaction = new CreditCardTransaction();
                transaction.setAuthorizable(true);
                break;
            }
            case DEBIT_CARD: {
                transaction = new DebitCardTransaction();
                transaction.setAuthorizable(true);
                break;
            }
            case GIFT_CERTIFICATE: {
                transaction = new GiftCertificateTransaction();
                break;
            }
            case CUSTOM_PAYMENT: {
                transaction = new CustomPaymentTransaction();
                break;
            }
            case CREDIT_BOOK: {
                transaction = new CustomPaymentTransaction();
                transaction.setPaymentType(CREDIT_BOOK);
                ((CustomPaymentTransaction)transaction).setCustomPaymentFieldName(CREDIT_BOOK.name());
                ((CustomPaymentTransaction)transaction).setCustomPaymentName(CREDIT_BOOK.name());
                transaction.setCaptured(true);
                break;
            }
            case MEMBER_ACCOUNT: {
                transaction = new CustomerAccountTransaction();
                break;
            }
            case PROMOTION: {
                transaction = new CustomPaymentTransaction();
                break;
            }
            default: {
                transaction = new CashTransaction();
            }
        }
        transaction.setPaymentType(this);
        return transaction;
    }

    public PosTransaction createTransaction(Ticket ticket, double tenderAmount) {
        PosTransaction transaction = null;
        switch (this) {
            case CREDIT_CARD: {
                transaction = new CreditCardTransaction();
                transaction.setAuthorizable(true);
                break;
            }
            case DEBIT_CARD: {
                transaction = new DebitCardTransaction();
                transaction.setAuthorizable(true);
                break;
            }
            case GIFT_CERTIFICATE: {
                transaction = new GiftCertificateTransaction();
                break;
            }
            case CUSTOM_PAYMENT: {
                transaction = new CustomPaymentTransaction();
                break;
            }
            case CREDIT_BOOK: {
                transaction = new CustomPaymentTransaction();
                transaction.setPaymentType(CREDIT_BOOK);
                ((CustomPaymentTransaction)transaction).setCustomPaymentFieldName(CREDIT_BOOK.name());
                ((CustomPaymentTransaction)transaction).setCustomPaymentName(CREDIT_BOOK.name());
                transaction.setCaptured(true);
                break;
            }
            case MEMBER_ACCOUNT: {
                transaction = new CustomerAccountTransaction();
                break;
            }
            case PROMOTION: {
                transaction = new CustomPaymentTransaction();
                break;
            }
            default: {
                transaction = new CashTransaction();
            }
        }
        transaction.setTicket(ticket);
        transaction.setTenderAmount(tenderAmount);
        if (ticket != null && tenderAmount >= ticket.getDueAmount()) {
            transaction.setAmount(ticket.getDueAmount());
        } else {
            transaction.setAmount(tenderAmount);
        }
        transaction.setPaymentType(this);
        return transaction;
    }

    public boolean isCreditCard() {
        switch (this) {
            case CREDIT_CARD: {
                return true;
            }
        }
        return false;
    }

    public PaymentPlugin getPaymentPlugin() {
        switch (this) {
            case GIFT_CERTIFICATE: {
                return new PosGiftCardPlugin();
            }
            case CREDIT_BOOK: {
                return new CreditBookPaymentPlugin();
            }
            case MEMBER_ACCOUNT: {
                return new MemberPaymentPlugin();
            }
        }
        return null;
    }
}

