/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.Department;
import com.floreantpos.model.IdContainer;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.YellowDogStore;
import com.floreantpos.model.base.BaseSalesArea;
import com.floreantpos.model.dao.DepartmentDAO;
import com.foretees.yellowDog.YellowDogUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.json.JSONTokener;

@JsonIgnoreProperties(ignoreUnknown=true, value={"department"})
@XmlRootElement
public class SalesArea
extends BaseSalesArea
implements IdContainer,
TimedModel,
PropertyContainer {
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public SalesArea() {
    }

    public SalesArea(String id) {
        super(id);
    }

    @Override
    public String toString() {
        return super.getName();
    }

    @XmlTransient
    public Department getDepartment() {
        if (StringUtils.isNotEmpty((String)this.getDepartmentId())) {
            return DepartmentDAO.getInstance().get(this.getDepartmentId());
        }
        return null;
    }

    public void setDepartment(Department department) {
        String deptId = null;
        if (department != null) {
            deptId = department.getId();
        }
        super.setDepartmentId(deptId);
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String properties = super.getProperties();
        if (StringUtils.isEmpty((String)properties)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        return properties;
    }

    @Override
    public void setProperties(String properties) {
        super.setProperties(properties);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }

    public String getYellowDogCustomerLocation() {
        String property = this.getProperty("yellow_dog_location");
        if (StringUtils.isNotBlank((String)property)) {
            JSONObject jsonObject = new JSONObject(property);
            return jsonObject.getString("name");
        }
        return property;
    }

    public String getYellowDogId() {
        String property = this.getProperty("yellow_dog_location");
        if (StringUtils.isNotBlank((String)property)) {
            JSONObject jsonObject = new JSONObject(property);
            return jsonObject.getString("id");
        }
        return property;
    }

    public void setYellowDogCustomerLocation(String customerLocation) {
        this.addProperty("yellow_dog_location", customerLocation);
    }

    public YellowDogStore getYellowDogStore() {
        String getResult = this.getProperty("yellow_dog_location");
        if (getResult != null) {
            JSONObject jsonObject = (JSONObject)new JSONTokener(getResult).nextValue();
            return YellowDogUtil.convertToYellowDogStore(jsonObject);
        }
        return null;
    }
}

