/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseShopSeat;
import com.floreantpos.model.dao.ShopTableDAO;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true, value={"shopTable", "member"})
public class ShopSeat
extends BaseShopSeat
implements TimedModel,
PropertyContainer {
    private static final long serialVersionUID = 1L;
    private transient JsonObject propertiesContainer;
    private Customer member;
    private ShopTable shopTable;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    public ShopSeat() {
    }

    public ShopSeat(String id) {
        super(id);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public ShopSeat(ShopTable table, int seatNumber, int x, int y) {
        this.setTableId(table.getId());
        this.setSeatNumber(seatNumber);
        this.setPosX(x);
        this.setPosY(y);
    }

    @Override
    public String toString() {
        return String.valueOf(super.getSeatNumber());
    }

    public TicketItemSeat convertTicketItemSeat() {
        TicketItemSeat ticketItemSeat = new TicketItemSeat();
        ticketItemSeat.setShopSeat(this);
        return ticketItemSeat;
    }

    public Customer getMember() {
        return this.member;
    }

    public void setMember(Customer member) {
        this.member = member;
    }

    @XmlTransient
    public ShopTable getShopTable() {
        if (this.shopTable == null && this.getTableId() != null) {
            this.shopTable = ShopTableDAO.getInstance().get(this.getTableId());
        }
        return this.shopTable;
    }

    public void setShopTable(ShopTable shopTable) {
        this.shopTable = shopTable;
    }

    public double getAngle() {
        String angleText = this.getProperty("angle");
        if (StringUtils.isNotEmpty((String)angleText)) {
            try {
                return Double.parseDouble(angleText);
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), e);
            }
        }
        return 0.0;
    }

    public void setAngle(double angle) {
        this.addProperty("angle", String.valueOf(angle));
    }

    public String getSeatNumberWithTableName() {
        ShopTable shopTable = this.getShopTable();
        return (shopTable != null ? shopTable.getNameOrNumber() : "Ex") + ", S." + this.getSeatNumber();
    }

    public String getSeatNumberWithTableName(Ticket ticket) {
        List<Integer> tableNumbers = null;
        tableNumbers = ticket != null ? ticket.getTableNumbers() : new ArrayList<Integer>(1);
        if (tableNumbers.size() > 1) {
            ShopTable shopTable = this.getShopTable();
            return (shopTable != null ? shopTable.getNameOrNumber() : "Ex") + ", S." + this.getSeatNumber();
        }
        return "S." + this.getSeatNumber();
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new JsonObject() : (JsonObject)new Gson().fromJson(super.getProperties(), JsonObject.class);
        }
        return this.propertiesContainer;
    }
}

