/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.Store;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseShopTable;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.GlobalIdGenerator;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true, value={"typesAsString", "floor", "userName", "image"})
public class ShopTable
extends BaseShopTable
implements TimedModel,
PropertyContainer {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_RECTANGLE = 0;
    public static final int TYPE_ROUNDED_RECTANGLE = 1;
    public static final int TYPE_ROUND = 2;
    public static final int TYPE_POLYGON = 3;
    public static final int TYPE_CUSTOM = 4;
    public static final String RESERVATION_NUMBER = "RES_NO";
    private Date ticketCreateTime;
    private boolean showStatus;
    private boolean reArrange;
    private int guestNumber;
    private String typesAsString;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;
    public static final SimpleDateFormat bookingDateFormat = new SimpleDateFormat("yyyy-MMM-dd hh:mm:ss");
    private boolean isTemporary;

    public ShopTable() {
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
    }

    public ShopTable(Integer id) {
        super(id);
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
    }

    public ShopTable(Integer id, String globalId) {
        super(id, globalId);
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
    }

    public ShopTable(Integer x, Integer y) {
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
        this.setX(x);
        this.setY(y);
    }

    public ShopTable(ShopFloor floor, Integer x, Integer y, Integer id) {
        this.setGlobalId(GlobalIdGenerator.generateGlobalId());
        this.setCapacity(4);
        this.setId(id);
        this.setFloorId(floor.getId());
        this.setX(x);
        this.setY(y);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public TableStatus getTableStatus() {
        return this.getShopTableStatus().getTableStatus();
    }

    public void setTableStatus(TableStatus tableStatus) {
        this.setTableStatusNum(tableStatus.getValue());
    }

    private void setTableStatusNum(int value) {
        ShopTableStatus status = this.getStatus();
        status.setTableStatusNum(value);
    }

    public Integer getTableNumber() {
        return this.getId();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getTableNumber());
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void setTemporary(boolean isTemporary) {
        this.isTemporary = isTemporary;
    }

    public String getTypesAsString() {
        List<ShopTableType> tableTypes = this.getTypes();
        String strTableTypes = "";
        if (tableTypes == null || tableTypes.size() == 0) {
            return "";
        }
        boolean getComma = false;
        for (ShopTableType shopTableType : tableTypes) {
            if (getComma) {
                strTableTypes = strTableTypes + ", ";
            }
            strTableTypes = strTableTypes + shopTableType.getName();
            getComma = true;
        }
        return strTableTypes;
    }

    public String getTicketId() {
        ShopTableStatus status = this.getStatus();
        if (status == null) {
            return null;
        }
        List<String> ticketNumbers = status.getListOfTicketNumbers();
        if (ticketNumbers != null && ticketNumbers.size() > 0) {
            return ticketNumbers.get(0);
        }
        return null;
    }

    public String getUserId() {
        ShopTableStatus status = this.getStatus();
        if (status == null) {
            return null;
        }
        return status.getUserId();
    }

    public String getUserName() {
        ShopTableStatus status = this.getStatus();
        if (status == null) {
            return null;
        }
        return status.getUserName();
    }

    public String getTicketShortId() {
        ShopTableStatus status = this.getStatus();
        if (status == null) {
            return null;
        }
        return status.getTokenNo();
    }

    @Override
    public ShopTableStatus getShopTableStatus() {
        ShopTableStatus shopTableStatus = super.getShopTableStatus();
        if (shopTableStatus != null) {
            return shopTableStatus;
        }
        shopTableStatus = new ShopTableStatus();
        Integer tableId = this.getId();
        shopTableStatus.setId(tableId);
        shopTableStatus.setTableStatus(TableStatus.Available);
        return shopTableStatus;
    }

    @Deprecated
    public ShopTableStatus getStatus() {
        return this.getShopTableStatus();
    }

    public Date getTicketCreateTime() {
        return this.ticketCreateTime;
    }

    public void setTicketCreateTime(Date ticketCreateTime) {
        this.ticketCreateTime = ticketCreateTime;
    }

    public boolean isShowStatus() {
        return this.showStatus;
    }

    public void setShowStatus(boolean showStatus) {
        this.showStatus = showStatus;
    }

    public boolean isReArrange() {
        return this.reArrange;
    }

    public void setReArrange(boolean reArrange) {
        this.reArrange = reArrange;
    }

    public int getGuestNumber() {
        return this.guestNumber;
    }

    public void setGuestNumber(int guestNumber) {
        this.guestNumber = guestNumber;
    }

    @XmlTransient
    public ShopFloor getFloor() {
        if (StringUtils.isNotEmpty((String)this.getFloorId())) {
            return ShopFloorDAO.getInstance().get(this.getFloorId());
        }
        return null;
    }

    public void setFloor(ShopFloor shopFloor) {
        String shopFloorId = null;
        if (shopFloor != null) {
            shopFloorId = shopFloor.getId();
        }
        super.setFloorId(shopFloorId);
    }

    @XmlTransient
    public SalesArea getSalesArea() {
        if (StringUtils.isNotEmpty((String)this.getSalesAreaId())) {
            return SalesAreaDAO.getInstance().get(this.getSalesAreaId());
        }
        return null;
    }

    public void setSalesArea(SalesArea salesArea) {
        String salesAreaId = null;
        if (salesArea != null) {
            salesAreaId = salesArea.getId();
        }
        super.setSalesAreaId(salesAreaId);
    }

    public void setTypesAsString(String typesAsString) {
        this.typesAsString = typesAsString;
    }

    public double getAngle() {
        String angleText = this.getProperty("angle");
        if (StringUtils.isNotEmpty((String)angleText)) {
            try {
                return Double.parseDouble(angleText);
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), e);
            }
        }
        return 0.0;
    }

    public void setAngle(double angle) {
        this.addProperty("angle", String.valueOf(angle));
    }

    public void setImageResource(ImageResource imageResource) {
        this.addProperty("image", imageResource.getId());
    }

    public ImageIcon getImage() {
        if (this.propertiesContainer == null) {
            return null;
        }
        String imageResourceId = this.getProperty("image");
        if (StringUtils.isEmpty((String)imageResourceId)) {
            return null;
        }
        ImageResource imageResource = DataProvider.get().getImageResource(imageResourceId);
        if (imageResource != null) {
            ImageIcon imageIcon = imageResource.getImageIcon();
            return imageIcon;
        }
        return null;
    }

    public void removeImage() {
        this.removeProperty("image");
    }

    @Override
    public Integer getWidth() {
        ImageIcon imageIcon = this.getImage();
        if (imageIcon == null) {
            return super.getWidth();
        }
        return imageIcon.getIconWidth();
    }

    @Override
    public Integer getHeight() {
        ImageIcon imageIcon = this.getImage();
        if (imageIcon == null) {
            return super.getHeight();
        }
        return imageIcon.getIconHeight();
    }

    public String getNameOrNumber() {
        Store store = DataProvider.get().getStore();
        String tableName = this.getName();
        return store.isShowTableNameOnTable() && StringUtils.isNotBlank((String)tableName) ? tableName : this.getTableNumber().toString();
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new JsonObject() : (JsonObject)new Gson().fromJson(super.getProperties(), JsonObject.class);
        }
        return this.propertiesContainer;
    }
}

