/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.base.BaseStockCountItem;
import com.floreantpos.model.dao.MenuItemDAO;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true, value={"menuItem", "stockCount"})
public class StockCountItem
extends BaseStockCountItem {
    private static final long serialVersionUID = 1L;
    private MenuItem menuItem;

    public StockCountItem() {
    }

    public StockCountItem(String id) {
        super(id);
    }

    public StockCountItem(String id, StockCount stockCount) {
        super(id, stockCount);
    }

    @XmlTransient
    public MenuItem getMenuItem() {
        if (this.menuItem == null) {
            String itemId = this.getItemId();
            if (StringUtils.isEmpty((String)itemId)) {
                return null;
            }
            this.menuItem = MenuItemDAO.getInstance().loadInitialized(itemId);
        }
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
    }

    public double getCountVariance() {
        return this.getActualUnit() - this.getUnitOnHand();
    }

    public void setCountVariance(double countVariance) {
    }

    public double getCostVariance() {
        return this.getCountVariance() * this.getCost();
    }

    public void setCostVariance(double costVariance) {
    }
}

