/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.base.BaseTicketDiscount;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.util.NumberUtil;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true, value={"itemCode"})
public class TicketDiscount
extends BaseTicketDiscount
implements ITicketItem {
    private static final long serialVersionUID = 1L;
    public static String PROP_LOYALTY_POINT = "loyaltyPoint";
    public static String PROP_LOYALTY_CHARGED = "loyaltyCharged";
    private Integer loyaltyPoint;
    private Boolean loyaltyCharged;
    private String ticketId;

    public TicketDiscount() {
    }

    public TicketDiscount(String id) {
        super(id);
    }

    public TicketDiscount(String id, String name, double quantity, double value, int type, Ticket ticket) {
        this.setId(id);
        this.setDiscountId(id);
        this.setName(name);
        this.setCouponQuantity(quantity);
        this.setValue(value);
        this.setType(type);
        this.setTicket(ticket);
        this.setTicketId(ticket.getId());
    }

    @Override
    public Double getCouponQuantity() {
        Double couponQuantity = super.getCouponQuantity();
        if (couponQuantity == 0.0) {
            return 1.0;
        }
        return couponQuantity;
    }

    @Override
    public String getNameDisplay() {
        double couponQuantity = this.getCouponQuantity();
        String display = couponQuantity > 1.0 ? NumberUtil.trimDecilamIfNotNeeded(couponQuantity) + "x " + this.getName() : this.getName().trim();
        return display;
    }

    @Override
    public String getItemCode() {
        return null;
    }

    @Override
    public boolean canAddCookingInstruction() {
        return false;
    }

    @Override
    public boolean canAddDiscount() {
        return false;
    }

    @Override
    public boolean canVoid() {
        return false;
    }

    @Override
    public boolean canAddAdOn() {
        return false;
    }

    @Override
    public Boolean isPrintedToKitchen() {
        return false;
    }

    @Override
    public String getUnitPriceDisplay() {
        return null;
    }

    @Override
    public String getItemQuantityDisplay() {
        return null;
    }

    @Override
    public String getTaxAmountWithoutModifiersDisplay() {
        return null;
    }

    @Override
    public Double getSubtotalAmount() {
        return -this.getTotalDiscountAmount().doubleValue();
    }

    @Override
    public String getSubTotalAmountDisplay() {
        return String.valueOf(-this.getTotalDiscountAmount().doubleValue());
    }

    @Override
    public void setDiscountAmount(Double amount) {
    }

    @Override
    public Double getDiscountAmount() {
        return null;
    }

    @Override
    public KitchenStatus getKitchenStatusValue() {
        return null;
    }

    @Override
    public boolean isSaved() {
        return this.getId() != null;
    }

    public boolean isLoyaltyCharged() {
        if (this.getType() != 3) {
            return true;
        }
        return this.loyaltyCharged != null && this.loyaltyCharged != false;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(PROP_ID, (Object)this.getId());
        jsonObject.put(PROP_LOYALTY_POINT, (Object)this.getLoyaltyPoint());
        jsonObject.put(PROP_LOYALTY_CHARGED, (Object)this.getLoyaltyCharged());
        jsonObject.put(PROP_DISCOUNT_ID, (Object)this.getDiscountId());
        jsonObject.put(PROP_NAME, (Object)this.getName());
        jsonObject.put(PROP_TYPE, (Object)this.getType());
        jsonObject.put(PROP_AUTO_APPLY, (Object)this.isAutoApply());
        jsonObject.put(PROP_COUPON_QUANTITY, (Object)this.getCouponQuantity());
        jsonObject.put(PROP_MINIMUM_AMOUNT, (Object)this.getMinimumAmount());
        jsonObject.put(PROP_VALUE, (Object)this.getValue());
        jsonObject.put(PROP_TOTAL_DISCOUNT_AMOUNT, (Object)this.getTotalDiscountAmount());
        return jsonObject;
    }

    public Integer getLoyaltyPoint() {
        return this.loyaltyPoint;
    }

    public void setLoyaltyPoint(Integer loyaltyPoint) {
        this.loyaltyPoint = loyaltyPoint;
    }

    public Boolean getLoyaltyCharged() {
        return this.loyaltyCharged;
    }

    public void setLoyaltyCharged(Boolean loyaltyCharged) {
        this.loyaltyCharged = loyaltyCharged;
    }

    public String getTicketId() {
        return this.ticketId;
    }

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }
}

