/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.PosLog;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class WorkingHours {
    public static final String SUNDAY = "Sunday";
    public static final String MONDAY = "Monday";
    public static final String TUESDAY = "Tuesday";
    public static final String WEDNESDAY = "Wednesday";
    public static final String THURSDAY = "Thursday";
    public static final String FRIDAY = "Friday";
    public static final String SATURDAY = "Saturday";
    public static String[] days = new String[]{"", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    public static final String OPEN = ".Open";
    public static final String START_TIME = ".StartTime";
    public static final String END_TIME = ".EndTime";
    private Calendar day = Calendar.getInstance();
    private Calendar openHour;
    private Calendar endHour;

    public WorkingHours(int dayOfWeek, String openTime, String endTime) {
        this.day.clear();
        this.day.set(7, dayOfWeek);
        this.openHour = this.parseStringToCalendar(openTime);
        this.endHour = this.parseStringToCalendar(endTime);
    }

    public Calendar getDay() {
        return this.day;
    }

    public void setDay(Calendar day) {
        this.day = day;
    }

    public Calendar getOpenHour() {
        return this.openHour;
    }

    public void setOpenHour(Calendar openHour) {
        this.openHour = openHour;
    }

    public Calendar getEndHour() {
        return this.endHour;
    }

    public void setEndHour(Calendar endHour) {
        this.endHour = endHour;
    }

    private Calendar parseStringToCalendar(String timeString) {
        if (StringUtils.isEmpty((String)timeString)) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        try {
            c.clear();
            SimpleDateFormat format = new SimpleDateFormat("hh:mm a");
            Date parseTime = format.parse(timeString);
            c.setTime(parseTime);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
        return c;
    }
}

