/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.BaseAttributeDAO;
import com.floreantpos.model.dao.GenericDAO;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class AttributeDAO
extends BaseAttributeDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    protected void delete(Object obj, Session session) {
        Attribute attribute = (Attribute)obj;
        if (attribute == null) {
            throw new PosException(Messages.getString("AttributeDAO.0"));
        }
        this.checkForeignRelation(attribute);
        attribute.setDeleted(true);
        attribute.setGroup(null);
        this.update(attribute, session);
    }

    public void checkForeignRelation(Attribute bean) throws PosException {
        String id = bean.getId();
        StringBuilder ref = new StringBuilder();
        StringBuilder details = new StringBuilder();
        try (Session session = this.createNewSession();){
            GenericDAO dao = GenericDAO.getInstance();
            this.append(dao.getForeignDataListNames(session, MenuItem.class, "attributes", Attribute.PROP_ID, id), Messages.getString("AttributeDAO.1"), ref, details);
        }
        String foreignItemDetails = details.toString();
        if (StringUtils.isNotBlank((CharSequence)foreignItemDetails)) {
            throw new PosException(Messages.getString("AttributeDAO.2") + ref.toString() + Messages.getString("AttributeDAO.3") + ref.toString() + ".", foreignItemDetails);
        }
    }

    private void append(List<String> foreignDataListNames, String ref, StringBuilder refDetails, StringBuilder details) {
        if (foreignDataListNames == null || foreignDataListNames.isEmpty()) {
            return;
        }
        details.append(Messages.getString("AttributeDAO.4") + ref + ":");
        refDetails.append(ref);
        int count = 1;
        for (String itemName : foreignDataListNames) {
            details.append("\n" + count + ". " + itemName);
            ++count;
        }
        details.append("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attribute> findAll() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.createAlias(Attribute.PROP_GROUP, "g");
            criteria.addOrder(Order.asc((String)"g.name"));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(Attribute attribute, String code) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Attribute.PROP_NAME, (Object)code).ignoreCase());
            if (attribute.getId() != null) {
                criteria.add((Criterion)Restrictions.ne((String)Attribute.PROP_ID, (Object)attribute.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = rowCount.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateAttributeList(List<Attribute> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Attribute item : dataList) {
                Attribute existingItem = this.get(item.getId());
                if (existingItem != null) {
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

