/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.model.dao.BaseAttributeGroupDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

public class AttributeGroupDAO
extends BaseAttributeGroupDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    protected void delete(Object obj, Session session) {
        AttributeGroup attributeGroup = (AttributeGroup)obj;
        if (attributeGroup == null) {
            throw new PosException(Messages.getString("AttributeGroupDAO.0"));
        }
        attributeGroup.setDeleted(true);
        this.updateAttributeList(attributeGroup);
        this.update(attributeGroup, session);
    }

    private void updateAttributeList(AttributeGroup attributeGroup) {
        List<Attribute> attributes = attributeGroup.getAttributes();
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                attribute.setGroup(null);
                attribute.setDeleted(true);
                AttributeDAO.getInstance().checkForeignRelation(attribute);
            }
        }
    }

    @Override
    public List<AttributeGroup> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)AttributeGroup.PROP_NAME));
            this.addDeletedFilter(criteria);
            List<AttributeGroup> list = this.cleanupDeletedAttribute(criteria.list());
            return list;
        }
    }

    private List<AttributeGroup> cleanupDeletedAttribute(List<AttributeGroup> attributeGroups) {
        if (attributeGroups != null) {
            attributeGroups.forEach(group -> {
                List<Attribute> attributes = group.getAttributes();
                if (attributes != null) {
                    Iterator<Attribute> iterator = attributes.iterator();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        if (!attribute.isDeleted().booleanValue()) continue;
                        iterator.remove();
                    }
                }
            });
        }
        return attributeGroups;
    }

    public void saveOrUpdateAttributeGroupList(List<AttributeGroup> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (AttributeGroup item : dataList) {
                AttributeGroup existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

