/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.dao.BaseBookingInfoDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import liquibase.util.StringUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class BookingInfoDAO
extends BaseBookingInfoDAO {
    @Override
    protected void delete(Object obj, Session s) {
        if (obj instanceof BookingInfo) {
            BookingInfo bookingInfo = (BookingInfo)obj;
            bookingInfo.setDeleted(Boolean.TRUE);
            super.update(bookingInfo, s);
        } else {
            super.delete(obj, s);
        }
    }

    @Override
    public List<BookingInfo> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void saveOrUpdate(Object obj) {
        BookingInfo bookingInfo = (BookingInfo)obj;
        bookingInfo.setLastUpdateTime(new Date());
        super.saveOrUpdate(obj);
    }

    @Override
    protected Serializable save(Object obj) {
        BookingInfo bookingInfo = (BookingInfo)obj;
        bookingInfo.setLastUpdateTime(new Date());
        Serializable save = super.save(obj);
        return save;
    }

    @Override
    public void update(BookingInfo bookingInfo) throws HibernateException {
        bookingInfo.setLastUpdateTime(new Date());
        super.update(bookingInfo);
    }

    @Override
    public void saveOrUpdate(BookingInfo bookingInfo, Session s) throws HibernateException {
        bookingInfo.setLastUpdateTime(new Date());
        this.updateTime(bookingInfo);
        super.saveOrUpdate(bookingInfo, s);
    }

    @Override
    public void update(BookingInfo bookingInfo, Session s) throws HibernateException {
        bookingInfo.setLastUpdateTime(new Date());
        this.updateTime(bookingInfo);
        super.update(bookingInfo, s);
    }

    @Override
    protected Serializable save(Object obj, Session s) {
        BookingInfo bookingInfo = (BookingInfo)obj;
        bookingInfo.setLastUpdateTime(new Date());
        this.updateTime(bookingInfo);
        Serializable save = super.save(obj, s);
        return save;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BookingInfo> getBookedTables(Date startDate, Date endDate) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)startDate), (Criterion)Restrictions.le((String)BookingInfo.PROP_TO_DATE, (Object)endDate)));
            List list = criteria.list();
            return list;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BookingInfo> getAllOpenBooking() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.ne((String)BookingInfo.PROP_STATUS, (Object)"close"));
            List list = criteria.list();
            return list;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    public void setUrgentBookingInfoInTables(Set<ShopTable> tables, Session session) {
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)BookingInfo.PROP_CLOSED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)"open"));
            Calendar cal = Calendar.getInstance();
            Date start = cal.getTime();
            cal.add(12, 30);
            Date end = cal.getTime();
            criteria.add(Restrictions.between((String)BookingInfo.PROP_FROM_DATE, (Object)start, (Object)end));
            ArrayList<Integer> tableIds = new ArrayList<Integer>();
            for (ShopTable shopTable : tables) {
                tableIds.add(shopTable.getId());
            }
            criteria.createAlias("tables", "tableIds");
            criteria.add(Restrictions.in((String)("tableIds." + ShopTable.PROP_ID), tableIds));
            List list = criteria.list();
            ArrayList<ShopTable> updatedTableList = new ArrayList<ShopTable>();
            ArrayList updatedBookingInfoList = new ArrayList();
            if (!list.isEmpty()) {
                for (BookingInfo bookingInfo : list) {
                    List<ShopTable> bookedTables = bookingInfo.getTables();
                    Collection commonTables = CollectionUtils.intersection(tables, bookedTables);
                    for (ShopTable shopTable : commonTables) {
                        TableStatus tableStatus = shopTable.getShopTableStatus().getTableStatus();
                        if (!tableStatus.equals((Object)TableStatus.Available)) continue;
                        shopTable.setCurrentBookingId(bookingInfo.getId());
                        shopTable.addProperty("RES_NO", bookingInfo.getBookingId());
                        shopTable.setTableStatus(TableStatus.Booked);
                        if (bookingInfo.getCustomer() != null) {
                            shopTable.setCustomerName(bookingInfo.getCustomer().getName());
                        }
                        updatedTableList.add(shopTable);
                    }
                }
            }
            if (!updatedTableList.isEmpty()) {
                ShopTableDAO.getInstance().updateTableList(updatedTableList, session);
            }
            if (!updatedBookingInfoList.isEmpty()) {
                for (BookingInfo bookingInfo : updatedBookingInfoList) {
                    this.update(bookingInfo, session);
                }
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            PosLog.error(this.getClass(), e);
        }
    }

    public void setBookingStatus(BookingInfo bookingInfo, String bookingStatus, List<ShopTableStatus> tableStatusList) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            bookingInfo.setStatus(bookingStatus);
            this.saveOrUpdate(bookingInfo);
            if (bookingStatus.equals("seat") || bookingStatus.equals("delay")) {
                ShopTableDAO.getInstance().bookedTables(tableStatusList);
            }
            if (bookingStatus.equals("cancel") || bookingStatus.equals("no appear") || bookingStatus.equals("close")) {
                ShopTableDAO.getInstance().freeTables(tableStatusList);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(BookingInfo.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BookingInfo> getTodaysBooking() {
        return this.getTodaysBooking(null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BookingInfo> getTodaysBooking(String bookingStatus, String searchTxt) {
        try (Session session = this.createNewSession();){
            Calendar startDate = Calendar.getInstance();
            startDate.setLenient(false);
            startDate.setTime(new Date());
            startDate.set(11, 0);
            startDate.set(12, 0);
            startDate.set(13, 0);
            startDate.set(14, 0);
            Calendar endDate = Calendar.getInstance();
            endDate.setLenient(false);
            endDate.setTime(new Date());
            endDate.set(11, 23);
            endDate.set(12, 59);
            endDate.set(13, 59);
            Criteria criteria = null;
            List customerIds = null;
            if (StringUtils.isNotEmpty((String)searchTxt)) {
                criteria = session.createCriteria(Customer.class);
                this.addDeletedFilter(criteria);
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)Customer.PROP_NAME, (String)searchTxt, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (String)searchTxt, (MatchMode)MatchMode.START)));
                criteria.setProjection((Projection)Projections.property((String)Customer.PROP_ID));
                customerIds = criteria.list();
            }
            criteria = session.createCriteria(BookingInfo.class);
            this.addDeletedFilter(criteria);
            if (bookingStatus == null) {
                criteria.add((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)startDate.getTime())).add((Criterion)Restrictions.le((String)BookingInfo.PROP_FROM_DATE, (Object)endDate.getTime()));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)startDate.getTime())).add((Criterion)Restrictions.le((String)BookingInfo.PROP_FROM_DATE, (Object)endDate.getTime())).add((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)bookingStatus));
            }
            if (customerIds != null && !customerIds.isEmpty()) {
                criteria.add(Restrictions.in((String)BookingInfo.PROP_CUSTOMER_ID, (Collection)customerIds));
            }
            List list = criteria.list();
            return list;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ShopTable> getAllBookedTablesByDate(Date startDate, Date endDate) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(BookingInfo.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.gt((String)BookingInfo.PROP_TO_DATE, (Object)startDate), (Criterion)Restrictions.lt((String)BookingInfo.PROP_FROM_DATE, (Object)endDate))).add((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)"open"));
            List list = criteria.list();
            ArrayList<ShopTable> bookedTableList = new ArrayList<ShopTable>();
            for (BookingInfo bookingInfo : list) {
                for (ShopTable shopTable : bookingInfo.getTables()) {
                    bookedTableList.add(shopTable);
                }
            }
            ArrayList<ShopTable> arrayList = bookedTableList;
            return arrayList;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    public List<BookingInfo> getAllBookingInfoByDate(Date startDate, Date endDate) {
        return this.getAllBookingInfoByDate(startDate, endDate, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BookingInfo> getAllBookingInfoByDate(Date startDate, Date endDate, String status, String searchTxt) {
        try (Session session = this.createNewSession();){
            Criteria criteria = null;
            List customerIds = null;
            if (StringUtils.isNotEmpty((String)searchTxt)) {
                criteria = session.createCriteria(Customer.class);
                this.addDeletedFilter(criteria);
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)Customer.PROP_NAME, (String)searchTxt, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (String)searchTxt, (MatchMode)MatchMode.START)));
                criteria.setProjection((Projection)Projections.property((String)Customer.PROP_ID));
                customerIds = criteria.list();
            }
            criteria = session.createCriteria(BookingInfo.class);
            this.addDeletedFilter(criteria);
            if (status == null) {
                criteria.add((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)startDate)).add((Criterion)Restrictions.lt((String)BookingInfo.PROP_FROM_DATE, (Object)endDate));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)BookingInfo.PROP_FROM_DATE, (Object)startDate)).add((Criterion)Restrictions.lt((String)BookingInfo.PROP_FROM_DATE, (Object)endDate)).add((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)status));
            }
            if (customerIds != null && !customerIds.isEmpty()) {
                criteria.add(Restrictions.in((String)BookingInfo.PROP_CUSTOMER_ID, (Collection)customerIds));
            }
            List list = criteria.list();
            return list;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BookingInfo findById(String currentBookingId) {
        if (StringUtils.isEmpty((String)currentBookingId)) {
            return null;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(BookingInfo.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)BookingInfo.PROP_ID, (Object)currentBookingId));
            BookingInfo bookingInfo = (BookingInfo)criteria.uniqueResult();
            return bookingInfo;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    public List<BookingInfo> findByShopTable(ShopTable table, Session session) {
        try {
            Criteria criteria = session.createCriteria(BookingInfo.class);
            this.addDeletedFilter(criteria);
            criteria.createAlias("tables", "tables");
            criteria.add((Criterion)Restrictions.eq((String)("tables." + ShopTable.PROP_ID), (Object)table.getId()));
            return criteria.list();
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    public void saveOrUpdateBookingInfos(List<BookingInfo> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (BookingInfo item : dataList) {
                BookingInfo existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getId() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

