/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Course;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.BaseCourseDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

public class CourseDAO
extends BaseCourseDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    protected void delete(Object obj, Session session) {
        Course bean = (Course)obj;
        if (bean == null) {
            throw new PosException(Messages.getString("CourseDAO.0"));
        }
        this.checkForeignRelation(bean);
        bean.setDeleted(Boolean.TRUE);
        this.update(bean, session);
    }

    private void checkForeignRelation(Course bean) throws PosException {
        try (Session session = this.createNewSession();){
            List<String> foreignItemNames = GenericDAO.getInstance().getForeignDataListNames(session, MenuItem.class, MenuItem.PROP_COURSE_ID, bean.getId());
            if (foreignItemNames != null && foreignItemNames.size() > 0) {
                String details = Messages.getString("CourseDAO.1") + (foreignItemNames.size() > 1 ? Messages.getString("CourseDAO.2") : ":");
                int count = 1;
                for (String itemName : foreignItemNames) {
                    details = details + "\n" + count + ". " + itemName;
                    ++count;
                }
                throw new PosException(Messages.getString("CourseDAO.6"), details);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Course> findAll() {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)Course.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateCourseList(List<Course> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Course item : dataList) {
                Course existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

