/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.dao.BaseCustomerGroupDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

public class CustomerGroupDAO
extends BaseCustomerGroupDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    protected void delete(Object obj, Session session) {
        CustomerGroup customerGroup = (CustomerGroup)obj;
        if (customerGroup == null) {
            throw new PosException(Messages.getString("CustomerGroupDAO.0"));
        }
        List<Customer> customers = CustomerDAO.getInstance().getCustomerByCustomerGroup(customerGroup, session);
        if (customers != null && !customers.isEmpty()) {
            String message = customerGroup.getName() + Messages.getString("CustomerGroupDAO.1");
            String details = this.constructExceptionDetailsByCustomer(customerGroup, customers);
            throw new PosException(message, details);
        }
        customerGroup.setDeleted(true);
        this.update(customerGroup, session);
    }

    @Override
    public List<CustomerGroup> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)CustomerGroup.PROP_NAME));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    private String constructExceptionDetailsByCustomer(CustomerGroup customerGroup, List<Customer> customers) {
        if (customers != null && !customers.isEmpty()) {
            StringBuilder builder = new StringBuilder(customerGroup.getName() + " " + Messages.getString("CustomerGroupDAO.3"));
            for (int i = 0; i < customers.size(); ++i) {
                String message = i + 1 + ". " + customers.get(i).getName();
                builder.append("\n").append(message);
            }
            return builder.toString();
        }
        return "";
    }

    public void initialize(CustomerGroup customerGroup) {
        if (customerGroup == null || customerGroup.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(customerGroup.getCustomers())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)customerGroup);
            Hibernate.initialize(customerGroup.getCustomers());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateCustomerGroupList(List<CustomerGroup> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (CustomerGroup item : dataList) {
                CustomerGroup existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

