/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Discount;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.BaseDiscountDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.Transformers;

public class DiscountDAO
extends BaseDiscountDAO {
    private static final String EMPTY_NEWLINE_STRING = "\n";

    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    public void initialize(Discount discount) {
        if (discount == null || discount.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(discount.getMenuItems()) && Hibernate.isInitialized(discount.getMenuGroups()) && Hibernate.isInitialized(discount.getMenuCategories()) && Hibernate.isInitialized(discount.getOrderTypes())) {
            return;
        }
        try (Session session = this.createNewSession();){
            session.refresh((Object)discount);
            Hibernate.initialize(discount.getMenuItems());
            Hibernate.initialize(discount.getMenuGroups());
            Hibernate.initialize(discount.getMenuCategories());
            Hibernate.initialize(discount.getOrderTypes());
        }
    }

    private List<MenuItem> getMenuItemByDiscount(Discount discount, Session session) {
        Criteria criteriaMenuItem = session.createCriteria(this.getReferenceClass());
        criteriaMenuItem.createAlias("menuItems", "menuItem");
        criteriaMenuItem.add((Criterion)Restrictions.eq((String)Discount.PROP_ID, (Object)discount.getId()));
        criteriaMenuItem.setProjection(Projections.alias((Projection)Projections.property((String)("menuItem." + MenuItem.PROP_NAME)), (String)MenuItem.PROP_NAME));
        return criteriaMenuItem.setResultTransformer(Transformers.aliasToBean(MenuItem.class)).list();
    }

    private List<MenuGroup> getMenuGroupByDiscount(Discount discount, Session session) {
        Criteria criteriarMenuGroup = session.createCriteria(this.getReferenceClass());
        criteriarMenuGroup.createAlias("menuGroups", "menuGroup");
        criteriarMenuGroup.add((Criterion)Restrictions.eq((String)Discount.PROP_ID, (Object)discount.getId()));
        criteriarMenuGroup.setProjection(Projections.alias((Projection)Projections.property((String)("menuGroup." + MenuGroup.PROP_NAME)), (String)MenuGroup.PROP_NAME));
        return criteriarMenuGroup.setResultTransformer(Transformers.aliasToBean(MenuGroup.class)).list();
    }

    private List<MenuCategory> getMenuCategoryByDiscount(Discount discount, Session session) {
        Criteria criteriarMenuCategory = session.createCriteria(this.getReferenceClass());
        criteriarMenuCategory.createAlias("menuCategories", "menuCategory");
        criteriarMenuCategory.add((Criterion)Restrictions.eq((String)Discount.PROP_ID, (Object)discount.getId()));
        criteriarMenuCategory.setProjection(Projections.alias((Projection)Projections.property((String)("menuCategory." + MenuCategory.PROP_NAME)), (String)MenuCategory.PROP_NAME));
        return criteriarMenuCategory.setResultTransformer(Transformers.aliasToBean(MenuCategory.class)).list();
    }

    @Override
    protected void delete(Object obj, Session session) {
        if (obj instanceof Discount) {
            List<MenuCategory> menuCategories;
            List<MenuGroup> menuGroups;
            Discount discount = (Discount)obj;
            StringBuilder details = new StringBuilder();
            List<MenuItem> menuItems = this.getMenuItemByDiscount(discount, session);
            if (menuItems != null && !menuItems.isEmpty()) {
                details.append(this.constructExceptionDetailsByMenuitem(discount, menuItems));
                details.append(EMPTY_NEWLINE_STRING);
            }
            if ((menuGroups = this.getMenuGroupByDiscount(discount, session)) != null && !menuGroups.isEmpty()) {
                details.append(this.constructExceptionDetailsByMenuGroup(discount, menuGroups));
                details.append(EMPTY_NEWLINE_STRING);
            }
            if ((menuCategories = this.getMenuCategoryByDiscount(discount, session)) != null && !menuCategories.isEmpty()) {
                details.append(this.constructExceptionDetailsByMenuCategory(discount, menuCategories));
                details.append(EMPTY_NEWLINE_STRING);
            }
            String message = Messages.getString("DiscountDAO.0");
            String detailsMessage = details.toString();
            if (StringUtils.isNotBlank((CharSequence)detailsMessage)) {
                throw new PosException(message, detailsMessage);
            }
            discount.setDeleted(Boolean.TRUE);
            super.update(discount, session);
        } else {
            super.delete(obj, session);
        }
    }

    private String constructExceptionDetailsByMenuitem(Discount discount, List<MenuItem> menuItems) {
        if (menuItems != null && !menuItems.isEmpty()) {
            StringBuilder builder = new StringBuilder(discount.getName() + " " + Messages.getString("DiscountDAO.3"));
            for (int i = 0; i < menuItems.size(); ++i) {
                String message = i + 1 + ". " + menuItems.get(i).getName();
                builder.append(EMPTY_NEWLINE_STRING).append(message);
            }
            return builder.toString();
        }
        return "";
    }

    private String constructExceptionDetailsByMenuCategory(Discount discount, List<MenuCategory> menuCategories) {
        if (menuCategories != null && !menuCategories.isEmpty()) {
            StringBuilder builder = new StringBuilder(discount.getName() + " " + Messages.getString("DiscountDAO.4"));
            for (int i = 0; i < menuCategories.size(); ++i) {
                String message = i + 1 + ". " + menuCategories.get(i).getName();
                builder.append(EMPTY_NEWLINE_STRING).append(message);
            }
            return builder.toString();
        }
        return "";
    }

    private String constructExceptionDetailsByMenuGroup(Discount discount, List<MenuGroup> menuGroups) {
        if (menuGroups != null && !menuGroups.isEmpty()) {
            StringBuilder builder = new StringBuilder(discount.getName() + " " + Messages.getString("DiscountDAO.5"));
            for (int i = 0; i < menuGroups.size(); ++i) {
                String message = i + 1 + ". " + menuGroups.get(i).getName();
                builder.append(EMPTY_NEWLINE_STRING).append(message);
            }
            return builder.toString();
        }
        return "";
    }

    @Override
    public List<Discount> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)Discount.PROP_NAME));
            List list = criteria.list();
            return list;
        }
    }

    public Discount getInitialized(String discountId) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ID, (Object)discountId));
            Discount discount = (Discount)criteria.uniqueResult();
            Hibernate.initialize(discount.getMenuItems());
            Hibernate.initialize(discount.getMenuGroups());
            Hibernate.initialize(discount.getMenuCategories());
            Discount discount2 = discount;
            return discount2;
        }
    }

    public List<Discount> findAllValidCoupons() {
        Date currentDate = new Date();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)currentDate)));
            List list = criteria.list();
            return list;
        }
    }

    public List<Discount> getValidItemCoupons(OrderType orderType) {
        Date currentDate = new Date();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(Discount.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)0), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)currentDate)));
            criteria.createAlias("orderTypes", "orderType", JoinType.LEFT_OUTER_JOIN);
            Disjunction disjunction = Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.isEmpty((String)"orderTypes"), Restrictions.in((String)"orderType.id", Arrays.asList(orderType.getId()))});
            criteria.add((Criterion)disjunction);
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List list = criteria.list();
            return list;
        }
    }

    public List<Discount> getValidCoupon(MenuItem menuItem) {
        Date currentDate = new Date();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.createAlias("menuItems", "item");
            criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)menuItem.getId()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)0), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)currentDate)));
            List list = criteria.list();
            return list;
        }
    }

    public List<Discount> getTicketValidCoupon() {
        Date currentDate = new Date();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)1), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)currentDate)));
            List list = criteria.list();
            return list;
        }
    }

    public boolean isApplicable(String itemId, String discountId) {
        Date currentDate = new Date();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            criteria.createAlias("menuItems", "item");
            criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)itemId));
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ID, (Object)discountId));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)currentDate)));
            Number rowCount = (Number)criteria.uniqueResult();
            boolean bl = rowCount != null && rowCount.intValue() > 0;
            return bl;
        }
    }

    public Discount getDiscountByBarcode(String barcode, int couponType) {
        Date currentDate = new Date();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(Discount.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.like((String)Discount.PROP_BARCODE, (Object)barcode));
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)(couponType == 0 ? 0 : 1)), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)currentDate)));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                Discount discount = null;
                return discount;
            }
            Discount discount = (Discount)result.get(0);
            return discount;
        }
    }

    public List<Discount> getDiscountsByMenuCategory(MenuCategory category, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias("menuCategories", "menuCategory");
        criteria.add((Criterion)Restrictions.eq((String)("menuCategory." + MenuCategory.PROP_ID), (Object)category.getId()));
        return criteria.list();
    }

    public List<Discount> getDiscountsByMenuGroup(MenuGroup menuGroup, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias("menuGroups", "menugroup");
        criteria.add((Criterion)Restrictions.eq((String)("menugroup." + MenuGroup.PROP_ID), (Object)menuGroup.getId()));
        return criteria.list();
    }

    public List<Discount> getDiscountsByMenuItem(MenuItem menuItem, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias("menuItems", "menuItem");
        criteria.add((Criterion)Restrictions.eq((String)("menuItem." + MenuItem.PROP_ID), (Object)menuItem.getId()));
        return criteria.list();
    }

    public String getCurrentDayPropertyName(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        String propertyName = "";
        int dayOfWeek = c.get(7);
        switch (dayOfWeek) {
            case 7: {
                propertyName = Discount.PROP_APPLY_TO_SATURDAY_ONLY;
                break;
            }
            case 1: {
                propertyName = Discount.PROP_APPLY_TO_SUNDAY_ONLY;
                break;
            }
            case 2: {
                propertyName = Discount.PROP_APPLY_TO_MONDAY_ONLY;
                break;
            }
            case 3: {
                propertyName = Discount.PROP_APPLY_TO_TUESDAY_ONLY;
                break;
            }
            case 4: {
                propertyName = Discount.PROP_APPLY_TO_WEDNESDAY_ONLY;
                break;
            }
            case 5: {
                propertyName = Discount.PROP_APPLY_TO_THURSDAY_ONLY;
                break;
            }
            case 6: {
                propertyName = Discount.PROP_APPLY_TO_FRIDAY_ONLY;
                break;
            }
        }
        return propertyName;
    }

    public List<Discount> getValidCoupons() {
        Date currentDate = new Date();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)currentDate)));
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdateDiscountList(List<Discount> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        HashMap<String, MenuItem> itemMap = new HashMap<String, MenuItem>();
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Discount item : dataList) {
                Discount existingItem;
                List<MenuItem> menuItems = item.getMenuItems();
                item.setMenuItems(null);
                if (menuItems != null && menuItems.size() > 0) {
                    for (MenuItem menuItem : menuItems) {
                        MenuItem existingMenuItem = (MenuItem)itemMap.get(menuItem.getId());
                        if (existingMenuItem == null) {
                            existingMenuItem = MenuItemDAO.getInstance().get(menuItem.getId());
                            if (existingMenuItem == null) {
                                throw new Exception("No item found with id " + menuItem.getId());
                            }
                            itemMap.put(existingMenuItem.getId(), existingMenuItem);
                        }
                        item.addTomenuItems(existingMenuItem);
                    }
                }
                if ((existingItem = this.get(item.getId())) != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

