/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuItemDAO;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

public class ForeteesMenuItemDAO
extends MenuItemDAO {
    private static ForeteesMenuItemDAO instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findMenuItemByTypeAndSubType(String type, String subType) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_CMS_TYPE_NAME, (Object)type));
            if (subType == null) {
                criteria.add(Restrictions.isNull((String)MenuItem.PROP_CMS_SUB_TYPE_NAME));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_CMS_SUB_TYPE_NAME, (Object)subType));
            }
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                List<MenuItem> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSFItems(List<MenuItem> items) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (MenuItem menuItem : items) {
                MenuItem existedItem = this.get(menuItem.getId());
                if (existedItem == null) {
                    session.save((Object)menuItem);
                    continue;
                }
                existedItem.setName(menuItem.getName());
                existedItem.setPrice(menuItem.getPrice());
                existedItem.setRetailPrice(menuItem.getRetailPrice());
                existedItem.setCmsItemCode(menuItem.getCmsItemCode());
                existedItem.setCmsTypeName(menuItem.getCmsTypeName());
                existedItem.setCmsSubTypeName(menuItem.getCmsSubTypeName());
                session.update((Object)existedItem);
            }
            tx.commit();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemByBarcodeOrName(String textValue) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            if (StringUtils.isEmpty((String)textValue)) {
                MenuItem menuItem = null;
                return menuItem;
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)MenuItem.PROP_NAME, (String)textValue.trim(), (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)textValue)));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                MenuItem menuItem = null;
                return menuItem;
            }
            MenuItem menuItem = (MenuItem)result.get(0);
            return menuItem;
        }
        finally {
            this.closeSession(session);
        }
    }

    public static ForeteesMenuItemDAO getInstance() {
        if (instance == null) {
            instance = new ForeteesMenuItemDAO();
        }
        return instance;
    }
}

