/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryDepartment;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.StockCountItem;
import com.floreantpos.model.dao.BaseInventoryLocationDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.PurchaseOrderDAO;
import com.floreantpos.model.dao.StockCountItemDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class InventoryLocationDAO
extends BaseInventoryLocationDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    public void delete(Object obj, Session session) {
        InventoryLocation location = (InventoryLocation)obj;
        if (location == null) {
            throw new PosException(Messages.getString("InventoryLocationDAO.0"));
        }
        this.checkForeignRelation(location, session);
        location.setParentLocation(null);
        location.setDeleted(true);
        this.update(location, session);
    }

    private void checkForeignRelation(InventoryLocation bean, Session session) throws PosException {
        String foreignItemDetails;
        List<PurchaseOrder> purchaseOrders;
        String id = bean.getId();
        StringBuilder ref = new StringBuilder();
        StringBuilder details = new StringBuilder();
        GenericDAO dao = GenericDAO.getInstance();
        List<InventoryLocation> childrenList = bean.getChildren();
        if (childrenList != null && !childrenList.isEmpty()) {
            ref.append(Messages.getString("InventoryLocationDAO.1") + ", ");
            details.append(this.constructExceptionDetailsByInventoryLocations(bean, childrenList));
            details.append("\n \n");
        }
        this.append(dao.getForeignDataList(session, InventoryStock.class, InventoryStock.PROP_LOCATION_ID, id, InventoryStock.PROP_ITEM_NAME), Messages.getString("InventoryLocationDAO.3"), ref, details);
        this.append(dao.getForeignDataListNames(session, InventoryDepartment.class, "locations", InventoryDepartment.PROP_ID, id), Messages.getString("InventoryLocationDAO.4"), ref, details);
        List<StockCountItem> stockCountItems = StockCountItemDAO.getInstance().getStockCountItemByInvLocation(bean, session);
        if (stockCountItems != null && !stockCountItems.isEmpty()) {
            ref.append(Messages.getString("InventoryLocationDAO.5") + ",");
            details.append(this.constructExceptionDetailsByStockCountItems(bean, stockCountItems));
            details.append("\n \n");
        }
        if ((purchaseOrders = PurchaseOrderDAO.getInstance().getPurchaseOrderByInvLocation(bean, session)) != null && !purchaseOrders.isEmpty()) {
            ref.append(Messages.getString("InventoryLocationDAO.6"));
            details.append(this.constructExceptionDetailsByPurchaseOrders(bean, purchaseOrders));
            details.append("\n");
        }
        if (StringUtils.isNotBlank((String)(foreignItemDetails = details.toString()))) {
            String foreignReferences = ref.toString();
            if (foreignReferences.endsWith(", ")) {
                foreignReferences = foreignReferences.substring(0, foreignReferences.length() - 2);
            }
            StringBuilder refHeading = new StringBuilder();
            String messageHeading = refHeading.append(Messages.getString("InventoryLocationDAO.7")).append(foreignReferences).append(". ").append("\n").append(Messages.getString("InventoryLocationDAO.8")).toString();
            throw new PosException(messageHeading, foreignItemDetails);
        }
    }

    private void append(List<String> foreignDataListNames, String ref, StringBuilder refDetails, StringBuilder details) {
        if (foreignDataListNames == null || foreignDataListNames.isEmpty()) {
            return;
        }
        details.append(Messages.getString("InventoryLocationDAO.9") + ref + ":");
        refDetails.append(ref + ", ");
        int count = 1;
        for (String itemName : foreignDataListNames) {
            details.append("\n" + count + ". " + itemName);
            ++count;
        }
        details.append("\n \n");
    }

    private String constructExceptionDetailsByStockCountItems(InventoryLocation inventoryLocation, List<StockCountItem> stockCountItems) {
        if (stockCountItems != null && !stockCountItems.isEmpty()) {
            StringBuilder builder = new StringBuilder(Messages.getString("InventoryLocationDAO.9") + Messages.getString("InventoryLocationDAO.11"));
            for (int i = 0; i < stockCountItems.size(); ++i) {
                String message = i + 1 + ". " + stockCountItems.get(i).getName();
                builder.append("\n ").append(message);
            }
            return builder.toString();
        }
        return "";
    }

    private String constructExceptionDetailsByPurchaseOrders(InventoryLocation inventoryLocation, List<PurchaseOrder> purchaseOrders) {
        if (purchaseOrders != null && !purchaseOrders.isEmpty()) {
            StringBuilder builder = new StringBuilder(Messages.getString("InventoryLocationDAO.9") + Messages.getString("InventoryLocationDAO.13"));
            for (int i = 0; i < purchaseOrders.size(); ++i) {
                String message = i + 1 + ". " + purchaseOrders.get(i).getId();
                builder.append("\n").append(message);
            }
            return builder.toString();
        }
        return "";
    }

    private String constructExceptionDetailsByInventoryLocations(InventoryLocation inventoryLocation, List<InventoryLocation> purchaseOrders) {
        if (purchaseOrders != null && !purchaseOrders.isEmpty()) {
            StringBuilder builder = new StringBuilder(Messages.getString("InventoryLocationDAO.14") + Messages.getString("InventoryLocationDAO.15"));
            for (int i = 0; i < purchaseOrders.size(); ++i) {
                String message = i + 1 + ". " + purchaseOrders.get(i).getName();
                builder.append("\n").append(message);
            }
            return builder.toString();
        }
        return "";
    }

    @Override
    public List<InventoryLocation> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)InventoryLocation.PROP_NAME));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryLocation initialize(InventoryLocation inventoryLocation) {
        if (inventoryLocation == null || inventoryLocation.getId() == null) {
            return inventoryLocation;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)inventoryLocation);
            Hibernate.initialize(InventoryLocation.class);
            InventoryLocation inventoryLocation2 = inventoryLocation;
            return inventoryLocation2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public InventoryLocation getRootLocation() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_ROOT, (Object)true));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                InventoryLocation inventoryLocation = (InventoryLocation)list.get(0);
                return inventoryLocation;
            }
            InventoryLocation inventoryLocation = null;
            return inventoryLocation;
        }
    }

    public List<InventoryLocation> getRootLocations() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_ROOT, (Object)true));
            List list = criteria.list();
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InventoryLocation getDefaultInInventoryLocation() {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(InventoryLocation.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_DEFAULT_IN_LOCATION, (Object)true));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                InventoryLocation inventoryLocation2 = null;
                return inventoryLocation2;
            }
            InventoryLocation inventoryLocation = (InventoryLocation)result.get(0);
            return inventoryLocation;
        }
        catch (Exception e) {
            PosLog.info(this.getClass(), "" + e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InventoryLocation getDefaultOutInventoryLocation() {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(InventoryLocation.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_DEFAULT_OUT_LOCATION, (Object)true));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                InventoryLocation inventoryLocation2 = null;
                return inventoryLocation2;
            }
            InventoryLocation inventoryLocation = (InventoryLocation)result.get(0);
            return inventoryLocation;
        }
        catch (Exception e) {
            PosLog.info(this.getClass(), "" + e);
            return null;
        }
    }

    public InventoryLocation getDefaultOutInventoryLocation(Session session) {
        Criteria criteria = session.createCriteria(InventoryLocation.class);
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_DEFAULT_OUT_LOCATION, (Object)true));
        List result = criteria.list();
        if (result == null || result.isEmpty()) {
            criteria = session.createCriteria(InventoryLocation.class);
            this.addDeletedFilter(criteria);
            criteria.setMaxResults(1);
            return (InventoryLocation)criteria.uniqueResult();
        }
        return (InventoryLocation)result.get(0);
    }

    public InventoryLocation getDefaultInInventoryLocation(Session session) {
        Criteria criteria = session.createCriteria(InventoryLocation.class);
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_DEFAULT_IN_LOCATION, (Object)true));
        List result = criteria.list();
        if (result == null || result.isEmpty()) {
            criteria = session.createCriteria(InventoryLocation.class);
            this.addDeletedFilter(criteria);
            criteria.setMaxResults(1);
            return (InventoryLocation)criteria.uniqueResult();
        }
        return (InventoryLocation)result.get(0);
    }

    public void saveOrUpdateInventoryLocation(List<InventoryLocation> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (InventoryLocation item : dataList) {
                InventoryLocation existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    List<InventoryLocation> existingChildLocations = existingItem.getChildren();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setChildren(existingChildLocations);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }
}

