/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.BaseInventoryStockDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

public class InventoryStockDAO
extends BaseInventoryStockDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryStock initialize(InventoryStock inventoryStock) {
        if (inventoryStock == null || inventoryStock.getId() == null) {
            return inventoryStock;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)inventoryStock);
            InventoryStock inventoryStock2 = inventoryStock;
            return inventoryStock2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<InventoryStock> getInventoryStock(String itemName, Object selectedType) {
        try (Session session = this.createNewSession();){
            DetachedCriteria detachedCriteria = DetachedCriteria.forClass(MenuItem.class);
            detachedCriteria.setProjection((Projection)Projections.property((String)MenuItem.PROP_ID));
            detachedCriteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_DELETED), (Criterion)Restrictions.eq((String)MenuItem.PROP_DELETED, (Object)Boolean.FALSE)));
            detachedCriteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            Criteria criteria = session.createCriteria(InventoryStock.class);
            if (StringUtils.isNotEmpty((String)itemName)) {
                Disjunction or = Restrictions.disjunction();
                or.add(Restrictions.ilike((String)InventoryStock.PROP_ITEM_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
                or.add(Restrictions.ilike((String)InventoryStock.PROP_SKU, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
                or.add(Restrictions.ilike((String)InventoryStock.PROP_BARCODE, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
                criteria.add((Criterion)or);
            }
            if (selectedType instanceof InventoryLocation) {
                InventoryLocation location = (InventoryLocation)selectedType;
                criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)location.getId()));
            }
            criteria.add(Property.forName((String)InventoryStock.PROP_MENU_ITEM_ID).in(detachedCriteria));
            List list = criteria.list();
            return list;
        }
    }

    public void addNewStock(InventoryStock stock, InventoryTransaction transaction, MenuItem menuItem) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)stock);
            session.saveOrUpdate((Object)transaction);
            session.saveOrUpdate((Object)menuItem);
            tx.commit();
        }
    }

    public InventoryStock getInventoryStock(MenuItem menuItem, InventoryLocation location, String unitCode) {
        if (location == null) {
            return this.getInventoryStock(menuItem, (String)null, unitCode);
        }
        return this.getInventoryStock(menuItem, location.getId(), unitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryStock getInventoryStock(MenuItem menuItem, String locationId, String unitCode) {
        Session session = null;
        try {
            session = this.createNewSession();
            InventoryStock inventoryStock = this.getInventoryStock(menuItem, locationId, unitCode, session);
            return inventoryStock;
        }
        catch (Exception e) {
            PosLog.error(InventoryStockDAO.class, e.getMessage(), e);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    public InventoryStock getInventoryStock(MenuItem menuItem, String locationId, String unitCode, Session session) {
        return this.getInventoryStock(menuItem != null ? menuItem.getId() : "", locationId, unitCode, session);
    }

    public InventoryStock getInventoryStock(String menuItemId, String locationId, String unitCode, Session session) {
        List list;
        Criteria criteria = session.createCriteria(InventoryStock.class);
        if (StringUtils.isNotBlank((String)menuItemId)) {
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_MENU_ITEM_ID, (Object)menuItemId));
        }
        if (StringUtils.isNotBlank((String)locationId)) {
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)locationId));
        }
        if (StringUtils.isNotBlank((String)unitCode)) {
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_UNIT, (Object)unitCode));
        }
        if ((list = criteria.list()) != null && list.size() > 0) {
            return (InventoryStock)list.get(0);
        }
        return null;
    }

    public List<InventoryStock> getInventoryStocks(MenuItem menuItem) {
        return this.getInventoryStocks(menuItem, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryStock> getInventoryStocks(MenuItem menuItem, InventoryLocation location) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(InventoryStock.class);
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_MENU_ITEM_ID, (Object)menuItem.getId()));
            if (location != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)location.getId()));
            }
            List list = criteria.list();
            return list;
        }
        catch (Exception exception) {
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    public void addTransfer(InventoryTransaction inTransaction, InventoryTransaction outTransaction, InventoryStock inStock, InventoryStock outStock, MenuItem menuItem) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)inStock);
            session.saveOrUpdate((Object)outStock);
            session.saveOrUpdate((Object)inTransaction);
            session.saveOrUpdate((Object)outTransaction);
            session.saveOrUpdate((Object)menuItem);
            tx.commit();
        }
    }

    public List<InventoryStock> getInventoryOnhandReprotData(String nameOrSku, InventoryLocation location) {
        Session session = null;
        Criteria criteria = null;
        HashMap inventoryLocMap = new HashMap();
        HashMap menuItemMap = new HashMap();
        session = this.getSession();
        criteria = session.createCriteria(InventoryStock.class);
        criteria.addOrder(Order.asc((String)InventoryStock.PROP_ITEM_NAME));
        if (StringUtils.isNotEmpty((String)nameOrSku)) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)InventoryStock.PROP_ITEM_NAME, (String)nameOrSku, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.eq((String)InventoryStock.PROP_SKU, (Object)nameOrSku)));
        }
        if (location != null) {
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)location.getId()));
        }
        List stockList = criteria.list();
        for (InventoryStock inventoryStock : stockList) {
            String menuItemId = inventoryStock.getMenuItemId();
            String locationId = inventoryStock.getLocationId();
            Double cost = (Double)menuItemMap.get(menuItemId);
            String locationName = (String)inventoryLocMap.get(locationId);
            if (cost == null) {
                cost = this.getMenuItemCost(menuItemId, session);
            }
            if (locationName == null) {
                locationName = this.getLocationName(locationId, session);
            }
            inventoryStock.setMenuItemCost(cost);
            inventoryStock.setLocationName(locationName);
        }
        return stockList;
    }

    private String getLocationName(String locationId, Session session) {
        Criteria criteria = session.createCriteria(InventoryLocation.class);
        criteria.add((Criterion)Restrictions.eq((String)InventoryLocation.PROP_ID, (Object)locationId));
        criteria.setProjection((Projection)Projections.property((String)InventoryLocation.PROP_NAME));
        Object result = criteria.uniqueResult();
        if (result instanceof String) {
            return ((String)result).toString();
        }
        return null;
    }

    private Double getMenuItemCost(String menuItemId, Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_ID, (Object)menuItemId));
        criteria.setProjection((Projection)Projections.property((String)MenuItem.PROP_COST));
        Object result = criteria.uniqueResult();
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        return 0.0;
    }

    public List<InventoryStock> findStocksForStockCountMultiItemSelection(MenuGroup group, InventoryVendor vendor, InventoryLocation location) {
        try (Session session = this.createNewSession();){
            if (location == null) {
                List<InventoryStock> list = null;
                return list;
            }
            List commonMenuItemsId = null;
            Criteria criteria = null;
            if (vendor != null) {
                criteria = session.createCriteria(InventoryVendorItems.class);
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)vendor));
                criteria.createAlias(InventoryVendorItems.PROP_ITEM, "item");
                criteria.setProjection((Projection)Projections.property((String)"item.id"));
                commonMenuItemsId = criteria.list();
            }
            criteria = session.createCriteria(MenuItem.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.add(Restrictions.isNotNull((String)MenuItem.PROP_UNIT_ID));
            if (group != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)group.getId()));
            }
            if (commonMenuItemsId != null && !commonMenuItemsId.isEmpty()) {
                criteria.add(Restrictions.in((String)MenuItem.PROP_ID, (Collection)commonMenuItemsId));
            }
            criteria.setProjection((Projection)Projections.property((String)MenuItem.PROP_ID));
            if (commonMenuItemsId == null) {
                commonMenuItemsId = criteria.list();
            } else {
                commonMenuItemsId.retainAll(criteria.list());
            }
            criteria = session.createCriteria(InventoryStock.class);
            criteria.addOrder(Order.asc((String)InventoryStock.PROP_ITEM_NAME));
            criteria.addOrder(Order.asc((String)InventoryStock.PROP_UNIT));
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)location.getId()));
            if (commonMenuItemsId != null && !commonMenuItemsId.isEmpty()) {
                criteria.add(Restrictions.in((String)InventoryStock.PROP_MENU_ITEM_ID, (Collection)commonMenuItemsId));
            }
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdateInventoryStock(List<InventoryStock> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (InventoryStock item : dataList) {
                InventoryStock existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getId() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

