/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.dao.BaseInventoryUnitGroupDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class InventoryUnitGroupDAO
extends BaseInventoryUnitGroupDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    protected void delete(Object obj, Session session) {
        InventoryUnitGroup unitGroup = (InventoryUnitGroup)obj;
        List<InventoryUnit> units = unitGroup.getUnits();
        if (!units.isEmpty() && units != null) {
            throw new PosException(Messages.getString("InventoryUnitGroupDAO.0"));
        }
        super.delete(obj, session);
    }

    @Override
    public List<InventoryUnitGroup> findAll() {
        List<InventoryUnitGroup> inventoryUnitGroups = super.findAll();
        if (inventoryUnitGroups != null) {
            for (InventoryUnitGroup inventoryUnitGroup : inventoryUnitGroups) {
                List<InventoryUnit> allInventoryUnits = inventoryUnitGroup.getUnits();
                if (allInventoryUnits == null) continue;
                Iterator<InventoryUnit> iterator = allInventoryUnits.iterator();
                while (iterator.hasNext()) {
                    InventoryUnit inventoryUnit = iterator.next();
                    if (!inventoryUnit.isDeleted().booleanValue()) continue;
                    iterator.remove();
                }
            }
        }
        return inventoryUnitGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryUnitGroup findByName(String unitGroupName) {
        Session session = null;
        try {
            session = this.createNewSession();
            InventoryUnitGroup inventoryUnitGroup = this.findByName(unitGroupName, session);
            return inventoryUnitGroup;
        }
        finally {
            this.closeSession(session);
        }
    }

    public InventoryUnitGroup findByName(String unitGroupName, Session session) {
        if (session == null) {
            session = this.getSession();
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)InventoryUnitGroup.PROP_NAME, (Object)unitGroupName));
        return (InventoryUnitGroup)criteria.uniqueResult();
    }

    public void saveOrUpdateInventoryUnitGroups(List<InventoryUnitGroup> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            ArrayList<String> uniqueNames = new ArrayList<String>();
            for (InventoryUnitGroup item : dataList) {
                if (uniqueNames.contains(item.getName())) {
                    item.setName(item.getName() + "_");
                }
                uniqueNames.add(item.getName());
                InventoryUnitGroup existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

