/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Printer;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.BaseKitchenTicketDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.webservice.CloudDataUploader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class KitchenTicketDAO
extends BaseKitchenTicketDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastUpdateDate() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)KitchenTicket.PROP_LAST_UPDATE_TIME));
            criteria.setMaxResults(1);
            Date date = (Date)criteria.uniqueResult();
            return date;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(Terminal terminal, List<Printer> selectedKDSPrinters, List<OrderType> orderTypes, boolean kitchenDispatchMode, PaginatedListModel listModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            int i;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_VOIDED, (Object)Boolean.FALSE));
            if (kitchenDispatchMode) {
                criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.BUMP.name()));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.WAITING.name()));
            }
            if (orderTypes != null) {
                ArrayList<String> orderTypesId = new ArrayList<String>();
                for (i = 0; i < orderTypes.size(); ++i) {
                    orderTypesId.add(orderTypes.get(i).getId());
                }
                criteria.add(Restrictions.in((String)KitchenTicket.PROP_ORDER_TYPE_ID, orderTypesId));
            }
            if (selectedKDSPrinters != null) {
                ArrayList<String> printerName = new ArrayList<String>();
                for (i = 0; i < selectedKDSPrinters.size(); ++i) {
                    printerName.add(selectedKDSPrinters.get(i).getVirtualPrinter().getName());
                }
                criteria.add(Restrictions.in((String)KitchenTicket.PROP_PRINTER_NAME, printerName));
            }
            criteria.add(Restrictions.isNotEmpty((String)"ticketItems"));
            listModel.setNumRows(this.rowCount(criteria));
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(listModel.getPageSize());
            criteria.addOrder(Order.desc((String)KitchenTicket.PROP_CREATE_DATE));
            ArrayList list = criteria.list();
            if (list == null) {
                list = new ArrayList();
            }
            listModel.setData(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KitchenTicket> findAllOpen() {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.WAITING.name()));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KitchenTicket> findAllOpen(Date lastUpdateTime) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.WAITING.name()));
            if (lastUpdateTime != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"lastUpdateTime"), (Criterion)Restrictions.gt((String)"lastUpdateTime", (Object)lastUpdateTime)));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void dispatchAll() {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.BUMP.name()));
            List KitchenTicketList = criteria.list();
            if (KitchenTicketList.isEmpty()) {
                tx.rollback();
                throw new PosException("No data to dispatch");
            }
            for (KitchenTicket kitchenTicket : KitchenTicketList) {
                this.delete(kitchenTicket, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KitchenTicket> findByParentId(String ticketId) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_TICKET_ID, (Object)ticketId));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KitchenTicket findByLastOrderParentId(String ticketId) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_TICKET_ID, (Object)ticketId));
            criteria.addOrder(Order.desc((String)KitchenTicket.PROP_CREATE_DATE));
            List list = criteria.list();
            if (list.size() > 0) {
                KitchenTicket kitchenTicket = (KitchenTicket)list.get(0);
                return kitchenTicket;
            }
            KitchenTicket kitchenTicket = null;
            return kitchenTicket;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findNextKitchenTickets(PaginatedTableModel tableModel) {
        List list;
        Session session = null;
        Criteria criteria = null;
        try {
            int nextIndex = tableModel.getNextRowIndex();
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setFirstResult(nextIndex);
            criteria.setMaxResults(tableModel.getPageSize());
            List kitchenTicketList = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                tableModel.setNumRows(rowCount.intValue());
            }
            tableModel.setCurrentRowIndex(nextIndex);
            list = kitchenTicketList;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findPreviousKitchenTickets(PaginatedTableModel tableModel) {
        List list;
        Session session = null;
        Criteria criteria = null;
        try {
            int previousIndex = tableModel.getPreviousRowIndex();
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setFirstResult(previousIndex);
            criteria.setMaxResults(tableModel.getPageSize());
            List kitchenTicketList = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                tableModel.setNumRows(rowCount.intValue());
            }
            tableModel.setCurrentRowIndex(previousIndex);
            list = kitchenTicketList;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(List<KitchenTicket> kitchenTickets) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (KitchenTicket kitchenTicket : kitchenTickets) {
                session.saveOrUpdate((Object)kitchenTicket);
            }
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date isDataUpdated(Date modifiedDate) {
        Session session = null;
        Criteria criteria = null;
        try {
            Object data;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)KitchenTicket.PROP_CREATE_DATE));
            if (modifiedDate != null) {
                criteria.add((Criterion)Restrictions.gt((String)KitchenTicket.PROP_CREATE_DATE, (Object)modifiedDate));
            }
            if ((data = criteria.uniqueResult()) == null) {
                Date date = null;
                return date;
            }
            Date date = (Date)data;
            return date;
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        Date currentTime = StoreDAO.getServerTimestamp();
        KitchenTicket kitchenTicket = (KitchenTicket)obj;
        kitchenTicket.setLastUpdateTime(currentTime);
        s.saveOrUpdate((Object)kitchenTicket);
    }

    public void bumpOrUnbump(KitchenTicket kitchenTicket, KitchenStatus kitchenTicketStatus, KitchenStatus ticketItemStatus, boolean bump) {
        this.bumpOrUnbump(kitchenTicket, null, kitchenTicketStatus, ticketItemStatus, bump);
    }

    public void bumpOrUnbump(KitchenTicket kitchenTicket, Ticket parentTicket, KitchenStatus kitchenTicketStatus, KitchenStatus ticketItemStatus, boolean bump) {
        if (parentTicket == null) {
            parentTicket = TicketDAO.getInstance().loadFullTicket(kitchenTicket.getTicketId());
        }
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            block5: for (KitchenTicketItem kitchenTicketItem : kitchenTicket.getTicketItems()) {
                if (kitchenTicketItem.isVoided().booleanValue()) continue;
                kitchenTicketItem.setStatus(kitchenTicketStatus.name());
                double itemQuantity = kitchenTicketItem.getQuantity();
                if (parentTicket == null) continue;
                for (TicketItem item : parentTicket.getTicketItems()) {
                    if (!StringUtils.isNotEmpty((String)kitchenTicketItem.getTicketItemId()) || !kitchenTicketItem.getTicketItemId().equals(item.getId()) || item.getKitchenStatusValue() == ticketItemStatus) continue;
                    if (itemQuantity == 0.0) continue block5;
                    item.setKitchenStatusValue(ticketItemStatus);
                    itemQuantity -= item.getQuantity().doubleValue();
                }
            }
            kitchenTicket.setStatus(kitchenTicketStatus.name());
            Date currentTime = StoreDAO.getServerTimestamp();
            if (bump) {
                kitchenTicket.setClosingDate(currentTime);
            } else {
                kitchenTicket.setClosingDate(null);
            }
            this.saveOrUpdate(kitchenTicket, session);
            if (parentTicket != null) {
                parentTicket.setStatus(bump ? "Ready" : "Waiting (Kitchen)");
                TicketDAO.getInstance().saveOrUpdate(parentTicket, session);
            }
            tx.commit();
            CloudDataUploader.get().uploadToCloudIfOnlineOrder(parentTicket);
        }
    }
}

