/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.Discount;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.BaseMenuItemDAO;
import com.floreantpos.model.dao.ComboItemDAO;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.model.dao.MenuPageItemDAO;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.util.NumberUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.criterion.Subqueries;
import org.hibernate.transform.Transformers;

public class MenuItemDAO
extends BaseMenuItemDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        Serializable serializable = super.save(obj, s);
        this.updateDependentModels((MenuItem)obj, s);
        return serializable;
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
        this.updateDependentModels((MenuItem)obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
        this.updateDependentModels((MenuItem)obj, s);
    }

    @Override
    public void delete(Object obj, Session session) throws HibernateException {
        List<MenuItem> variants;
        MenuItem menuItem = (MenuItem)obj;
        if (menuItem == null) {
            throw new PosException(Messages.getString("MenuItemDAO.0"));
        }
        session.refresh((Object)menuItem);
        this.checkIfItemCanbeDeleted(session, menuItem);
        if (menuItem.isComboItem().booleanValue()) {
            List<ComboItem> comboItems;
            List<ComboGroup> comboGroups = menuItem.getComboGroups();
            if (comboGroups != null && !comboGroups.isEmpty()) {
                comboGroups.clear();
            }
            if ((comboItems = menuItem.getComboItems()) != null && !comboItems.isEmpty()) {
                for (ComboItem comboItem : comboItems) {
                    comboItem.setDeleted(true);
                    ComboItemDAO.getInstance().update(comboItem, session);
                }
            }
        }
        menuItem.setDeleted(true);
        this.removeFromDependentModels(menuItem, session);
        this.updateTime(menuItem);
        session.update((Object)menuItem);
        if (menuItem.isHasVariant().booleanValue() && (variants = menuItem.getVariants()) != null && !variants.isEmpty()) {
            for (MenuItem variant : variants) {
                this.delete(variant, session);
            }
        }
        this.removeFromDiscounts(menuItem, session);
    }

    private void removeFromDiscounts(MenuItem menuItem, Session session) {
        DiscountDAO discountDAO = DiscountDAO.getInstance();
        List<Discount> discounts = discountDAO.getDiscountsByMenuItem(menuItem, session);
        if (discounts != null && !discounts.isEmpty()) {
            for (Discount discount : discounts) {
                List<MenuItem> menuItems = discount.getMenuItems();
                menuItems.remove(menuItem);
                discountDAO.saveOrUpdate(discount, session);
            }
        }
    }

    private void checkIfItemCanbeDeleted(Session s, MenuItem menuItem) {
        List<MenuItem> menuItems;
        String details = "";
        List<String> foreignItemNames = RecepieDAO.getInstance().getForeignDataListNames(menuItem, s);
        if (foreignItemNames != null && !foreignItemNames.isEmpty()) {
            details = Messages.getString("MenuItemDAO.3") + (foreignItemNames.size() > 1 ? Messages.getString("MenuItemDAO.4") : ":");
            int count = 1;
            for (String itemName : foreignItemNames) {
                details = details + "\n" + count + ". " + itemName;
                ++count;
            }
        }
        if ((menuItems = this.getMenuItemsByComboItemId(menuItem.getId(), s)) != null && !menuItems.isEmpty()) {
            if (StringUtils.isNotBlank((String)details)) {
                details = details + "\n";
            }
            details = details + Messages.getString("MenuItemDAO.5");
            int count = 1;
            for (MenuItem item : menuItems) {
                details = details + "\n" + count + ". " + item.getName();
                ++count;
            }
        }
        if ((menuItems = this.getMenuItemsByComboGroupsByComboGroupItemId(menuItem.getId(), s)) != null && !menuItems.isEmpty()) {
            if (StringUtils.isNotBlank((String)details)) {
                details = details + "\n";
            }
            details = details + Messages.getString("MenuItemDAO.8");
            int count = 1;
            for (MenuItem item : menuItems) {
                details = details + "\n" + count + ". " + item.getName();
                ++count;
            }
        }
        if (StringUtils.isNotBlank((String)details)) {
            throw new PosException(Messages.getString("MenuItemDAO.2"), details);
        }
    }

    private List<MenuItem> getMenuItemsByComboItemId(String comboItemId, Session session) {
        if (StringUtils.isBlank((String)comboItemId) || session == null) {
            return null;
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.createAlias("comboItems", "i");
        criteria.add(Restrictions.isNotNull((String)("i." + ComboItem.PROP_MENU_ITEM_ID)));
        criteria.add((Criterion)Restrictions.eq((String)("i." + ComboItem.PROP_ITEM_ID), (Object)comboItemId));
        criteria.setProjection(Projections.alias((Projection)Projections.distinct((Projection)Projections.property((String)MenuItem.PROP_NAME)), (String)MenuItem.PROP_NAME));
        return criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
    }

    private List<MenuItem> getMenuItemsByComboGroupsByComboGroupItemId(String comboGroupItemId, Session session) {
        if (StringUtils.isBlank((String)comboGroupItemId) || session == null) {
            return null;
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.createAlias("comboGroups", "g");
        criteria.createAlias("g.items", "i");
        criteria.add(Restrictions.in((String)("i." + MenuItem.PROP_ID), Arrays.asList(comboGroupItemId)));
        criteria.setProjection(Projections.alias((Projection)Projections.distinct((Projection)Projections.property((String)MenuItem.PROP_NAME)), (String)MenuItem.PROP_NAME));
        return criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
    }

    private void removeFromDependentModels(MenuItem menuItem, Session session) {
        String menuItemId = menuItem.getId();
        PriceTableItem priceTableItem = PriceTableItemDAO.getInstance().getPriceTableItemByMenuItemId(menuItemId);
        if (priceTableItem != null) {
            PriceTableItemDAO.getInstance().delete(priceTableItem, session);
        }
        String hqlString = "delete MenuPageItem where %s=:menuItemId";
        hqlString = String.format(hqlString, MenuPageItem.PROP_MENU_ITEM_ID);
        Query query = session.createQuery(hqlString);
        query.setParameter("menuItemId", (Object)menuItemId);
        query.executeUpdate();
    }

    private void updateDependentModels(MenuItem menuItem, Session session) {
        this.saveInventoryStockStatus(menuItem, session);
        MenuPageItemDAO menuPageItemDAO = MenuPageItemDAO.getInstance();
        List<MenuPageItem> pageItems = menuPageItemDAO.getPageItemFor(menuItem, session);
        if (pageItems != null) {
            for (MenuPageItem menuPageItem : pageItems) {
                menuPageItem.setMenuItem(menuItem);
                menuPageItemDAO.saveOrUpdate(menuPageItem, session);
            }
        }
        List<ComboItem> comboItems = ComboItemDAO.getInstance().getByMenuItem(menuItem.getId(), session);
        for (ComboItem comboItem : comboItems) {
            comboItem.setMenuItem(menuItem);
            ComboItemDAO.getInstance().update(comboItem, session);
        }
        this.updateDependentStockModel(menuItem, session);
    }

    private void updateDependentStockModel(MenuItem menuItem, Session session) throws HibernateException {
        String hqlString = "update InventoryStock set %s=:itemName, %s=:sku, %s=:barCode where %s=:menuItemId";
        hqlString = String.format(hqlString, InventoryStock.PROP_ITEM_NAME, InventoryStock.PROP_SKU, InventoryStock.PROP_BARCODE, InventoryStock.PROP_MENU_ITEM_ID);
        Query query = session.createQuery(hqlString);
        query.setParameter("itemName", (Object)menuItem.getName());
        query.setParameter("sku", (Object)menuItem.getSku());
        query.setParameter("barCode", (Object)menuItem.getBarcode());
        query.setParameter("menuItemId", (Object)menuItem.getId());
        query.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll(List<MenuItem> items) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (MenuItem menuItem : items) {
                menuItem.setLastUpdateTime(StoreDAO.getServerTimestamp());
                session.merge((Object)menuItem);
            }
            tx.commit();
        }
    }

    private void saveInventoryStockStatus(MenuItem menuItem, Session session) {
        if (!menuItem.isInventoryItem().booleanValue()) {
            return;
        }
        MenuItemInventoryStatus stockStatus = menuItem.getStockStatus();
        if (stockStatus == null) {
            stockStatus = new MenuItemInventoryStatus();
            menuItem.setStockStatus(stockStatus);
        }
        if (stockStatus.getId() == null) {
            stockStatus.setId(menuItem.getId());
            MenuItemInventoryStatusDAO.getInstance().save(stockStatus, session);
        }
    }

    @Override
    public void saveOrUpdate(MenuItem menuItem) throws HibernateException {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            menuItem.setLastUpdateTime(StoreDAO.getServerTimestamp());
            if (menuItem.getId() == null) {
                this.save(menuItem, session);
            } else {
                this.update(menuItem, session);
            }
            if (!menuItem.isInventoryItem().booleanValue()) {
                tx.commit();
                return;
            }
            MenuItemInventoryStatus stockStatus = menuItem.getStockStatus();
            if (stockStatus == null) {
                stockStatus = new MenuItemInventoryStatus();
                stockStatus.setId(menuItem.getId());
                menuItem.setStockStatus(stockStatus);
                MenuItemInventoryStatusDAO.getInstance().save(stockStatus, session);
            }
            tx.commit();
        }
    }

    public void initializeUnits(MenuItem menuItem) {
        try (Session session = null;){
            session = this.createNewSession();
            session.refresh((Object)menuItem);
            if (!Hibernate.isInitialized(menuItem.getStockUnits())) {
                Hibernate.initialize(menuItem.getStockUnits());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(String searchString) {
        Criteria criteria = null;
        try (Session session = null;){
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                int n = rowCount.intValue();
                return n;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInventoryItems(String searchString, BeanTableModel<MenuItem> listModel) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START));
            }
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(listModel.getPageSize());
            listModel.setRows(criteria.list());
        }
    }

    public int rowCount(Boolean menuItem, MenuGroup menuGroup, String itemName, Object selectedType, boolean variant) {
        return this.rowCount(menuItem, menuGroup, itemName, selectedType, variant, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(Boolean menuItem, MenuGroup menuGroup, String itemName, Object selectedType, boolean variant, Boolean pizzaType) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.setProjection(Projections.rowCount());
            if (!menuItem.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (pizzaType != null && pizzaType.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)pizzaType));
            }
            if (!variant) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            this.addOrderTypeFilter(selectedType, session, criteria);
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(Boolean menuItem, MenuGroup menuGroup, String itemName) {
        Criteria criteria = null;
        try (Session session = null;){
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.setProjection(Projections.rowCount());
            if (!menuItem.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(MenuGroup menuGroup, String itemName, boolean variant, Boolean pizzaType) {
        Criteria criteria = null;
        try (Session session = null;){
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (pizzaType != null && pizzaType.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)pizzaType));
            }
            if (!variant) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    public MenuItem loadInitialized(String menuItemId) throws HibernateException {
        MenuItem menuItem = super.get(menuItemId);
        this.initialize(menuItem);
        return menuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getInitialized(String menuItemId) {
        if (StringUtils.isEmpty((String)menuItemId)) {
            return null;
        }
        try (Session session = null;){
            session = this.createNewSession();
            MenuItem menuItem = this.get(menuItemId, session);
            this.initialize(menuItem, session);
            MenuItem menuItem2 = menuItem;
            return menuItem2;
        }
    }

    public void initialize(MenuItem menuItem) {
        if (menuItem == null || StringUtils.isBlank((String)menuItem.getId())) {
            return;
        }
        try (Session session = null;){
            session = this.createNewSession();
            session.refresh((Object)menuItem);
            this.initialize(menuItem, session);
        }
    }

    public void deleteVariants(MenuItem menuItem, Session session) {
        if (menuItem == null) {
            return;
        }
        this.deleteVariants(menuItem.getVariants(), session);
    }

    public void deleteVariants(List<MenuItem> variants, Session session) {
        if (variants == null || variants.isEmpty()) {
            return;
        }
        for (MenuItem variant : variants) {
            this.delete(variant, session);
        }
    }

    public void initializeVariants(MenuItem menuItem) {
        if (menuItem == null || menuItem.getId() == null) {
            return;
        }
        try (Session session = null;){
            session = this.createNewSession();
            session.update((Object)menuItem);
            Hibernate.initialize(menuItem.getVariants());
            Hibernate.initialize(menuItem.getAttributes());
        }
    }

    public void initialize(MenuItem menuItem, Session session) {
        List<MenuItemModifierSpec> modiferSpecs;
        if (menuItem == null) {
            return;
        }
        Hibernate.initialize(menuItem.getStockUnits());
        Hibernate.initialize(menuItem.getMenuItemModiferSpecs());
        Hibernate.initialize(menuItem.getPizzaPriceList());
        Hibernate.initialize(menuItem.getDiscounts());
        Hibernate.initialize(menuItem.getComboGroups());
        Hibernate.initialize(menuItem.getComboItems());
        Hibernate.initialize(menuItem.getVariants());
        Hibernate.initialize(menuItem.getAttributes());
        List<MenuItem> variants = menuItem.getVariants();
        if (variants != null) {
            for (MenuItem menuItem2 : variants) {
                Hibernate.initialize(menuItem2.getAttributes());
            }
        }
        if ((modiferSpecs = menuItem.getMenuItemModiferSpecs()) != null) {
            for (MenuItemModifierSpec modifierSpec : modiferSpecs) {
                Set<MenuItemModifierPage> modifierPages = modifierSpec.getModifierPages();
                for (MenuItemModifierPage modifierPage : modifierPages) {
                    modifierPage.setModifierSpec(modifierSpec);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findByParent(Terminal terminal, MenuGroup menuGroup, boolean includeInvisibleItems) throws PosException {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (!includeInvisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            List list = criteria.list();
            return list;
        }
    }

    public List<MenuItem> getVariants(MenuItem parentItem, Session session) throws PosException {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        if (parentItem != null) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PARENT_MENU_ITEM_ID, (Object)parentItem.getId()));
        }
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
        criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
        criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
        return criteria.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getVariants(MenuItem parentItem) throws PosException {
        try (Session session = null;){
            session = this.createNewSession();
            List<MenuItem> list = this.getVariants(parentItem, session);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(Terminal terminal, MenuGroup menuGroup, Object selectedOrderType) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            this.addOrderTypeFilter(selectedOrderType, session, criteria);
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(Terminal terminal, MenuGroup menuGroup, Object selectedOrderType, boolean includeInvisibleItems, PaginatedListModel listModel, boolean variant) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (!variant) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (!includeInvisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            this.addOrderTypeFilter(selectedOrderType, session, criteria);
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(listModel.getPageSize());
            listModel.setData(criteria.list());
        }
    }

    public List<MenuItemModifierSpec> findModifierGroups(MenuItem item) throws PosException {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_ID, (Object)item.getId()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            MenuItem newItem = (MenuItem)criteria.uniqueResult();
            Hibernate.initialize(newItem.getMenuItemModiferSpecs());
            List<MenuItemModifierSpec> list = newItem.getMenuItemModiferSpecs();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems(String itemName, MenuGroup menuGroup, Object selectedType, String type) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.getSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (type.equals("InventoryItem")) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            }
            this.addOrderTypeFilter(selectedType, session, criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getPizzaItems(String itemName, MenuGroup menuGroup, Object selectedType) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)true));
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            this.addOrderTypeFilter(selectedType, session, criteria);
            List list = criteria.list();
            return list;
        }
    }

    public void releaseParent(List<MenuItem> menuItemList) {
    }

    public void releaseParentAndDelete(MenuItem item) {
        if (item == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            String queryStringForDiscount = "delete from MENUITEM_DISCOUNT where MENUITEM_ID='%s'";
            queryStringForDiscount = String.format(queryStringForDiscount, item.getId());
            SQLQuery query = session.createSQLQuery(queryStringForDiscount);
            query.executeUpdate();
            String queryString = "delete from MENU_PAGE_ITEM where MENU_ITEM_ID='%s'";
            queryString = String.format(queryString, item.getId());
            SQLQuery queryForPageItem = session.createSQLQuery(queryString);
            queryForPageItem.executeUpdate();
            String queryStringReleaseRecipe = "delete from RECIPE_TABLE where MENU_ITEM_ID='%s'";
            queryStringReleaseRecipe = String.format(queryStringReleaseRecipe, item.getId());
            SQLQuery queryReleaseRecipe = session.createSQLQuery(queryStringReleaseRecipe);
            queryReleaseRecipe.executeUpdate();
            session.delete((Object)item);
            tx.commit();
        }
    }

    public MenuItem getMenuItemByIdOrBarcode(String barcode) {
        MenuItem menuItem = this.getMenuItemById(barcode);
        if (menuItem == null) {
            menuItem = this.getMenuItemByBarcode(barcode);
        }
        return menuItem;
    }

    public MenuItem getMenuItemById(String id) {
        return this.getMenuItemById(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemById(String id, boolean showVisibleItems) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            this.addDeletedFilter(criteria);
            if (showVisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)showVisibleItems));
            }
            criteria.add((Criterion)Restrictions.like((String)MenuItem.PROP_ID, (Object)id));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                MenuItem menuItem = null;
                return menuItem;
            }
            MenuItem menuItem = (MenuItem)result.get(0);
            return menuItem;
        }
    }

    public MenuItem getMenuItemByBarcodeOrSKU(String barcode) {
        MenuItem menuItem = this.getMenuItemByBarcode(barcode);
        if (menuItem == null) {
            menuItem = this.getMenuItemBySKU(barcode);
        }
        return menuItem;
    }

    public MenuItem getMenuItemByBarcode(String barcode) {
        return this.getMenuItemByBarcode(barcode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemByBarcode(String barcode, boolean showVisibleItems) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (showVisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)showVisibleItems));
            }
            criteria.add((Criterion)Restrictions.like((String)MenuItem.PROP_BARCODE, (Object)barcode));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                MenuItem menuItem = null;
                return menuItem;
            }
            MenuItem menuItem = (MenuItem)result.get(0);
            return menuItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemBySKU(String skuNo) {
        try (Session session = null;){
            session = this.createNewSession();
            MenuItem menuItem = this.getMenuItemBySKU(skuNo, session, false);
            return menuItem;
        }
    }

    public MenuItem getMenuItemBySKU(String skuNo, Session session, boolean includeInactiveItems) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        if (!includeInactiveItems) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
        }
        criteria.add((Criterion)Restrictions.like((String)MenuItem.PROP_SKU, (Object)skuNo));
        List result = criteria.list();
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (MenuItem)result.get(0);
    }

    public List<MenuItem> getMenuItemByName(String itemName) {
        return this.getMenuItemByName(itemName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemByName(String itemName, boolean showVisibleItems) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (showVisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)showVisibleItems));
            }
            criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName, (MatchMode)MatchMode.ANYWHERE));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                List<MenuItem> list = null;
                return list;
            }
            List list = result;
            return list;
        }
    }

    public List<MenuItem> getMenuItemsByName(MenuGroup menuGroup, String itemName) {
        return this.getMenuItemsByName(menuGroup, itemName, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemsByName(MenuGroup menuGroup, String itemName, boolean hideInvisibleItems, boolean includeVariantParent) {
        Criteria criteria = null;
        try (Session session = null;){
            List result;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (hideInvisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            if (!includeVariantParent) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            }
            this.addNameCriteriaOnNameBarCodeAndSKU(itemName, criteria);
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if ((result = criteria.list()) == null || result.isEmpty()) {
                List<MenuItem> list = null;
                return list;
            }
            List list = result;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemsByName(MenuCategory menuCategory, String itemName, boolean hideInvisibleItems, boolean includeVariantParent) {
        Criteria criteria = null;
        try (Session session = null;){
            List result;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (hideInvisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            this.addNameCriteriaOnNameBarCodeAndSKU(itemName, criteria);
            if (!includeVariantParent) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            if ((result = criteria.list()) == null || result.isEmpty()) {
                List<MenuItem> list = null;
                return list;
            }
            List list = result;
            return list;
        }
    }

    public List<MenuItem> getMenuItemsByName(OrderType orderType, MenuCategory menuCategory, MenuGroup menuGroup, String itemName, boolean hideInvisibleItems) {
        return this.getMenuItemsByName(orderType, menuCategory, menuGroup, itemName, hideInvisibleItems, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemsByName(OrderType orderType, MenuCategory menuCategory, MenuGroup menuGroup, String itemName, boolean hideInvisibleItems, boolean includeVariantParent) {
        if (menuGroup != null) {
            return this.getMenuItemsByName(menuGroup, itemName, hideInvisibleItems, includeVariantParent);
        }
        if (menuCategory != null) {
            return this.getMenuItemsByName(menuCategory, itemName, hideInvisibleItems, includeVariantParent);
        }
        List<MenuCategory> activeCategories = MenuCategoryDAO.getInstance().findActiveCategories(orderType);
        ArrayList<String> catIdList = new ArrayList<String>();
        for (MenuCategory menuCategory2 : activeCategories) {
            catIdList.add(menuCategory2.getId());
        }
        if (catIdList == null || catIdList.isEmpty()) {
            return null;
        }
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (hideInvisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            if (!includeVariantParent) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            }
            this.addNameCriteriaOnNameBarCodeAndSKU(itemName, criteria);
            criteria.add(Restrictions.in((String)MenuItem.PROP_MENU_CATEGORY_ID, catIdList));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                List<MenuItem> list = null;
                return list;
            }
            List list = result;
            return list;
        }
    }

    private void addNameCriteriaOnNameBarCodeAndSKU(String itemName, Criteria criteria) {
        if (StringUtils.isNotEmpty((String)itemName)) {
            Disjunction or = Restrictions.disjunction();
            or.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            or.add(Restrictions.ilike((String)MenuItem.PROP_BARCODE, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            or.add(Restrictions.ilike((String)MenuItem.PROP_SKU, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            criteria.add((Criterion)or);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems(String sku, String name, String barcode, ReportGroup reportGroup) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (StringUtils.isNotEmpty((String)barcode)) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)barcode));
            }
            if (StringUtils.isNotEmpty((String)sku)) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)sku));
            }
            if (StringUtils.isNotEmpty((String)name)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)name, (MatchMode)MatchMode.START));
            }
            if (reportGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_REPORT_GROUP_ID, (Object)reportGroup.getId()));
            }
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findMenuItemsForStockCount(String searchString, MenuGroup group, InventoryVendor vendor, InventoryLocation location) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            List commonMenuItemsId = null;
            if (vendor != null) {
                criteria = session.createCriteria(InventoryVendorItems.class);
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)vendor));
                criteria.createAlias(InventoryVendorItems.PROP_ITEM, "item");
                criteria.setProjection((Projection)Projections.property((String)"item.id"));
                commonMenuItemsId = criteria.list();
            }
            if (location != null) {
                criteria = session.createCriteria(InventoryStock.class);
                criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)location.getId()));
                criteria.setProjection((Projection)Projections.property((String)InventoryStock.PROP_MENU_ITEM_ID));
                if (commonMenuItemsId == null) {
                    commonMenuItemsId = criteria.list();
                } else {
                    commonMenuItemsId.retainAll(criteria.list());
                }
            }
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            criteria.add(Restrictions.isNotNull((String)MenuItem.PROP_UNIT_ID));
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)searchString), (Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)searchString), (Criterion)Restrictions.ilike((String)MenuItem.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START))));
            }
            if (group != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)group.getId()));
            }
            if (commonMenuItemsId != null && !commonMenuItemsId.isEmpty()) {
                criteria.add(Restrictions.in((String)MenuItem.PROP_ID, (Collection)commonMenuItemsId));
            }
            criteria.setMaxResults(200);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getPizzaItems() {
        Criteria criteria = null;
        try (Session session = null;){
            List result;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)true));
            List list = result = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems() {
        Criteria criteria = null;
        try (Session session = null;){
            List result;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)false), (Criterion)Restrictions.isNull((String)MenuItem.PROP_PIZZA_TYPE)));
            List list = result = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getInventortItems() {
        Criteria criteria = null;
        try (Session session = null;){
            List result;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            List list = result = criteria.list();
            return list;
        }
    }

    public MenuItem getReplenishedMenuItem(Integer id, Session session) {
        Criteria criteria = null;
        criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_ID, (Object)id));
        MenuItem menuItem = (MenuItem)criteria.uniqueResult();
        Double reorderLevel = 0.0;
        if (menuItem != null) {
            reorderLevel = menuItem.getReorderLevel();
        }
        if (reorderLevel == 0.0) {
            return null;
        }
        criteria = session.createCriteria(MenuItemInventoryStatus.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItemInventoryStatus.PROP_ID, (Object)id));
        criteria.add((Criterion)Restrictions.lt((String)MenuItemInventoryStatus.PROP_AVAILABLE_UNIT, (Object)reorderLevel));
        MenuItemInventoryStatus inventoryStatus = (MenuItemInventoryStatus)criteria.uniqueResult();
        if (inventoryStatus == null) {
            return null;
        }
        menuItem.setStockStatus(inventoryStatus);
        return menuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getReOrderedMenuItems() {
        Criteria criteria = null;
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass(), "item");
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.add(Subqueries.exists((DetachedCriteria)this.getDetachedCriteriaForStockStatus("item.id")));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    private DetachedCriteria getDetachedCriteriaForStockStatus(String propItemId) {
        DetachedCriteria stockStatusSubCriteria = DetachedCriteria.forClass(MenuItemInventoryStatus.class, (String)"status").setProjection((Projection)Projections.property((String)MenuItemInventoryStatus.PROP_ID)).add((Criterion)Restrictions.eqProperty((String)MenuItemInventoryStatus.PROP_ID, (String)propItemId)).add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)("status." + MenuItemInventoryStatus.PROP_UNIT_ON_HAND)), (Criterion)Restrictions.leProperty((String)("status." + MenuItemInventoryStatus.PROP_UNIT_ON_HAND), (String)("item." + MenuItem.PROP_REORDER_LEVEL))));
        return stockStatusSubCriteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowReOrderedItemCount(MenuGroup menuGroup, String itemName, boolean variant, Boolean pizzaType) {
        Criteria criteria = null;
        try (Session session = null;){
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class, "item");
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.setProjection(Projections.rowCount());
            criteria.add(Subqueries.exists((DetachedCriteria)this.getDetachedCriteriaForStockStatus("item.id")));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            if (pizzaType != null && pizzaType.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)pizzaType));
            }
            if (!variant) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadReorderedMenuItems(PaginationSupport model, MenuGroup menuGroup, String itemName, boolean variant, Boolean pizzaType) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class, "item");
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add(Subqueries.exists((DetachedCriteria)this.getDetachedCriteriaForStockStatus("item.id")));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            if (pizzaType != null && pizzaType.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)pizzaType));
            }
            if (!variant) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems(String sku, String name, String barcode, MenuGroup menuGroup, Pagination pagination, Boolean filterParentMenuItem) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            this.updateCriteria(criteria, sku, name, barcode, menuGroup, pagination, filterParentMenuItem);
            List list = criteria.list();
            if (pagination != null) {
                criteria = session.createCriteria(this.getReferenceClass());
                criteria.setProjection(Projections.rowCount());
                this.updateCriteria(criteria, sku, name, barcode, menuGroup, null, filterParentMenuItem);
                Number uniqueResult = (Number)criteria.uniqueResult();
                pagination.setNumRows(uniqueResult.intValue());
            }
            List list2 = list;
            return list2;
        }
    }

    public List<MenuItem> getMenuItems(String sku, String name, String barcode, MenuGroup menuGroup, Pagination pagination) {
        return this.getMenuItems(sku, name, barcode, menuGroup, pagination, null);
    }

    private void updateCriteria(Criteria criteria, String sku, String name, String barcode, MenuGroup menuGroup, Pagination pagination, Boolean filterParentMenuItem) {
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_DELETED), (Criterion)Restrictions.eq((String)MenuItem.PROP_DELETED, (Object)Boolean.FALSE)));
        if (StringUtils.isNotEmpty((String)barcode)) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)barcode));
        }
        if (StringUtils.isNotEmpty((String)sku)) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)sku));
        }
        if (StringUtils.isNotEmpty((String)name)) {
            criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)name, (MatchMode)MatchMode.ANYWHERE));
        }
        if (menuGroup != null) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
        }
        if (pagination != null) {
            criteria.setFirstResult(pagination.getCurrentRowIndex());
            criteria.setMaxResults(pagination.getPageSize());
        }
        if (filterParentMenuItem != null && filterParentMenuItem.booleanValue()) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE)));
        }
    }

    public void loadMenuItems(PaginationSupport model, Boolean menuItem) {
        this.loadMenuItems(model, menuItem, null, null, null, false);
    }

    public void loadMenuItems(PaginationSupport model, Boolean menuItem, MenuGroup menuGroup, String itemName, MenuCategory selectedType, boolean variant) {
        this.loadMenuItems(model, menuItem, menuGroup, itemName, selectedType, variant, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> loadInventoryMenuItem() {
        Criteria criteria = null;
        try (Session session = null;){
            List result;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            List list = result = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> loadInventoryMenuItem(String nameOrSku, MenuGroup menuGroup, MenuCategory menuCategory) {
        Criteria criteria = null;
        try (Session session = null;){
            List result;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_MENU_GROUP_ID));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            if (StringUtils.isNotEmpty((String)nameOrSku)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)MenuItem.PROP_NAME, (String)nameOrSku, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)nameOrSku)));
            }
            List list = result = criteria.list();
            return list;
        }
    }

    public void loadMenuItems(PaginationSupport model, Boolean menuItem, MenuGroup menuGroup, String itemName, MenuCategory menuCategory, boolean variant, Boolean pizzaType) {
        this.loadMenuItems(model, menuItem, menuGroup, itemName, menuCategory, variant, pizzaType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(PaginationSupport model, Boolean menuItem, MenuGroup menuGroup, String itemName, MenuCategory menuCategory, boolean variant, Boolean pizzaType, Boolean activeStatus) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (!menuItem.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (pizzaType != null && pizzaType.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)pizzaType));
            }
            if (!variant) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            this.addNameCriteriaOnNameBarCodeAndSKU(itemName, criteria);
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            if (activeStatus != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)activeStatus));
            }
            criteria.setProjection(Projections.rowCount());
            Number uniqueResult = (Number)criteria.uniqueResult();
            model.setNumRows(uniqueResult.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
    }

    private void addOrderTypeFilter(Object selectedType, Session session, Criteria criteria) {
        if (selectedType instanceof OrderType) {
            OrderType orderType = (OrderType)selectedType;
            Criteria criteria2 = session.createCriteria(MenuCategory.class);
            criteria2.createAlias("orderTypes", "ot");
            criteria2.add(Restrictions.in((String)("ot." + OrderType.PROP_ID), Arrays.asList(orderType.getId())));
            List list = criteria2.list();
            if (list != null && !list.isEmpty()) {
                ArrayList<String> idList = new ArrayList<String>();
                for (MenuCategory object : list) {
                    idList.add(object.getId());
                }
                criteria.add(Restrictions.in((String)MenuItem.PROP_MENU_CATEGORY_ID, idList));
            }
        }
    }

    public void findByBarcodeOrName(PaginationSupport paginationSupport, Boolean inventoryItemOnly, MenuGroup menuGroup, String itemNameOrBarcode, Boolean includeVariantItem, Boolean pizzaType, Boolean showInvisibleItems) {
        this.findByBarcodeOrName(paginationSupport, inventoryItemOnly, menuGroup, itemNameOrBarcode, includeVariantItem, pizzaType, showInvisibleItems, true, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findByBarcodeOrName(PaginationSupport paginationSupport, Boolean inventoryItemOnly, MenuGroup menuGroup, String itemNameOrBarcode, Boolean includeVariantParent, Boolean pizzaType, Boolean showInvisibleItems, boolean showVariant, boolean showComboItem, String ... fields) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (StringUtils.isNotEmpty((String)itemNameOrBarcode)) {
                Criterion name = Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemNameOrBarcode.trim(), (MatchMode)MatchMode.ANYWHERE);
                Criterion barcode = Restrictions.ilike((String)MenuItem.PROP_BARCODE, (String)itemNameOrBarcode.trim(), (MatchMode)MatchMode.ANYWHERE);
                Criterion sku = Restrictions.ilike((String)MenuItem.PROP_SKU, (String)itemNameOrBarcode.trim(), (MatchMode)MatchMode.ANYWHERE);
                Disjunction or = Restrictions.or((Criterion[])new Criterion[]{name, barcode, sku});
                criteria.add((Criterion)or);
            }
            if (inventoryItemOnly.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (pizzaType != null && pizzaType.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)pizzaType));
            }
            if (!includeVariantParent.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)includeVariantParent));
            }
            if (!showVariant) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)showVariant));
            }
            if (!showComboItem) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_COMBO_ITEM, (Object)showComboItem));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (showInvisibleItems.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)showInvisibleItems));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                paginationSupport.setNumRows(rowCount.intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (fields != null && fields.length > 0) {
                ProjectionList projectionList = Projections.projectionList();
                for (String field : fields) {
                    projectionList.add((Projection)Projections.property((String)field), field);
                }
                criteria.setProjection((Projection)projectionList);
                criteria.setResultTransformer(Transformers.aliasToBean(MenuItem.class));
                paginationSupport.setRows(criteria.list());
            } else {
                paginationSupport.setRows(criteria.list());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem findByName(String menuItemName) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_NAME, (Object)menuItemName));
            List result = criteria.list();
            if (result.size() == 0) {
                MenuItem menuItem = null;
                return menuItem;
            }
            MenuItem menuItem = (MenuItem)result.get(0);
            return menuItem;
        }
    }

    public MenuItem findByBarcode(String barcode, Session session) {
        if (StringUtils.isEmpty((String)barcode)) {
            return null;
        }
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)barcode.trim()));
        List list = criteria.list();
        if (list.size() > 0) {
            return (MenuItem)list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(BeanTableModel model, Boolean menuItem, MenuGroup menuGroup, String itemName) {
        Criteria criteria = null;
        try (Session session = null;){
            String modelSortColumn;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (!menuItem.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)(modelSortColumn = model.getSortBy()))) {
                criteria.addOrder(model.isAscOrder() ? Order.asc((String)modelSortColumn) : Order.desc((String)modelSortColumn));
            } else {
                criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
                criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            }
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(PaginationSupport model, MenuGroup menuGroup, String itemName, boolean variant, Boolean pizzaType) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (pizzaType != null && pizzaType.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)pizzaType));
            }
            if (!variant) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInventoryItems(PaginationSupport model, MenuGroup menuGroup, String itemName) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.ilike((String)MenuItem.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE), Restrictions.ilike((String)MenuItem.PROP_SKU, (String)itemName.trim(), (MatchMode)MatchMode.START), Restrictions.ilike((String)MenuItem.PROP_BARCODE, (String)itemName.trim(), (MatchMode)MatchMode.START)}));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            model.setNumRows(rowCount.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findAllInventoryItems() {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            List list = criteria.list();
            return list;
        }
    }

    public void updateStockQuantity(String menuItemId, double unitQuantity, boolean updateAvailableUnit, boolean updateOnHandUnit, Session session) {
        MenuItemInventoryStatus status = MenuItemInventoryStatusDAO.getInstance().get(menuItemId, session);
        if (status == null) {
            status = new MenuItemInventoryStatus();
            status.setId(menuItemId);
        }
        if (updateAvailableUnit) {
            status.setAvailableUnit(status.getAvailableUnit() + unitQuantity);
        }
        if (updateOnHandUnit) {
            status.setUnitOnHand(status.getUnitOnHand() + unitQuantity);
        }
        MenuItemInventoryStatusDAO.getInstance().saveOrUpdate(status, session);
    }

    public void updateStockQuantity(String menuItemId, double unitQuantity, double unitCost, boolean updateAvailableUnit, boolean updateOnHandUnit, Session session) {
        String sql = null;
        sql = updateAvailableUnit && updateOnHandUnit ? String.format("update MenuItem set availableUnit = (availableUnit + %s),unitOnHand = (unitOnHand + %s),cost = %s where id = '%s'", unitQuantity, unitQuantity, unitCost, menuItemId) : (updateOnHandUnit ? String.format("update MenuItem set unitOnHand = (unitOnHand + %s),cost = %s where id = '%s'", unitQuantity, unitCost, menuItemId) : String.format("update MenuItem set availableUnit = (availableUnit + %s),cost = %s where id = '%s'", unitQuantity, unitCost, menuItemId));
        session.createQuery(sql).executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsMenuItem(MenuGroup menuGroup) {
        Criteria criteria = null;
        try (Session session = null;){
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.setProjection(Projections.rowCount());
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            boolean bl = (rowCount = (Number)criteria.uniqueResult()) != null && rowCount.intValue() > 0;
            return bl;
        }
    }

    public void updateLastPurchaseCost(String menuItemId, double cost, boolean updateLastPurchasePrice, Session session) {
        String sql = null;
        double avgCost = InventoryTransactionDAO.getInstance().findItemAvgCost(menuItemId, session);
        double actualCost = updateLastPurchasePrice ? cost : avgCost;
        actualCost = NumberUtil.roundToTwoDigit(actualCost);
        sql = String.format("update MenuItem set lastPurchasedCost = %s,avgCost=%s, cost = %s where id = '%s'", cost, avgCost, actualCost, menuItemId);
        session.createQuery(sql).executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastPurchaseCost(PurchaseOrder order, boolean updateLastPurchasePrice) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            List<PurchaseOrderItem> orderItems = order.getOrderItems();
            for (PurchaseOrderItem purchaseOrderItem : orderItems) {
                MenuItem menuItem = purchaseOrderItem.getMenuItem();
                double baseUnitQuantity = menuItem.getBaseUnitQuantity(purchaseOrderItem.getItemUnitName());
                double unitPrice = NumberUtil.roundToTwoDigit(purchaseOrderItem.getUnitPrice() / baseUnitQuantity);
                this.updateLastPurchaseCost(menuItem.getId(), unitPrice, updateLastPurchasePrice, session);
            }
            session.saveOrUpdate((Object)order);
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemWithFields(String menuItemId, String ... fields) throws Exception {
        try (Session session = null;){
            session = this.createNewSession();
            MenuItem menuItem = this.getMenuItemWithFields(session, menuItemId, fields);
            return menuItem;
        }
    }

    public MenuItem getMenuItemWithFields(Session session, String menuItemId, String ... fields) throws Exception {
        Criteria criteria = null;
        criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_ID, (Object)menuItemId));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)MenuItem.PROP_ID), MenuItem.PROP_ID);
        for (String field : fields) {
            projectionList.add((Projection)Projections.property((String)field), field);
        }
        criteria.setProjection((Projection)projectionList);
        criteria.setResultTransformer(Transformers.aliasToBean(MenuItem.class));
        MenuItem menuItem = (MenuItem)criteria.uniqueResult();
        if (menuItem != null) {
            Hibernate.initialize(menuItem.getStockUnits());
        }
        return menuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(PaginationSupport model, String searchItem) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (StringUtils.isNotEmpty((String)searchItem)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)searchItem.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)false));
            criteria.setProjection(Projections.rowCount());
            Number uniqueResult = (Number)criteria.uniqueResult();
            model.setNumRows(uniqueResult.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findAllUnSyncMenuItems() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            SimpleExpression falseCriteria = Restrictions.eq((String)MenuItem.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)MenuItem.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null && session != null) {
                session.close();
            }
        }
    }

    public void updateMenuItemSync(List<String> ids, Boolean synced) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        try (Session session = null;){
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update MenuItem set %s=:synced where %s in" + whereCondition;
            hqlString = String.format(hqlString, MenuItem.PROP_CLOUD_SYNCED, MenuItem.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("synced", (Object)synced);
            query.executeUpdate();
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasByBarcodeOrSKU(String barcode, String sku) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            Disjunction or = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)barcode)) {
                or.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)barcode));
            }
            if (StringUtils.isNotEmpty((String)sku)) {
                or.add((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)sku));
            }
            criteria.add((Criterion)or);
            List result = criteria.list();
            if (result.size() == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemByBarcodeAndSKU(String barcode, String sku) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.like((String)MenuItem.PROP_BARCODE, (Object)barcode));
            criteria.add((Criterion)Restrictions.like((String)MenuItem.PROP_SKU, (Object)sku));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                MenuItem menuItem = null;
                return menuItem;
            }
            MenuItem menuItem = (MenuItem)result.get(0);
            return menuItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemByBarcodeOrSKU(String barcode, String sku) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            Disjunction or = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)barcode)) {
                or.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)barcode));
            }
            if (StringUtils.isNotEmpty((String)sku)) {
                or.add((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)sku));
            }
            criteria.add((Criterion)or);
            List result = criteria.list();
            if (result.size() == 0) {
                MenuItem menuItem = null;
                return menuItem;
            }
            MenuItem menuItem = (MenuItem)result.get(0);
            return menuItem;
        }
    }

    public boolean isNameExist(String menuItemIdToExclude, String menuItemName) {
        if (StringUtils.isBlank((String)menuItemName)) {
            return false;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(MenuItem.class);
            if (StringUtils.isNotBlank((String)menuItemIdToExclude)) {
                criteria.add((Criterion)Restrictions.ne((String)MenuItem.PROP_ID, (Object)menuItemIdToExclude));
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_NAME, (Object)menuItemName));
            List list = criteria.list();
            boolean bl = list != null && !list.isEmpty();
            return bl;
        }
    }

    public void removePizzaPrices(List<String> listOfPriceId, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias("pizzaPriceList", "priceList");
        criteria.add(Restrictions.in((String)"priceList.id", listOfPriceId));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List list = criteria.list();
        if (list != null && !list.isEmpty()) {
            for (MenuItem menuItem : list) {
                List<PizzaPrice> pizzaPriceList = menuItem.getPizzaPriceList();
                Iterator<PizzaPrice> iterator = pizzaPriceList.iterator();
                while (iterator.hasNext()) {
                    PizzaPrice pizzaPrice = iterator.next();
                    if (!listOfPriceId.contains(pizzaPrice.getId())) continue;
                    iterator.remove();
                }
                session.update((Object)menuItem);
            }
        }
    }

    public List<MenuItem> getMenuItemsByPackagingUnit(PackagingUnit packagingUnit, Session session) {
        Criteria criteria = session.createCriteria(InventoryStockUnit.class);
        criteria.add((Criterion)Restrictions.eq((String)InventoryStockUnit.PROP_PACKAGING_UNIT, (Object)packagingUnit));
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)InventoryStockUnit.PROP_MENU_ITEM_ID)));
        List menuItemIds = criteria.list();
        if (menuItemIds != null && !menuItemIds.isEmpty()) {
            criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add(Restrictions.in((String)MenuItem.PROP_ID, (Collection)menuItemIds));
            criteria.setProjection(Projections.alias((Projection)Projections.property((String)MenuItem.PROP_NAME), (String)MenuItem.PROP_NAME));
            List menuItems = criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
            return menuItems;
        }
        return null;
    }

    public List<MenuItem> getMenuItemsByPrinterGroup(PrinterGroup printerGroup, Session session) {
        if (printerGroup == null) {
            return null;
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PRINTER_GROUP_ID, (Object)printerGroup.getId()));
        criteria.setProjection(Projections.alias((Projection)Projections.property((String)MenuItem.PROP_NAME), (String)MenuItem.PROP_NAME));
        return criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
    }

    public void updateUsingTransaction(MenuItem menuItem, Session session) {
        Transaction transaction = null;
        try {
            transaction = session.beginTransaction();
            this.update(menuItem, session);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }
    }
}

