/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.dao.BaseMenuItemModifierPageDAO;
import com.floreantpos.swing.PaginatedListModel;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class MenuItemModifierPageDAO
extends BaseMenuItemModifierPageDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdatePages(List<MenuItemModifierPage> menuPages) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (MenuItemModifierPage menuPage : menuPages) {
                session.saveOrUpdate((Object)menuPage);
            }
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(String specId) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)specId)) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierPage.PROP_MODIFIER_SPEC_ID, (Object)specId));
            }
            criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierPage.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(MenuItemModifierSpec spec, PaginatedListModel listModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)MenuItemModifierPage.PROP_SORT_ORDER));
            if (spec != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierPage.PROP_MODIFIER_SPEC_ID, (Object)spec.getId()));
            }
            criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierPage.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(1);
            listModel.setData(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateMenuItemModifierPageList(List<MenuItemModifierPage> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (MenuItemModifierPage item : dataList) {
                String modifierSpecId = item.getModifierSpecId();
                BaseDataServiceDao.get().saveOrSetVersionMenuItemModiPage(session, item);
                item.setModifierSpecId(modifierSpecId);
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.saveOrUpdate(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initializeItems(MenuItemModifierPage modifierPage) {
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)modifierPage);
            Hibernate.initialize(modifierPage.getPageItems());
        }
        finally {
            this.closeSession(session);
        }
    }
}

