/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.dao.BasePizzaCrustDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.PizzaPriceDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

public class PizzaCrustDAO
extends BasePizzaCrustDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    public List<PizzaCrust> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void delete(Object obj, Session session) {
        PizzaCrust pizzaCrust;
        if (obj instanceof PizzaCrust) {
            pizzaCrust = (PizzaCrust)obj;
            session.refresh((Object)pizzaCrust);
            List<String> listOfPriceId = PizzaPriceDAO.getInstance().findByPizzaCrust(pizzaCrust, session);
            if (listOfPriceId != null && !listOfPriceId.isEmpty()) {
                MenuItemDAO.getInstance().removePizzaPrices(listOfPriceId, session);
            }
        } else {
            throw new PosException(Messages.getString("PizzaCrustDAO.0"));
        }
        pizzaCrust.setDeleted(Boolean.TRUE);
        super.update(pizzaCrust, session);
    }

    @Override
    public Order getDefaultOrder() {
        return Order.asc((String)PizzaCrust.PROP_SORT_ORDER);
    }

    public void saveOrUpdateList(List<PizzaCrust> items) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.saveOrUpdateCrustList(items, session);
            tx.commit();
        }
    }

    public void saveOrUpdateCrustList(List<PizzaCrust> items, Session session) {
        for (PizzaCrust pizzaCrust : items) {
            session.saveOrUpdate((Object)pizzaCrust);
        }
    }

    public void saveOrUpdatePizzaCrustList(List<PizzaCrust> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (PizzaCrust item : dataList) {
                PizzaCrust existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

