/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TimedModel;
import java.io.Serializable;
import java.util.Date;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;

public class PosDataInterceptor
extends EmptyInterceptor {
    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        if (entity instanceof TicketItem || entity instanceof TimedModel) {
            return false;
        }
        try {
            int indexOf = this.getUpdateTimePropIndex(propertyNames);
            if (indexOf != -1) {
                currentState[indexOf] = new Date();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (entity instanceof TicketItem || entity instanceof TimedModel) {
            return false;
        }
        try {
            int indexOf = this.getUpdateTimePropIndex(propertyNames);
            if (indexOf != -1) {
                state[indexOf] = new Date();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private int getUpdateTimePropIndex(String[] properties) {
        for (int i = 0; i < properties.length; ++i) {
            if (!Ticket.PROP_LAST_UPDATE_TIME.equals(properties[i])) continue;
            return i;
        }
        return -1;
    }
}

