/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.ReversalTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseTicket;
import com.floreantpos.model.dao.BasePosTransactionDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.HibernateProjectionsUtil;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.CardTypeEnum;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.TransactionSummary;
import com.floreantpos.report.CustomerPaymentReportView;
import com.floreantpos.report.EndOfDayReportData;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class PosTransactionDAO
extends BasePosTransactionDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        StoreSession storeSession;
        PosTransaction transaction = (PosTransaction)obj;
        if (StringUtils.isEmpty((String)transaction.getStoreSessionId()) && (storeSession = DataProvider.get().getStoreSession()) != null) {
            transaction.setStoreSessionId(storeSession.getId());
        }
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        StoreSession storeSession;
        PosTransaction transaction = (PosTransaction)obj;
        if (StringUtils.isEmpty((String)transaction.getStoreSessionId()) && (storeSession = DataProvider.get().getStoreSession()) != null) {
            transaction.setStoreSessionId(storeSession.getId());
        }
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        PosTransaction transaction = (PosTransaction)obj;
        if (StringUtils.isEmpty((String)transaction.getStoreSessionId())) {
            transaction.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        }
        super.saveOrUpdate(obj, s);
    }

    public List<PosTransaction> findUnauthorizedTransactions(User owner, String ticketOrServer, List<OrderType> selectedOrderTypes, Date transactionDate) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CAPTURED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PosTransaction.PROP_MARKED_CAPTURED), (Criterion)Restrictions.eq((String)PosTransaction.PROP_MARKED_CAPTURED, (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_AUTHORIZABLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PosTransaction.PROP_VOIDED), (Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE)));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            if (owner != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)owner.getId()));
            }
            this.addSearchCriteria(ticketOrServer, selectedOrderTypes, transactionDate, criteria);
            List list = criteria.list();
            return list;
        }
    }

    private void addSearchCriteria(String ticketOrServer, List<OrderType> selectedOrderTypes, Date transactionDate, Criteria criteria) {
        if (StringUtils.isNotBlank((String)ticketOrServer)) {
            Criterion ticketIdExp = Restrictions.ilike((String)("ticket." + Ticket.PROP_ID), (String)ticketOrServer, (MatchMode)MatchMode.START);
            DetachedCriteria userCriteria = DetachedCriteria.forClass(User.class);
            userCriteria.setProjection((Projection)Property.forName((String)User.PROP_ID));
            Criterion idExp = Restrictions.ilike((String)User.PROP_ID, (String)ticketOrServer, (MatchMode)MatchMode.ANYWHERE);
            Criterion firstNameExp = Restrictions.ilike((String)User.PROP_FIRST_NAME, (String)ticketOrServer, (MatchMode)MatchMode.ANYWHERE);
            Criterion lastNameExp = Restrictions.ilike((String)User.PROP_LAST_NAME, (String)ticketOrServer, (MatchMode)MatchMode.ANYWHERE);
            LogicalExpression nameExp = Restrictions.or((Criterion)idExp, (Criterion)Restrictions.or((Criterion)firstNameExp, (Criterion)lastNameExp));
            userCriteria.add((Criterion)nameExp);
            Criterion serverNameExp = Property.forName((String)PosTransaction.PROP_USER_ID).in(userCriteria);
            criteria.add((Criterion)Restrictions.or((Criterion)ticketIdExp, (Criterion)serverNameExp));
        }
        if (selectedOrderTypes != null) {
            ArrayList<String> orderTypeIds = new ArrayList<String>();
            for (OrderType orderType : selectedOrderTypes) {
                orderTypeIds.add(orderType.getId());
            }
            criteria.add(Restrictions.in((String)("ticket." + Ticket.PROP_ORDER_TYPE_ID), orderTypeIds));
        }
        if (transactionDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(transactionDate);
            Date startOfDay = DateUtil.startOfDay(calendar.getTime());
            Date endOfDay = DateUtil.endOfDay(calendar.getTime());
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)startOfDay, (Object)endOfDay));
        }
    }

    public Boolean hasUnauthorizedTransactions(User owner) {
        try (Session session = this.createNewSession();){
            Number rowCount;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CAPTURED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_MARKED_CAPTURED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_AUTHORIZABLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            if (owner != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)owner.getId()));
            }
            Boolean bl = (rowCount = (Number)criteria.uniqueResult()) != null && rowCount.intValue() > 0;
            return bl;
        }
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Class transactionClass, Date from, Date to, List<String> orderTypeIds) {
        return this.findTransactions(terminal, transactionClass, from, to, orderTypeIds, true);
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Class transactionClass, Date from, Date to, List<String> orderTypeIds, boolean excludeNullTicket) {
        return this.findTransactions(terminal, null, transactionClass, from, to, orderTypeIds, excludeNullTicket);
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Outlet outlet, Class transactionClass, Date from, Date to, List<String> orderTypeIds, boolean excludeNullTicket) {
        return this.findTransactions(terminal, outlet, transactionClass, from, to, orderTypeIds, excludeNullTicket, false);
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Outlet outlet, Class transactionClass, Date from, Date to, List<String> orderTypeIds, boolean excludeNullTicket, boolean withId) {
        return this.findTransactions(terminal, outlet, transactionClass, from, to, orderTypeIds, excludeNullTicket, withId, false);
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Outlet outlet, Class transactionClass, Date from, Date to, List<String> orderTypeIds, boolean excludeNullTicket, boolean withId, boolean excludeVoidTransactions) {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(transactionClass);
            criteria.createAlias("ticket", "t");
            if (excludeNullTicket) {
                criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            }
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if (!orderTypeIds.isEmpty()) {
                criteria.add(Restrictions.in((String)("t." + Ticket.PROP_ORDER_TYPE_ID), orderTypeIds));
            }
            if (outlet != null) {
                // empty if block
            }
            if (excludeVoidTransactions) {
                criteria.add(Restrictions.eqOrIsNull((String)PosTransaction.PROP_VOIDED, (Object)false));
            }
            if (from != null && to != null) {
                criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)from, (Object)to));
            }
            ProjectionList pList = Projections.projectionList();
            if (withId) {
                pList.add((Projection)Projections.property((String)PosTransaction.PROP_ID), PosTransaction.PROP_ID);
            }
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_TICKET), PosTransaction.PROP_TICKET);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_PAYMENT_TYPE_STRING), PosTransaction.PROP_PAYMENT_TYPE_STRING);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_CARD_TYPE), PosTransaction.PROP_CARD_TYPE);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_CARD_READER), PosTransaction.PROP_CARD_READER);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TIME), PosTransaction.PROP_TRANSACTION_TIME);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_USER_ID), PosTransaction.PROP_USER_ID);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_CARD_AUTH_CODE), PosTransaction.PROP_CARD_AUTH_CODE);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_TIPS_AMOUNT), PosTransaction.PROP_TIPS_AMOUNT);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_AMOUNT), PosTransaction.PROP_AMOUNT);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_TERMINAL_ID), PosTransaction.PROP_TERMINAL_ID);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TYPE), PosTransaction.PROP_TRANSACTION_TYPE);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_CUSTOM_PAYMENT_NAME), PosTransaction.PROP_CUSTOM_PAYMENT_NAME);
            pList.add((Projection)Projections.property((String)CustomerAccountTransaction.PROP_CUSTOMER_ID), CustomerAccountTransaction.PROP_CUSTOMER_ID);
            criteria.setProjection((Projection)pList);
            criteria.setResultTransformer(Transformers.aliasToBean(PosTransaction.class));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public TransactionSummary getTransactionSummary(Terminal terminal, Class transactionClass, Date from, Date to) {
        TransactionSummary summary = new TransactionSummary();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(transactionClass);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_DRAWER_RESETTED, (Object)Boolean.FALSE));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if (from != null && to != null) {
                criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)from));
                criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)to));
            }
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.count((String)PosTransaction.PROP_ID));
            projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
            projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            List list = criteria.list();
            if (list == null || list.size() == 0) {
                TransactionSummary transactionSummary = summary;
                return transactionSummary;
            }
            Object[] o = (Object[])list.get(0);
            int index = 0;
            summary.setCount(HibernateProjectionsUtil.getInt(o, index++));
            summary.setAmount(HibernateProjectionsUtil.getDouble(o, index++));
            summary.setTipsAmount(HibernateProjectionsUtil.getDouble(o, index++));
            TransactionSummary transactionSummary = summary;
            return transactionSummary;
        }
    }

    public List<PosTransaction> findTransactionListByGiftCardNumber(String giftCardNumber, Date fromDate, Date toDate) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(fromDate), (Object)DateUtil.endOfDay(toDate)));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_GIFT_CERT_NUMBER, (Object)giftCardNumber));
            List list = criteria.list();
            return list;
        }
    }

    public List<PosTransaction> findCapturedTransactions(User owner, String ticketOrServer, List<OrderType> selectedOrderTypes, Date transactionDate) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(CreditCardTransaction.class);
            criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CAPTURED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PosTransaction.PROP_VOIDED), (Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE)));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            if (owner != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)owner.getId()));
            }
            this.addSearchCriteria(ticketOrServer, selectedOrderTypes, transactionDate, criteria);
            List list = criteria.list();
            return list;
        }
    }

    public List<PosTransaction> getStoreSessionTransactions(StoreSession storeOperationData) {
        try (Session session = this.createNewSession();){
            List<String> cashDrawerIds = CashDrawerDAO.getInstance().getCashDrawerIds(storeOperationData);
            if (cashDrawerIds == null || cashDrawerIds.isEmpty()) {
                List<PosTransaction> list = null;
                return list;
            }
            Criteria criteria = session.createCriteria(this.getReferenceClass(), "t");
            criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
            criteria.add((Criterion)Restrictions.eq((String)"ticket.closed", (Object)true));
            criteria.add((Criterion)Restrictions.eq((String)"ticket.voided", (Object)false));
            criteria.add(Restrictions.in((String)PosTransaction.PROP_CASH_DRAWER_ID, cashDrawerIds));
            List list = criteria.list();
            return list;
        }
    }

    public void saveReversalTransaction(Ticket ticket, PosTransaction transaction, ReversalTransaction reversalTransaction) {
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            this.delete(transaction, session);
            this.saveOrUpdate(reversalTransaction, session);
            TicketDAO.getInstance().update(ticket, session);
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception x) {
                PosLog.error(PosTransactionService.class, x);
            }
            throw e;
        }
    }

    public List<PosTransaction> findCreditTransactions(Date fromDate, Date toDate, User user) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            List list;
            criteria = session.createCriteria(PosTransaction.class);
            criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate, (Object)toDate));
            this.addMultiUserFilter(user, criteria);
            ProjectionList pList = Projections.projectionList();
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_PAYMENT_TYPE_STRING), PosTransaction.PROP_PAYMENT_TYPE_STRING);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_CUSTOM_PAYMENT_NAME), PosTransaction.PROP_CUSTOM_PAYMENT_NAME);
            pList.add((Projection)Projections.property((String)("ticket." + Ticket.PROP_CASHIER_ID)), PosTransaction.PROP_USER_ID);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_ID), PosTransaction.PROP_ID);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TIME), PosTransaction.PROP_TRANSACTION_TIME);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_AMOUNT), PosTransaction.PROP_AMOUNT);
            pList.add((Projection)Projections.property((String)PosTransaction.PROP_TICKET), PosTransaction.PROP_TICKET);
            criteria.setProjection((Projection)pList);
            criteria.setResultTransformer(Transformers.aliasToBean(PosTransaction.class));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public List<PosTransaction> getCloudStoreSessionTransactions(StoreSession storeOperationData) {
        try (Session session = this.createNewSession();){
            List<String> cashDrawerIds = CashDrawerDAO.getInstance().getCashDrawerIds(storeOperationData);
            if (cashDrawerIds == null || cashDrawerIds.isEmpty()) {
                List<PosTransaction> list = null;
                return list;
            }
            Criteria criteria = session.createCriteria(this.getReferenceClass(), "t");
            criteria.add(Restrictions.in((String)PosTransaction.PROP_CASH_DRAWER_ID, cashDrawerIds));
            List list = criteria.list();
            return list;
        }
    }

    private void addMultiUserFilter(User user, Criteria criteria) {
        if (user != null) {
            PosLog.info(this.getClass(), Messages.getString("PosTransactionDAO.5") + user.getFullName() + Messages.getString("PosTransactionDAO.6") + user.getId());
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_CASHIER_ID), (Object)(user == null ? null : user.getId())));
            List<User> linkedUsers = user.getLinkedUser();
            if (linkedUsers != null) {
                for (User linkedUser : linkedUsers) {
                    if (linkedUser.getId().equals(user.getId())) continue;
                    PosLog.info(this.getClass(), Messages.getString("PosTransactionDAO.7") + linkedUser.getFullName() + Messages.getString("PosTransactionDAO.8") + linkedUser.getId());
                    disjunction.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_CASHIER_ID), (Object)linkedUser.getId()));
                }
            }
            criteria.add((Criterion)disjunction);
        }
    }

    public List<CustomerPaymentReportView.CustomerAccountTransactionItem> findCustomerAccountTransactions(Date fromDate, Date toDate, Customer customer) {
        try (Session session = this.createNewSession();){
            String hql = "select t.%s, t.%s, t.%s, t.%s, t.%s, t.%s, c.%s from PosTransaction as t, Customer as c where t.%s=c.%s and t.%s between :fromDate and :toDate";
            hql = String.format(hql, PosTransaction.PROP_ID, PosTransaction.PROP_TICKET, PosTransaction.PROP_TRANSACTION_TIME, PosTransaction.PROP_TIPS_AMOUNT, PosTransaction.PROP_AMOUNT, PosTransaction.PROP_CUSTOMER_ID, Customer.PROP_NAME, PosTransaction.PROP_CUSTOMER_ID, Customer.PROP_ID, PosTransaction.PROP_TRANSACTION_TIME);
            if (customer != null) {
                hql = hql + " and c.id= '" + customer.getId() + "'";
            }
            Query query = session.createQuery(hql);
            query.setTimestamp("fromDate", DateUtil.toUTC(fromDate));
            query.setTimestamp("toDate", DateUtil.toUTC(toDate));
            List list = query.list();
            ArrayList<CustomerPaymentReportView.CustomerAccountTransactionItem> items = new ArrayList<CustomerPaymentReportView.CustomerAccountTransactionItem>();
            for (Object[] object : list) {
                CustomerPaymentReportView.CustomerAccountTransactionItem accountTransactionItem = new CustomerPaymentReportView.CustomerAccountTransactionItem();
                accountTransactionItem.setTransactionNo(String.valueOf(object[0]));
                Ticket ticket = (Ticket)object[1];
                accountTransactionItem.setTicketNo(ticket.getId());
                accountTransactionItem.setDate((Date)object[2]);
                accountTransactionItem.setTips((double)((Double)object[3]));
                accountTransactionItem.setTotalAmount((double)((Double)object[4]));
                accountTransactionItem.setCustomerId(String.valueOf(object[5]));
                accountTransactionItem.setCustomerName(String.valueOf(object[6]));
                items.add(accountTransactionItem);
            }
            ArrayList<CustomerPaymentReportView.CustomerAccountTransactionItem> arrayList = items;
            return arrayList;
        }
    }

    public List<PosTransaction> findTransactionsForCashDrawer(String cashDrawerId, boolean voided) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass(), "t");
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CASH_DRAWER_ID, (Object)cashDrawerId));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)voided));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list = criteria.list();
            return list;
        }
    }

    public List<PosTransaction> findTransactionsForServer(String storeSessionId, String serverId) {
        return this.findTransactionsForServer(storeSessionId, serverId, null, null);
    }

    public List<PosTransaction> findTransactionsForServer(String storeSessionId, String serverId, Date from, Date to) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(PosTransaction.class);
            criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
            criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_OWNER_ID), (Object)serverId));
            this.updateCriteria(criteria, from, to);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list = criteria.list();
            return list;
        }
    }

    public List<String> getDistinctCardMmerchantGateway(String storeSessionId, Integer terminalId) {
        List gateways = null;
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)storeSessionId)) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)storeSessionId));
            }
            if (terminalId != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TERMINAL_ID, (Object)terminalId));
            }
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -7);
            criteria.add((Criterion)Restrictions.gt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)calendar.getTime()));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_CARD_MERCHANT_GATEWAY));
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)PosTransaction.PROP_CARD_MERCHANT_GATEWAY)));
            gateways = criteria.list();
        }
        return gateways;
    }

    public List<PosTransaction> findTransactionsForSession(String storeSessionId) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)storeSessionId));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list = criteria.list();
            return list;
        }
    }

    public String findLastTxPaymentTypeName(Ticket ticket) {
        if (StringUtils.isEmpty((String)ticket.getId())) {
            return null;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TICKET, (Object)ticket));
            criteria.addOrder(Order.desc((String)PosTransaction.PROP_TRANSACTION_TIME));
            criteria.setMaxResults(1);
            criteria.setProjection((Projection)Projections.property((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            String paymentTypeString = (String)criteria.uniqueResult();
            if (StringUtils.isNotEmpty((String)paymentTypeString)) {
                String string = PaymentType.valueOf(paymentTypeString).getDisplayString();
                return string;
            }
            String string = null;
            return string;
        }
    }

    public List<PosTransaction> getTransactionsByOutlet(Date from, Date to, Outlet outlet, Pagination pagination) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            if (pagination != null) {
                criteria.setFirstResult(pagination.getCurrentRowIndex());
                criteria.setMaxResults(pagination.getPageSize());
            }
            this.updateCriteria(criteria, from, to, outlet);
            List list = criteria.list();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            this.updateCriteria(criteria, from, to, outlet);
            if (pagination != null) {
                Number uniqueResult = (Number)criteria.uniqueResult();
                pagination.setNumRows(uniqueResult.intValue());
            }
            pagination.setRows(list);
            List list2 = list;
            return list2;
        }
    }

    private void updateCriteria(Criteria criteria, Date from, Date to) {
        this.updateCriteria(criteria, from, to, null);
    }

    private void updateCriteria(Criteria criteria, Date from, Date to, Outlet outlet) {
        if (from != null && to != null) {
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)from, (Object)to));
        }
        if (outlet != null) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_OUTLET_ID, (Object)outlet.getId()));
        }
    }

    public void savePosTransaction(PosTransaction transaction, List<PosTransaction> existingPosTransactions, Session session) {
        if (existingPosTransactions == null || existingPosTransactions.size() == 0) {
            return;
        }
        PosTransaction existingPosTransaction = null;
        int idx = existingPosTransactions.indexOf(transaction);
        if (idx != -1) {
            existingPosTransaction = existingPosTransactions.get(idx);
            if (existingPosTransaction == null) {
                this.save(transaction, session);
            } else {
                transaction.setVersion(existingPosTransaction.getVersion());
            }
        } else {
            this.save(transaction, session);
        }
    }

    public void saveOrUpdatePosTransactions(List<PosTransaction> posTransactions) {
        if (posTransactions == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (PosTransaction item : posTransactions) {
                PosTransaction existPosTransaction = this.get(item.getId());
                PaymentType paymentType = item.getPaymentType();
                if (existPosTransaction == null) {
                    existPosTransaction = paymentType.createTransaction();
                    PropertyUtils.copyProperties((Object)existPosTransaction, (Object)item);
                    this.save(existPosTransaction, session);
                    continue;
                }
                long version = existPosTransaction.getVersion();
                PropertyUtils.copyProperties((Object)existPosTransaction, (Object)item);
                existPosTransaction.setVersion(version);
                this.update(existPosTransaction, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            PosLog.error(this.getClass(), e);
        }
    }

    public void savePosTransactions(List<PosTransaction> transactions) throws Exception {
        if (transactions == null) {
            return;
        }
        for (PosTransaction posTransaction : transactions) {
            Transaction tx = null;
            try (Session session = null;){
                session = this.createNewSession();
                tx = session.beginTransaction();
                PaymentType paymentType = posTransaction.getPaymentType();
                PosTransaction existPosTransaction = this.get(posTransaction.getId());
                if (existPosTransaction == null) {
                    existPosTransaction = paymentType.createTransaction();
                    PropertyUtils.copyProperties((Object)existPosTransaction, (Object)posTransaction);
                    if (StringUtils.isEmpty((String)existPosTransaction.getStoreSessionId())) {
                        existPosTransaction.setStoreSessionId(DataProvider.get().getStoreSession().getId());
                    }
                    this.save(existPosTransaction, session);
                }
                tx.commit();
            }
        }
    }

    public double findTransactionsAmountByDate(Date date) {
        double netSales = 0.0;
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(PosTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date)));
            criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
            Object uniqueResult = criteria.uniqueResult();
            if (uniqueResult != null && uniqueResult instanceof Number) {
                netSales = ((Number)uniqueResult).doubleValue();
            }
            criteria = session.createCriteria(RefundTransaction.class);
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date)));
            criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
            uniqueResult = criteria.uniqueResult();
            if (uniqueResult != null && uniqueResult instanceof Number) {
                netSales -= ((Number)uniqueResult).doubleValue();
            }
            PosLog.info(this.getReferenceClass(), Messages.getString("PosTransactionDAO.0") + date + Messages.getString("PosTransactionDAO.14") + netSales);
            double d = NumberUtil.roundToTwoDigit(netSales);
            return d;
        }
    }

    private Double findTransactionsAmountByHour(Session session, Integer hourDuration, PaymentType paymentType) {
        try {
            Calendar calendar = Calendar.getInstance();
            Date toDate = calendar.getTime();
            calendar.add(10, -(hourDuration == null ? 24 : hourDuration));
            Date fromDate = calendar.getTime();
            Criteria creditCriteria = session.createCriteria(this.getReferenceClass());
            Criteria debitCriteria = session.createCriteria(this.getReferenceClass());
            creditCriteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            debitCriteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
            if (paymentType != null) {
                creditCriteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)paymentType.name()));
                debitCriteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)paymentType.name()));
            }
            creditCriteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate, (Object)toDate));
            debitCriteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate, (Object)toDate));
            creditCriteria.add(Restrictions.eqOrIsNull((String)PosTransaction.PROP_VOIDED, (Object)false));
            ProjectionList projections = Projections.projectionList();
            projections.add((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
            creditCriteria.setProjection((Projection)projections);
            debitCriteria.setProjection((Projection)projections);
            Number creditAmount = (Number)creditCriteria.uniqueResult();
            Number debitAmount = (Number)debitCriteria.uniqueResult();
            if (creditAmount == null) {
                creditAmount = 0.0;
            }
            if (debitAmount == null) {
                debitAmount = 0.0;
            }
            return creditAmount.doubleValue() - debitAmount.doubleValue();
        }
        catch (Exception e0) {
            PosLog.error(this.getReferenceClass(), e0);
            return 0.0;
        }
    }

    public Double findTotalTransactionsAmountByHour(Session session, Integer hourDuration) {
        return this.findTransactionsAmountByHour(session, hourDuration, null);
    }

    public Double findCashTransactionsAmountByHour(Session session, Integer hourDuration) {
        return this.findTransactionsAmountByHour(session, hourDuration, PaymentType.CASH);
    }

    public Double findCreditCardTransactionsAmountByHour(Session session, Integer hourDuration) {
        return this.findTransactionsAmountByHour(session, hourDuration, PaymentType.CREDIT_CARD);
    }

    public Map<Date, Double> findTransactionsAmntGroupByDate(Date fromDate, Date toDate) {
        try (Session session = this.createNewSession();){
            Map<Date, Double> map = this.findTransactionsAmntGroupByDate(fromDate, toDate, session);
            return map;
        }
    }

    public Map<Date, Double> findTransactionsAmntGroupByDate(Date fromDate, Date toDate, Session session) {
        try {
            Double amnt;
            Date date;
            Criteria creditCriteria = session.createCriteria(PosTransaction.class);
            Criteria debitCriteria = session.createCriteria(PosTransaction.class);
            creditCriteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            debitCriteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
            creditCriteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(fromDate), (Object)DateUtil.endOfDay(toDate)));
            debitCriteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(fromDate), (Object)DateUtil.endOfDay(toDate)));
            creditCriteria.add(Restrictions.eqOrIsNull((String)PosTransaction.PROP_VOIDED, (Object)false));
            ProjectionList projectionList = Projections.projectionList();
            Projection sqlGroupProjection = Projections.sqlGroupProjection((String)"date(transaction_time) as transaction_time, sum(amount) as amount", (String)"date(transaction_time)", (String[])new String[]{"transaction_time", "amount"}, (Type[])new Type[]{StandardBasicTypes.DATE, StandardBasicTypes.DOUBLE});
            projectionList.add(sqlGroupProjection);
            creditCriteria.setProjection((Projection)projectionList);
            debitCriteria.setProjection((Projection)projectionList);
            List creditList = creditCriteria.list();
            List debitList = debitCriteria.list();
            TreeMap<Date, Double> dateAmntMap = new TreeMap<Date, Double>(new Comparator<Date>(){

                @Override
                public int compare(Date date1, Date date2) {
                    return date1.compareTo(date2);
                }
            });
            if (creditList != null) {
                for (Object[] object : creditList) {
                    if (object == null || object[0] == null || object[1] == null) continue;
                    date = (Date)object[0];
                    amnt = (Double)object[1];
                    dateAmntMap.put(date, amnt);
                }
            }
            if (debitList != null) {
                for (Object[] object : debitList) {
                    if (object == null || object[0] == null || object[1] == null) continue;
                    date = (Date)object[0];
                    amnt = (Double)dateAmntMap.get(date);
                    if (amnt == null) {
                        amnt = 0.0;
                    }
                    amnt = amnt - (Double)object[1];
                    dateAmntMap.put(date, amnt);
                }
            }
            return dateAmntMap;
        }
        catch (Exception e0) {
            PosLog.error(this.getReferenceClass(), e0);
            return null;
        }
    }

    public Map<PaymentType, PosTransaction> findAmountByPaymentTypes(Session session, Date fromDate, Date toDate, Integer maxResult) {
        HashMap<PaymentType, PosTransaction> userTransactionMap = new HashMap<PaymentType, PosTransaction>();
        try {
            Criteria criteria = session.createCriteria(PosTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add(Restrictions.eqOrIsNull((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate, (Object)toDate));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.groupProperty((String)PosTransaction.PROP_PAYMENT_TYPE_STRING), PosTransaction.PROP_PAYMENT_TYPE_STRING);
            projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT), PosTransaction.PROP_AMOUNT);
            criteria.setProjection((Projection)projectionList);
            criteria.setMaxResults(maxResult == null ? 10 : maxResult);
            criteria.addOrder(Order.desc((String)PosTransaction.PROP_AMOUNT));
            criteria.setResultTransformer(Transformers.aliasToBean(PosTransaction.class));
            List transactions = criteria.list();
            if (transactions != null) {
                transactions.forEach(transaction -> userTransactionMap.put(transaction.getPaymentType(), (PosTransaction)transaction));
            }
        }
        catch (Exception e0) {
            PosLog.error(this.getReferenceClass(), e0);
        }
        return userTransactionMap;
    }

    public static Disjunction createMasterCardSearchCriteria() {
        SimpleExpression masterCard = Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.MASTER_CARD.name()).ignoreCase();
        SimpleExpression masterCard_ = Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.MASTER_CARD.name().replaceAll("_", "")).ignoreCase();
        SimpleExpression masterCardSpace = Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.MASTER_CARD.name().replaceAll("_", " ")).ignoreCase();
        return Restrictions.or((Criterion[])new Criterion[]{masterCard, masterCard_, masterCardSpace});
    }

    public static Disjunction createAmexOrAmericanExpCardSearchCriteria() {
        SimpleExpression americanExpress = Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.AMERICAN_EXPRESS.name()).ignoreCase();
        SimpleExpression americanExpress_ = Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.AMERICAN_EXPRESS.name().replaceAll("_", "")).ignoreCase();
        SimpleExpression americanExprSpace = Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.AMERICAN_EXPRESS.name().replaceAll("_", " ")).ignoreCase();
        SimpleExpression amex = Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)"AMEX").ignoreCase();
        return Restrictions.or((Criterion[])new Criterion[]{americanExpress, americanExpress_, americanExprSpace, amex});
    }

    public List<EndOfDayReportData> findEndOfDayReportData(Date fromDate, Date toDate, List<OrderType> orderTypes, Boolean sortByMemberName, Boolean sortByTicketId, Boolean sortByTicketDate, Boolean sortByCustomerLastName, Boolean sortByMemberId, Boolean isShowInGroup) {
        HashMap<String, Customer> mamberIdMap = new HashMap<String, Customer>();
        List<String> orderTypeIds = POSUtil.getStringIds(orderTypes, OrderType.class);
        try (Session session = this.createNewSession();){
            HashSet<Ticket> ticketList = new HashSet<Ticket>();
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add(Restrictions.between((String)Ticket.PROP_CREATE_DATE, (Object)fromDate, (Object)toDate));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            if (!orderTypeIds.isEmpty()) {
                criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, orderTypeIds));
            }
            ProjectionList pList = Projections.projectionList();
            pList.add((Projection)Projections.property((String)Ticket.PROP_ID), Ticket.PROP_ID);
            criteria.setProjection((Projection)pList);
            criteria.setResultTransformer(Transformers.aliasToBean(Ticket.class));
            List ticketSearchResults = criteria.list();
            for (Object ticket : ticketSearchResults) {
                Ticket fullTicket = TicketDAO.getInstance().loadFullTicket(((BaseTicket)ticket).getId(), session);
                List<TicketItem> ticketItems = fullTicket.getTicketItems();
                Iterator<TicketItem> iterator = ticketItems.iterator();
                while (iterator.hasNext()) {
                    TicketItem ticketItem = iterator.next();
                    if (!ticketItem.isReturned() || DateUtil.between(fromDate, toDate, ticketItem.getCreateDate())) continue;
                    iterator.remove();
                }
                fullTicket.calculatePrice();
                ticketList.add(fullTicket);
            }
            criteria = session.createCriteria(RefundTransaction.class);
            criteria.createAlias("ticket", "t");
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate, (Object)toDate));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
            if (!orderTypeIds.isEmpty()) {
                criteria.add(Restrictions.in((String)("t." + Ticket.PROP_ORDER_TYPE_ID), orderTypeIds));
            }
            pList = Projections.projectionList();
            pList.add((Projection)Projections.property((String)("t." + Ticket.PROP_ID)), Ticket.PROP_ID);
            criteria.setProjection((Projection)pList);
            criteria.setResultTransformer(Transformers.aliasToBean(Ticket.class));
            List transactionSearchResults = criteria.list();
            for (Object ticket : transactionSearchResults) {
                if (ticketList.contains(ticket)) continue;
                Ticket fullTicket = TicketDAO.getInstance().loadFullTicket(((BaseTicket)ticket).getId(), session);
                List<TicketItem> ticketItems = fullTicket.getTicketItems();
                Iterator<TicketItem> iterator = ticketItems.iterator();
                while (iterator.hasNext()) {
                    TicketItem ticketItem = iterator.next();
                    if (ticketItem.isReturned()) continue;
                    iterator.remove();
                }
                fullTicket.calculatePrice();
                ticketList.add(fullTicket);
            }
            ArrayList<EndOfDayReportData> dataList = new ArrayList<EndOfDayReportData>();
            for (Ticket ticket : ticketList) {
                EndOfDayReportData tData = new EndOfDayReportData();
                boolean isShowGratuty = Boolean.FALSE;
                Set<PosTransaction> transactions = ticket.getTransactions();
                Iterator<PosTransaction> iterator = transactions.iterator();
                while (iterator.hasNext()) {
                    PosTransaction posTransaction = iterator.next();
                    if (posTransaction.isVoided().booleanValue()) continue;
                    if (posTransaction instanceof RefundTransaction) {
                        Date transactionTime = posTransaction.getTransactionTime();
                        if (transactionTime.compareTo(fromDate) < 0 || transactionTime.compareTo(toDate) > 0) {
                            iterator.remove();
                            continue;
                        }
                        tData.setRefundPaymentCredit(-1.0 * posTransaction.getAmount() + tData.getRefundPaymentCredit());
                        continue;
                    }
                    posTransaction.setTransactionTime(ticket.getCreateDate());
                    if (posTransaction.getTransactionTime().compareTo(fromDate) < 0 || posTransaction.getTransactionTime().compareTo(toDate) > 0) {
                        iterator.remove();
                        continue;
                    }
                    if (posTransaction.getPaymentType() == PaymentType.CASH) {
                        tData.setCashPaymentCredit(posTransaction.getAmount() + tData.getCashPaymentCredit());
                    } else if (posTransaction.getPaymentType() == PaymentType.CREDIT_CARD) {
                        tData.setCreditCardPaymentCredit(posTransaction.getAmount() + tData.getCreditCardPaymentCredit());
                    } else if (posTransaction.getPaymentType() == PaymentType.MEMBER_ACCOUNT) {
                        tData.setMemberChargeCredit(posTransaction.getAmount() + tData.getMemberChargeCredit());
                    } else {
                        tData.setOthersPaymentCredit(posTransaction.getAmount() + tData.getOthersPaymentCredit());
                    }
                    isShowGratuty = Boolean.TRUE;
                }
                String customerId = ticket.getCustomerId();
                Customer customer = this.getCustomerFromMap(customerId, mamberIdMap);
                tData.setEmployeeId(ticket.getOwnerId());
                tData.setCustomerId(customerId);
                tData.setCustomerName(ticket.getCustomerName());
                if (customer != null) {
                    tData.setMemberId(customer.getMemberId());
                    tData.setMemberLastName("");
                }
                tData.setTicketId(ticket.getId());
                tData.setNetAmount(ticket.getSubtotalAmount());
                tData.setTaxAmount(ticket.getTaxAmount());
                tData.setServiceCharge(ticket.getServiceCharge());
                tData.setDiscount(ticket.getDiscountAmount());
                tData.setTotalTicketAmount(ticket.getTotalAmount());
                if (isShowGratuty) {
                    tData.setGratuityAmount(ticket.getGratuityAmount());
                }
                tData.setGuestCount(ticket.getNumberOfGuests());
                tData.setTicketCreateDate(ticket.getCreateDate());
                dataList.add(tData);
            }
            Comparator<EndOfDayReportData> comparatorEmployeeName = Comparator.comparing(EndOfDayReportData::getEmployeeName, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
            Comparator<EndOfDayReportData> comparatorEmployeeRole = Comparator.comparing(EndOfDayReportData::getEmployeeRole, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
            Comparator<EndOfDayReportData> comparatorMemberName = Comparator.comparing(EndOfDayReportData::getCustomerName, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
            Comparator<EndOfDayReportData> comparatorTicketId = Comparator.comparing(EndOfDayReportData::getTicketId, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
            Comparator<EndOfDayReportData> comparatorTicketDate = Comparator.comparing(EndOfDayReportData::getTicketCreateDate, Comparator.nullsLast(Comparator.naturalOrder()));
            Comparator<EndOfDayReportData> comparatorMemberId = Comparator.comparing(EndOfDayReportData::getMemberId, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
            Comparator<EndOfDayReportData> comparatorMemberLastName = Comparator.comparing(EndOfDayReportData::getMemberLastName, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
            ArrayList<Comparator<EndOfDayReportData>> sortList = new ArrayList<Comparator<EndOfDayReportData>>();
            if (sortByMemberId.booleanValue()) {
                sortList.add(comparatorMemberId);
            }
            if (sortByMemberName.booleanValue()) {
                sortList.add(comparatorMemberName);
            }
            if (sortByCustomerLastName.booleanValue()) {
                sortList.add(comparatorMemberLastName);
            }
            if (sortByTicketId.booleanValue()) {
                sortList.add(comparatorTicketId);
            }
            if (sortByTicketDate.booleanValue()) {
                sortList.add(comparatorTicketDate);
            }
            if (sortList != null) {
                int sortCount = sortList.size();
                switch (sortCount) {
                    case 0: {
                        if (isShowInGroup.booleanValue()) break;
                        Collections.sort(dataList, comparatorEmployeeName.thenComparing(comparatorEmployeeRole));
                        break;
                    }
                    case 1: {
                        if (isShowInGroup.booleanValue()) {
                            Collections.sort(dataList, (Comparator)sortList.get(0));
                            break;
                        }
                        Collections.sort(dataList, comparatorEmployeeName.thenComparing(comparatorEmployeeRole).thenComparing((Comparator)sortList.get(0)));
                        break;
                    }
                    case 2: {
                        if (isShowInGroup.booleanValue()) {
                            Collections.sort(dataList, ((Comparator)sortList.get(0)).thenComparing((Comparator)sortList.get(1)));
                            break;
                        }
                        Collections.sort(dataList, comparatorEmployeeName.thenComparing(comparatorEmployeeRole).thenComparing((Comparator)sortList.get(0)).thenComparing((Comparator)sortList.get(1)));
                        break;
                    }
                    case 3: {
                        if (isShowInGroup.booleanValue()) {
                            Collections.sort(dataList, ((Comparator)sortList.get(0)).thenComparing((Comparator)sortList.get(1)).thenComparing((Comparator)sortList.get(2)));
                            break;
                        }
                        Collections.sort(dataList, comparatorEmployeeName.thenComparing(comparatorEmployeeRole).thenComparing((Comparator)sortList.get(0)).thenComparing((Comparator)sortList.get(1)).thenComparing((Comparator)sortList.get(2)));
                        break;
                    }
                    case 4: {
                        if (isShowInGroup.booleanValue()) {
                            Collections.sort(dataList, ((Comparator)sortList.get(0)).thenComparing((Comparator)sortList.get(1)).thenComparing((Comparator)sortList.get(2)).thenComparing((Comparator)sortList.get(3)));
                            break;
                        }
                        Collections.sort(dataList, comparatorEmployeeName.thenComparing(comparatorEmployeeRole).thenComparing((Comparator)sortList.get(0)).thenComparing((Comparator)sortList.get(1)).thenComparing((Comparator)sortList.get(2)).thenComparing((Comparator)sortList.get(3)));
                        break;
                    }
                    case 5: {
                        if (isShowInGroup.booleanValue()) {
                            Collections.sort(dataList, ((Comparator)sortList.get(0)).thenComparing((Comparator)sortList.get(1)).thenComparing((Comparator)sortList.get(2)).thenComparing((Comparator)sortList.get(3)).thenComparing((Comparator)sortList.get(4)));
                            break;
                        }
                        Collections.sort(dataList, comparatorEmployeeName.thenComparing(comparatorEmployeeRole).thenComparing((Comparator)sortList.get(0)).thenComparing((Comparator)sortList.get(1)).thenComparing((Comparator)sortList.get(2)).thenComparing((Comparator)sortList.get(3)).thenComparing((Comparator)sortList.get(4)));
                        break;
                    }
                    default: {
                        Collections.sort(dataList, comparatorEmployeeName.thenComparing(comparatorEmployeeRole));
                    }
                }
            }
            ArrayList<EndOfDayReportData> arrayList = dataList;
            return arrayList;
        }
    }

    private Customer getCustomerFromMap(String customerId, Map<String, Customer> mamberIdMap) {
        if (StringUtils.isBlank((String)customerId)) {
            return null;
        }
        Customer customer = mamberIdMap.get(customerId);
        if (customer == null && (customer = CustomerDAO.getInstance().get(customerId)) != null) {
            mamberIdMap.put(customerId, customer);
        }
        return customer;
    }

    public static CashDrawer populateCashDrawerReportSummary(List<CashDrawer> reportList) {
        CashDrawer cashDrawersReportSummary = new CashDrawer();
        if (reportList != null) {
            for (CashDrawer report : reportList) {
                cashDrawersReportSummary.setBeginCash(cashDrawersReportSummary.getBeginCash() + report.getBeginCash());
            }
        }
        return cashDrawersReportSummary;
    }

    public List<PosTransaction> findUnSyncedCreditBookTransactions(String memberId) {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CREDIT_BOOK.name()));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
            if (!POSUtil.isBlankOrNull(memberId)) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CUSTOMER_ID, (Object)memberId));
            }
            List list2 = list = criteria.list();
            return list2;
        }
    }
}

