/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.dao.BasePurchaseOrderDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.PurchaseOrderItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.services.InventoryService;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class PurchaseOrderDAO
extends BasePurchaseOrderDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveOrUpdate(PurchaseOrder order, boolean updateStock) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.saveOrUpdate(order, updateStock, session);
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveOrUpdateWithItemAvailBalance(PurchaseOrder order) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.updateAvailableUnit(order, session);
            tx.commit();
        }
    }

    private void updateAvailableUnit(PurchaseOrder purchaseOrder, Session session) {
        List<PurchaseOrderItem> orderItems = purchaseOrder.getOrderItems();
        if (orderItems == null) {
            return;
        }
        for (PurchaseOrderItem purchaseOrderItem : orderItems) {
            MenuItem menuItem = purchaseOrderItem.getMenuItem();
            Double quantityToReceive = purchaseOrderItem.getItemQuantity();
            MenuItemDAO.getInstance().updateStockQuantity(menuItem.getId(), quantityToReceive, true, false, session);
        }
        session.saveOrUpdate((Object)purchaseOrder);
    }

    public void saveOrUpdate(PurchaseOrder order, boolean updateStock, Session session) {
        if (order.getId() == null) {
            order.setCreatedDate(new Date());
            order.setStatus(0);
        }
        if (updateStock) {
            this.adjustInventoryItems(session, order);
        }
        session.saveOrUpdate((Object)order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdate(PurchaseOrder order, boolean updateStock, boolean isAvailableUnitUpdate) {
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            if (order.getId() == null) {
                if (order.getCreatedDate() == null) {
                    order.setCreatedDate(new Date());
                }
                order.setStatus(0);
            }
            if (updateStock) {
                List<PurchaseOrderItem> orderItems = order.getOrderItems();
                if (orderItems != null) {
                    HashMap itemMap = new HashMap();
                    orderItems.forEach(orderItem -> {
                        MenuItem menuItem = (MenuItem)itemMap.get(orderItem.getMenuItemId());
                        if (menuItem == null && (menuItem = MenuItemDAO.getInstance().get(orderItem.getMenuItemId(), session)) != null) {
                            MenuItemDAO.getInstance().initialize(menuItem, session);
                            itemMap.put(menuItem.getId(), menuItem);
                        }
                        orderItem.setMenuItem(menuItem);
                        String selectedUnitID = orderItem.getItemUnitName();
                        IUnit iUnit = DataProvider.get().getUnitByCode(selectedUnitID);
                        InventoryUnit selectedUnit = null;
                        if (iUnit instanceof InventoryUnit) {
                            selectedUnit = (InventoryUnit)iUnit;
                        }
                        InventoryService.getInstance().adjustMenuItemCost(menuItem, orderItem.getUnitPrice(), orderItem.getItemQuantity(), selectedUnit, session);
                        MenuItemDAO.getInstance().saveOrUpdate(menuItem, session);
                    });
                }
                this.adjustInventoryItems(session, order, isAvailableUnitUpdate);
            }
            session.saveOrUpdate((Object)order);
            tx.commit();
        }
    }

    private void adjustInventoryItems(Session session, PurchaseOrder order) {
        this.adjustInventoryItems(session, order, true);
    }

    private void adjustInventoryItems(Session session, PurchaseOrder order, boolean isAvailableUnitUpdate) {
        List<PurchaseOrderItem> orderItems = order.getOrderItems();
        if (orderItems == null) {
            return;
        }
        boolean fullyReceived = true;
        for (PurchaseOrderItem orderItem : orderItems) {
            orderItem.setQuantityReceived(orderItem.getQuantityReceived() + orderItem.getQuantityToReceive());
            InventoryTransaction stockInTrans = new InventoryTransaction();
            MenuItem menuItem = orderItem.getMenuItem();
            stockInTrans.setMenuItem(menuItem);
            stockInTrans.setQuantity(orderItem.getQuantityToReceive());
            Double unitPrice = orderItem.getUnitPrice();
            stockInTrans.setUnitCost(unitPrice);
            stockInTrans.setToInventoryLocation(order.getInventoryLocation());
            stockInTrans.setTransactionDate(order.getReceivingDate());
            stockInTrans.setVendor(order.getVendor());
            stockInTrans.setUnit(orderItem.getItemUnitName());
            stockInTrans.setTotal(stockInTrans.getQuantity() * unitPrice);
            if (order.getType().equals(PurchaseOrder.DEBIT)) {
                stockInTrans.setReason("PURCHASE");
                stockInTrans.setTransactionType(InventoryTransactionType.IN);
            } else {
                stockInTrans.setReason("RETURN");
                stockInTrans.setTransactionType(InventoryTransactionType.OUT);
            }
            InventoryTransactionDAO.getInstance().adjustInventoryStock(stockInTrans, session, isAvailableUnitUpdate, true);
            if (orderItem.getQuantityReceived().doubleValue() != orderItem.getItemQuantity().doubleValue()) {
                fullyReceived = false;
            }
            orderItem.setQuantityToReceive(0.0);
        }
        if (fullyReceived) {
            order.setStatus(4);
        } else {
            order.setStatus(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextOrderSequenceNumber() {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)PurchaseOrder.PROP_ORDER_ID));
            Object maxNumber = criteria.uniqueResult();
            if (maxNumber == null) {
                String string = "10001";
                return string;
            }
            String string = String.valueOf(Integer.parseInt((String)maxNumber) + 1);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PurchaseOrder> findBy(String poNumber, InventoryVendor vendor, Date from, Date to, Boolean showClosed) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)poNumber)) {
                criteria.add(Restrictions.ilike((String)PurchaseOrder.PROP_ORDER_ID, (String)poNumber.trim(), (MatchMode)MatchMode.START));
            }
            if (vendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)PurchaseOrder.PROP_VENDOR, (Object)vendor));
            }
            if (from != null && to != null) {
                criteria.add((Criterion)Restrictions.ge((String)PurchaseOrder.PROP_CREATED_DATE, (Object)from));
                criteria.add((Criterion)Restrictions.le((String)PurchaseOrder.PROP_CREATED_DATE, (Object)to));
            }
            if (!showClosed.booleanValue()) {
                criteria.add((Criterion)Restrictions.ne((String)PurchaseOrder.PROP_STATUS, (Object)4));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)PurchaseOrder.PROP_STATUS, (Object)4));
            }
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdatePurchaseOrders(List<PurchaseOrder> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (PurchaseOrder item : dataList) {
                List<PurchaseOrderItem> items = item.getOrderItems();
                item.setOrderItems(null);
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                PurchaseOrderDAO dao = PurchaseOrderDAO.getInstance();
                PurchaseOrder existingItem = dao.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getId() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    item.setVersion(version);
                } else {
                    this.save(item, session);
                }
                List<PurchaseOrderItem> existingItems = null;
                if (existingItem != null && existingItem.getOrderItems() != null) {
                    existingItems = existingItem.getOrderItems();
                }
                if (existingItems == null) {
                    existingItems = new ArrayList<PurchaseOrderItem>();
                }
                if (items != null && items.size() > 0) {
                    for (PurchaseOrderItem purchaseOrderItem : items) {
                        purchaseOrderItem.setPurchaseOrder(item);
                        int idx = existingItems.indexOf(purchaseOrderItem);
                        PurchaseOrderItem existingPurchaseOrderItem = null;
                        if (idx != -1) {
                            existingPurchaseOrderItem = existingItems.get(idx);
                            if (existingPurchaseOrderItem == null) {
                                purchaseOrderItem.setVersion(0L);
                                PurchaseOrderItemDAO.getInstance().save(purchaseOrderItem, session);
                                continue;
                            }
                            purchaseOrderItem.setVersion(existingPurchaseOrderItem.getVersion());
                            continue;
                        }
                        purchaseOrderItem.setVersion(0L);
                        PurchaseOrderItemDAO.getInstance().save(purchaseOrderItem, session);
                    }
                }
                item.setOrderItems(items);
                this.saveOrUpdate(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }

    public List<PurchaseOrder> getPurchaseOrderByInvLocation(InventoryLocation inventoryLocation, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)PurchaseOrder.PROP_INVENTORY_LOCATION, (Object)inventoryLocation));
        criteria.add((Criterion)Restrictions.ne((String)PurchaseOrder.PROP_STATUS, (Object)4));
        criteria.setProjection(Projections.alias((Projection)Projections.property((String)PurchaseOrder.PROP_ID), (String)PurchaseOrder.PROP_ID));
        return criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
    }
}

