/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.util.JsonUtil;
import com.floreantpos.util.ShiftUtil;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class ReservationDAO {
    private static final ReservationDAO instance = new ReservationDAO();
    private TicketDAO ticketDAO = TicketDAO.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findReservations(PaginatedTableModel<?> tableModel, Date start, Date end, String customerId, SalesArea salesArea, boolean isClosed) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.ticketDAO.createNewSession();
            criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)isClosed));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TYPE, (Object)TicketType.RESERVATION.getTypeNo()));
            if (start != null) {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_DELIVERY_DATE, (Object)DateUtil.startOfDay(start)));
            }
            if (end != null) {
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_DELIVERY_DATE, (Object)DateUtil.endOfDay(end)));
            }
            if (StringUtils.isNotEmpty((String)customerId)) {
                criteria.add(Restrictions.ilike((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            }
            if (salesArea != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_SALES_AREA_ID, (Object)salesArea.getId()));
            }
            tableModel.setNumRows(this.ticketDAO.rowCount(criteria));
            criteria.addOrder(Order.desc((String)Ticket.PROP_CREATE_DATE));
            this.setTicketProjections(criteria);
            criteria.setFirstResult(tableModel.getCurrentRowIndex());
            criteria.setMaxResults(tableModel.getPageSize());
            List tickets = criteria.list();
            tableModel.setRows(tickets);
        }
        finally {
            this.ticketDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addFromJSON(String jsonString) throws Exception {
        Session session = null;
        Transaction tx = null;
        int count = 0;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            count = this.addFromJSON(jsonString, session);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
        }
        finally {
            TicketDAO.getInstance().closeSession(session);
        }
        return count;
    }

    public int addFromJSON(String jsonString, Session session) throws Exception {
        if (StringUtils.isEmpty((String)jsonString)) {
            return -1;
        }
        JsonReader reader = Json.createReader((Reader)new StringReader(jsonString));
        JsonArray jsonArray = reader.readArray();
        int count = 0;
        Store store = StoreDAO.getRestaurant();
        for (JsonObject orderObject : jsonArray) {
            String orderId = JsonUtil.getString(orderObject, "id");
            if (StringUtils.isNotEmpty((String)orderId) && TicketDAO.getInstance().hasTicketByReservationId(orderId)) continue;
            JsonObject customerObject = (JsonObject)orderObject.get((Object)"member");
            String customerId = customerObject.getString("id");
            String memberId = customerObject.getString("sfId");
            Customer customer = CustomerDAO.getInstance().findById(customerId);
            if (customer == null) {
                String customerName = customerObject.getString("name");
                customer = new Customer();
                String[] customerFullName = customerName.split(" ");
                customer.setId(memberId);
                customer.setMemberId(customerId);
                customer.setFirstName(customerFullName[0].trim());
                customer.setLastName(customerFullName[customerFullName.length - 1].trim());
                customer.setName(customerName);
                CustomerDAO.getInstance().save(customer, session);
            }
            String deliveryDateStr = JsonUtil.getStringValue((JsonValue)orderObject.get((Object)"reservationDate"));
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            Date deliveryDate = null;
            try {
                deliveryDate = formatter.parse(deliveryDateStr);
            }
            catch (Exception e) {
                formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                deliveryDate = formatter.parse(deliveryDateStr.replaceAll("Z$", ""));
            }
            Ticket ticket = TicketDAO.getInstance().findByCustomerAndDeliveryDate(customerId, deliveryDate);
            String mergeOption = store.getProperty("Reservation.Merge_If_Same_Member", "true");
            if (Boolean.valueOf(mergeOption).booleanValue() && ticket != null) {
                TicketDAO.getInstance().loadFullTicket(ticket);
                this.setTicketItemsFromJson(orderObject, ticket, session);
            } else {
                User user;
                ticket = new Ticket(true);
                ticket.setId(orderId);
                ticket.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
                ticket.setTerminal(DataProvider.get().getCurrentTerminal());
                ticket.setShift(ShiftUtil.getCurrentShift());
                ticket.setTicketType(TicketType.RESERVATION);
                ticket.setCreateDate(new Date());
                ticket.setPaid(false);
                String loggedInUser = store.getProperty("Reservation.Logged_In_User_As_Owner", "true");
                String defaultOwnerId = store.getProperty("Reservation.owner");
                String defaultOrderType = store.getProperty("Reservation.ordertype");
                String defaultSalesArea = store.getProperty("Reservation.Default_Sales_Area");
                if (Boolean.valueOf(loggedInUser).booleanValue() && Application.getCurrentUser() != null) {
                    ticket.setOwner(Application.getCurrentUser());
                } else if (StringUtils.isNotEmpty((String)defaultOwnerId)) {
                    user = UserDAO.getInstance().get(defaultOwnerId);
                    ticket.setOwner(user);
                } else {
                    user = UserDAO.getInstance().getRandomUser();
                    ticket.setOwner(user);
                }
                if (StringUtils.isNotEmpty((String)defaultOrderType)) {
                    OrderType orderType = OrderTypeDAO.getInstance().get(defaultOrderType);
                    ticket.setOrderType(orderType);
                } else {
                    ticket.setOrderType(Application.getInstance().getOrderTypes().get(0));
                }
                if (StringUtils.isNotEmpty((String)defaultSalesArea)) {
                    ticket.setSalesAreaId(defaultSalesArea);
                } else {
                    this.setSalesArea(orderObject, ticket, session);
                }
                ticket.setCustomer(customer);
                ticket.setDeliveryDate(deliveryDate);
                TicketDAO.getInstance().save(ticket, session);
                this.setTicketItemsFromJson(orderObject, ticket, session);
            }
            ticket.calculatePrice();
            TicketDAO.getInstance().update(ticket, session);
            ++count;
        }
        return count;
    }

    private void setSalesArea(JsonObject orderObject, Ticket ticket, Session session) {
        if (!orderObject.containsKey((Object)"salesArea")) {
            return;
        }
        JsonObject salesAreaObject = (JsonObject)orderObject.get((Object)"salesArea");
        String salesAreaId = salesAreaObject.getString("id");
        SalesArea salesArea = SalesAreaDAO.getInstance().findById(salesAreaId);
        if (salesArea == null) {
            salesArea = new SalesArea();
            salesArea.setId(salesAreaId);
            salesArea.setName(salesAreaObject.getString("name"));
            SalesAreaDAO.getInstance().save(salesArea, session);
        }
        ticket.setSalesArea(salesArea);
    }

    private void setTicketItemsFromJson(JsonObject orderObject, Ticket ticket, Session session) {
        JsonArray ticketItemArray = (JsonArray)orderObject.get((Object)"items");
        for (JsonObject ticketItemObject : ticketItemArray) {
            TicketItem ticketItem;
            String menuItemId = ticketItemObject.getString("id");
            MenuItem menuItem = MenuItemDAO.getInstance().get(menuItemId);
            String ticketItemName = ticketItemObject.getString("name");
            double ticketItemUnitPrice = JsonUtil.getDoubleValue((JsonValue)ticketItemObject.get((Object)"unitPrice"));
            double ticketItemQuantity = JsonUtil.getDoubleValue((JsonValue)ticketItemObject.get((Object)"quantity"));
            if (menuItem != null) {
                ticketItem = menuItem.convertToTicketItem(ticket, ticketItemQuantity);
                ticketItem.setTicket(ticket);
                ticket.addToticketItems(ticketItem);
                continue;
            }
            ticketItem = new TicketItem();
            ticketItem.setMenuItemId(menuItemId);
            ticketItem.setName(ticketItemName);
            ticketItem.setQuantity(ticketItemQuantity);
            ticketItem.setUnitPrice(ticketItemUnitPrice);
            ticketItem.setTicket(ticket);
            ticket.addToticketItems(ticketItem);
        }
    }

    private void setTicketProjections(Criteria criteria) {
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)Ticket.PROP_ID), Ticket.PROP_ID);
        projectionList.add((Projection)Projections.property((String)Ticket.PROP_CLOSED), Ticket.PROP_CLOSED);
        projectionList.add((Projection)Projections.property((String)Ticket.PROP_TYPE), Ticket.PROP_TYPE);
        projectionList.add((Projection)Projections.property((String)Ticket.PROP_ORDER_TYPE_ID), Ticket.PROP_ORDER_TYPE_ID);
        projectionList.add((Projection)Projections.property((String)Ticket.PROP_CREATE_DATE), Ticket.PROP_CREATE_DATE);
        projectionList.add((Projection)Projections.property((String)Ticket.PROP_DELIVERY_DATE), Ticket.PROP_DELIVERY_DATE);
        projectionList.add((Projection)Projections.property((String)Ticket.PROP_CUSTOMER_ID), Ticket.PROP_CUSTOMER_ID);
        projectionList.add((Projection)Projections.property((String)Ticket.PROP_SALES_AREA_ID), Ticket.PROP_SALES_AREA_ID);
        projectionList.add((Projection)Projections.property((String)Ticket.PROP_SUBTOTAL_AMOUNT), Ticket.PROP_SUBTOTAL_AMOUNT);
        projectionList.add((Projection)Projections.property((String)Ticket.PROP_TAX_AMOUNT), Ticket.PROP_TAX_AMOUNT);
        projectionList.add((Projection)Projections.property((String)Ticket.PROP_TOTAL_AMOUNT), Ticket.PROP_TOTAL_AMOUNT);
        criteria.setProjection((Projection)projectionList);
        criteria.setResultTransformer(Transformers.aliasToBean(Ticket.class));
    }

    private Session createNewSession() {
        return this.ticketDAO.createNewSession();
    }

    public static ReservationDAO getInstance() {
        return instance;
    }
}

