/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.BaseTaxDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class TaxDAO
extends BaseTaxDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    protected void delete(Object obj, Session session) {
        Tax tax = (Tax)obj;
        if (tax == null) {
            throw new PosException(Messages.getString("TaxDAO.0"));
        }
        tax.setDeleted(true);
        this.update(tax, session);
        this.deleteTaxFromTaxGroup(tax, session);
    }

    @Override
    public List<Tax> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)Tax.PROP_NAME));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public void deleteTaxFromTaxGroup(Tax tax) {
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.deleteTaxFromTaxGroup(tax, session);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void deleteTaxFromTaxGroup(Tax tax, Session session) {
        Criteria criteria = session.createCriteria(TaxGroup.class);
        this.addDeletedFilter(criteria);
        criteria.createAlias("taxes", "tax");
        criteria.add((Criterion)Restrictions.eq((String)("tax." + Tax.PROP_ID), (Object)tax.getId()));
        List taxGroups = criteria.list();
        if (taxGroups == null || taxGroups.isEmpty()) {
            return;
        }
        for (TaxGroup taxGroup : taxGroups) {
            taxGroup.getTaxes().remove(tax);
            this.update(taxGroup, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tax findByTaxRate(double taxRate) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(Tax.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Tax.PROP_RATE, (Object)taxRate));
            Tax tax = (Tax)criteria.uniqueResult();
            return tax;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(Tax tax, String code) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Tax.PROP_NAME, (Object)code).ignoreCase());
            if (tax.getId() != null) {
                criteria.add((Criterion)Restrictions.ne((String)Tax.PROP_ID, (Object)tax.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = rowCount.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tax> findAllUnSyncTax() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)Tax.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)Tax.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateTaxs(List<Tax> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Tax item : dataList) {
                Tax existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    String id = existingItem.getId();
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setId(id);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

