/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.BaseTaxGroupDAO;
import com.floreantpos.model.dao.TaxDAO;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class TaxGroupDAO
extends BaseTaxGroupDAO {
    @Override
    protected void delete(Object obj, Session session) {
        TaxGroup taxGroup = (TaxGroup)obj;
        if (taxGroup == null) {
            throw new PosException(Messages.getString("TaxGroupDAO.0"));
        }
        taxGroup.setDeleted(true);
        this.update(taxGroup, session);
    }

    @Override
    public List<TaxGroup> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public List<TaxGroup> findByTaxTypeOrSubtype(String taxType, String taxSubtype, String billingRecordType) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotBlank((String)taxType)) {
                criteria.add(Restrictions.ilike((String)TaxGroup.PROP_TYPE, (String)taxType.trim(), (MatchMode)MatchMode.EXACT));
            }
            if (StringUtils.isNotBlank((String)taxSubtype)) {
                criteria.add(Restrictions.ilike((String)TaxGroup.PROP_SUB_TYPE, (String)taxSubtype.trim(), (MatchMode)MatchMode.EXACT));
            }
            if (StringUtils.isNotBlank((String)billingRecordType)) {
                criteria.add(Restrictions.ilike((String)TaxGroup.PROP_BILLING_RECORD_TYPE, (String)billingRecordType.trim(), (MatchMode)MatchMode.EXACT));
            }
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTaxGroup(TaxGroup group) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            TaxGroup taxGroup = null;
            if (StringUtils.isNotEmpty((String)group.getId())) {
                taxGroup = this.get(group.getId());
            }
            if (taxGroup == null) {
                session.merge((Object)group);
            } else {
                taxGroup.setName(group.getName());
                List<Tax> existedTaxes = taxGroup.getTaxes();
                for (Tax newTax : group.getTaxes()) {
                    if (newTax.getId() == null) {
                        taxGroup.addTotaxes(newTax);
                        continue;
                    }
                    for (Tax tax : existedTaxes) {
                        if (!tax.getId().equals(newTax.getId())) continue;
                        tax.setName(newTax.getName());
                        tax.setEnable(newTax.isEnable());
                        tax.setRate(newTax.getRate());
                    }
                }
                session.update((Object)taxGroup);
            }
            tx.commit();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSFItems(List<TaxGroup> items) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (TaxGroup taxGroup : items) {
                TaxGroup existedTaxGroup = null;
                if (!this.hasTaxGroupByName(taxGroup.getName())) {
                    session.merge((Object)taxGroup);
                    continue;
                }
                existedTaxGroup = TaxGroupDAO.getInstance().get(taxGroup.getId(), session);
                existedTaxGroup.setName(taxGroup.getName());
                List<Tax> existedTaxes = existedTaxGroup.getTaxes();
                if (taxGroup.getTaxes() != null) {
                    if (existedTaxes.isEmpty()) {
                        for (Tax tax : taxGroup.getTaxes()) {
                            Tax extingTax = TaxDAO.getInstance().get(tax.getId(), session);
                            if (existedTaxes == null) {
                                existedTaxGroup.addTotaxes(tax);
                                continue;
                            }
                            tax = extingTax;
                        }
                    } else {
                        for (Tax tax : taxGroup.getTaxes()) {
                            boolean isExisted = false;
                            for (Tax existedTax : existedTaxes) {
                                if (!existedTax.getId().equals(tax.getId())) continue;
                                existedTax.setRate(tax.getRate());
                                isExisted = true;
                            }
                            if (isExisted) continue;
                            existedTaxGroup.addTotaxes(tax);
                        }
                    }
                }
                session.update((Object)existedTaxGroup);
            }
            tx.commit();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTaxGroupByName(String taxGroupName) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)TaxGroup.PROP_NAME, (Object)taxGroupName));
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                boolean bl = rowCount.intValue() > 0;
                return bl;
            }
        }
        catch (Exception e) {
            PosLog.error(this.getReferenceClass(), e);
        }
        finally {
            this.closeSession(session);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxGroup findTaxGroupByName(String taxGroupName) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)TaxGroup.PROP_NAME, (Object)taxGroupName));
            List list = criteria.list();
            if (list != null) {
                TaxGroup taxGroup = (TaxGroup)list.get(0);
                return taxGroup;
            }
        }
        catch (Exception e) {
            PosLog.error(this.getReferenceClass(), e);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }
}

