/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.dao.BaseTerminalTypeDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.teminaltype.TerminalCategory;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class TerminalTypeDAO
extends BaseTerminalTypeDAO {
    private static final String EMPTY_STRING = "";
    private static final String EMPTY_NEWLINE_STRING = "\n";
    private static final String EMPTY_DOT_STRING = ".";
    private static final String EMPTY_SPACE_STRING = " ";

    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    protected void delete(Object obj, Session s) {
        if (obj instanceof TerminalType) {
            String detailsMessage;
            TerminalType terminalType = (TerminalType)obj;
            List<OrderType> orderTypes = OrderTypeDAO.getInstance().getOrderTypesByTerminalType(terminalType, s);
            List<Terminal> terminals = TerminalDAO.getInstance().getTerminalsByTerminalType(terminalType, s);
            String message = Messages.getString("TerminalTypeDAO.4");
            StringBuilder details = new StringBuilder();
            if (orderTypes != null && !orderTypes.isEmpty()) {
                details.append(this.constructExceptionDetailsByOrderType(terminalType, orderTypes));
                details.append(EMPTY_NEWLINE_STRING);
            }
            if (terminals != null && !terminals.isEmpty()) {
                details.append(this.constructExceptionDetailsByTerminal(terminalType, terminals));
            }
            if (StringUtils.isNotBlank((String)(detailsMessage = details.toString()))) {
                throw new PosException(message, detailsMessage);
            }
            terminalType.setDeleted(Boolean.TRUE);
            super.update(terminalType, s);
        } else {
            super.delete(obj, s);
        }
    }

    private String constructExceptionDetailsByOrderType(TerminalType terminalType, List<OrderType> orderTypes) {
        if (orderTypes != null && !orderTypes.isEmpty()) {
            StringBuilder builder = new StringBuilder(terminalType.getName() + EMPTY_SPACE_STRING + Messages.getString("TerminalTypeDAO.5"));
            for (int i = 0; i < orderTypes.size(); ++i) {
                String message = i + 1 + EMPTY_DOT_STRING + EMPTY_SPACE_STRING + orderTypes.get(i).getName();
                builder.append(EMPTY_NEWLINE_STRING).append(message);
            }
            return builder.toString();
        }
        return EMPTY_STRING;
    }

    private String constructExceptionDetailsByTerminal(TerminalType terminalType, List<Terminal> terminals) {
        if (terminals != null && !terminals.isEmpty()) {
            StringBuilder builder = new StringBuilder(terminalType.getName() + EMPTY_SPACE_STRING + Messages.getString("TerminalTypeDAO.6"));
            for (int i = 0; i < terminals.size(); ++i) {
                String message = i + 1 + EMPTY_DOT_STRING + EMPTY_SPACE_STRING + terminals.get(i).getName();
                builder.append(EMPTY_NEWLINE_STRING).append(message);
            }
            return builder.toString();
        }
        return EMPTY_STRING;
    }

    @Override
    public List<TerminalType> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public void initialize(TerminalType terminalType) {
        if (terminalType == null || terminalType.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(terminalType.getOrderTypes()) && Hibernate.isInitialized(terminalType.getCategories())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)terminalType);
            Hibernate.initialize(terminalType.getOrderTypes());
            Hibernate.initialize(terminalType.getCategories());
        }
        finally {
            this.closeSession(session);
        }
    }

    public boolean nameExists(TerminalType terminalType, String name) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)TerminalType.PROP_NAME, (Object)name).ignoreCase());
            if (terminalType.getId() != null) {
                criteria.add((Criterion)Restrictions.ne((String)TerminalType.PROP_ID, (Object)terminalType.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            boolean bl = rowCount != null && rowCount.intValue() > 0;
            return bl;
        }
    }

    public TerminalType getTerminalType(TerminalCategory category) {
        if (category == null) {
            TerminalType thisTerminalType = Application.getInstance().getTerminal().getTerminalType();
            if (thisTerminalType != null) {
                return thisTerminalType;
            }
            category = TerminalCategory.REGULAR;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)TerminalType.PROP_TYPE, (Object)category.getType()));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                TerminalType terminalType = (TerminalType)list.get(0);
                return terminalType;
            }
            TerminalType terminalType = null;
            return terminalType;
        }
    }

    public void saveOrUpdateTerminalTypes(List terminalTypeList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (terminalTypeList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (TerminalType item : terminalTypeList) {
                TerminalTypeDAO dao = TerminalTypeDAO.getInstance();
                TerminalType existingItem = dao.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    dao.update(existingItem);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                dao.save(item);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

